/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;

@GwtCompatible(serializable=false)
public strictfp class S2EdgeUtil {
    public static final S1Angle DEFAULT_INTERSECTION_TOLERANCE = S1Angle.radians(1.5E-15);
    private static final double MAX_DET_ERROR = 1.0E-14;
    public static final double FACE_CLIP_ERROR_RADIANS = 3.0 * S2.DBL_EPSILON;
    public static final double FACE_CLIP_ERROR_UV_DIST = 9.0 * S2.DBL_EPSILON;
    public static final double FACE_CLIP_ERROR_UV_COORD = 9.0 * S2.M_SQRT1_2 * S2.DBL_EPSILON;
    public static final double INTERSECTS_RECT_ERROR_UV_DIST = 3.0 * S2.M_SQRT2 * S2.DBL_EPSILON;
    public static final double EDGE_CLIP_ERROR_UV_COORD = 2.25 * S2.DBL_EPSILON;
    public static final double EDGE_CLIP_ERROR_UV_DIST = 2.25 * S2.DBL_EPSILON;
    public static final double MAX_CELL_EDGE_ERROR = FACE_CLIP_ERROR_UV_COORD + INTERSECTS_RECT_ERROR_UV_DIST;

    public static WedgeRelation getWedgeRelation(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
        if (a0.equalsPoint(b0) && a2.equalsPoint(b2)) {
            return WedgeRelation.WEDGE_EQUALS;
        }
        if (S2.orderedCCW(a0, a2, b2, ab1)) {
            if (S2.orderedCCW(b2, b0, a0, ab1)) {
                return WedgeRelation.WEDGE_PROPERLY_CONTAINS;
            }
            if (a2.equalsPoint(b2)) {
                return WedgeRelation.WEDGE_IS_PROPERLY_CONTAINED;
            }
            return WedgeRelation.WEDGE_PROPERLY_OVERLAPS;
        }
        if (S2.orderedCCW(a0, b0, b2, ab1)) {
            return WedgeRelation.WEDGE_IS_PROPERLY_CONTAINED;
        }
        if (S2.orderedCCW(a0, b0, a2, ab1)) {
            return WedgeRelation.WEDGE_IS_DISJOINT;
        }
        return WedgeRelation.WEDGE_PROPERLY_OVERLAPS;
    }

    static boolean sumEquals(double u, double v, double w) {
        return u + v == w && u == w - v && v == w - u;
    }

    static boolean intersectsFace(S2Point n) {
        double w;
        double u = Math.abs(n.x);
        double v = Math.abs(n.y);
        return v >= (w = Math.abs(n.z)) - u && u >= w - v;
    }

    static boolean intersectsOppositeEdges(S2Point n) {
        double u = Math.abs(n.x);
        double v = Math.abs(n.y);
        double w = Math.abs(n.z);
        if (Math.abs(u - v) != w) {
            return Math.abs(u - v) >= w;
        }
        return u >= v ? u - w >= v : v - w >= u;
    }

    static int getExitAxis(S2Point n) {
        if (S2EdgeUtil.intersectsOppositeEdges(n)) {
            return Math.abs(n.x) >= Math.abs(n.y) ? 1 : 0;
        }
        return n.x < 0.0 ^ n.y < 0.0 ^ n.z < 0.0 ? 0 : 1;
    }

    static R2Vector getExitPoint(S2Point n, int axis) {
        if (axis == 0) {
            double u = n.y > 0.0 ? 1.0 : -1.0;
            return new R2Vector(u, (-u * n.x - n.z) / n.y);
        }
        double v = n.x < 0.0 ? 1.0 : -1.0;
        return new R2Vector((-v * n.y - n.z) / n.x, v);
    }

    static int moveOriginToValidFace(int face, S2Point a, S2Point ab, R2Vector aUv) {
        double kMaxSafeUVCoord = 1.0 - FACE_CLIP_ERROR_UV_COORD;
        if (Math.max(Math.abs(aUv.x), Math.abs(aUv.y)) <= kMaxSafeUVCoord) {
            return face;
        }
        S2Point n = S2Projections.faceXyzToUvw(face, ab);
        if (S2EdgeUtil.intersectsFace(n)) {
            S2Point exit = S2Projections.faceUvToXyz(face, S2EdgeUtil.getExitPoint(n, S2EdgeUtil.getExitAxis(n)));
            S2Point aTangent = S2Point.crossProd(S2Point.normalize(ab), a);
            if (S2Point.sub(exit, a).dotProd(aTangent) >= -FACE_CLIP_ERROR_RADIANS) {
                return face;
            }
        }
        face = Math.abs(aUv.x) >= Math.abs(aUv.y) ? S2Projections.getUVWFace(face, 0, aUv.x > 0.0 ? 1 : 0) : S2Projections.getUVWFace(face, 1, aUv.y > 0.0 ? 1 : 0);
        S2Projections.validFaceXyzToUv(face, a, aUv);
        aUv.set(Math.max(-1.0, Math.min(1.0, aUv.x)), Math.max(-1.0, Math.min(1.0, aUv.y)));
        return face;
    }

    static int getNextFace(int face, R2Vector exit, int axis, S2Point n, int targetFace) {
        if (Math.abs(exit.get(1 - axis)) == 1.0 && S2Projections.getUVWFace(face, 1 - axis, exit.get(1 - axis) > 0.0 ? 1 : 0) == targetFace && S2EdgeUtil.sumEquals(exit.x * n.x, exit.y * n.y, -n.z)) {
            return targetFace;
        }
        return S2Projections.getUVWFace(face, axis, exit.get(axis) > 0.0 ? 1 : 0);
    }

    static int getFaceSegments(S2Point a, S2Point b, FaceSegment[] segments) {
        int size = 0;
        int aFace = S2Projections.xyzToFace(a);
        R2Vector aSeg = S2Projections.validFaceXyzToUv(aFace, a);
        int bFace = S2Projections.xyzToFace(b);
        R2Vector bSeg = S2Projections.validFaceXyzToUv(bFace, b);
        if (aFace == bFace) {
            segments[size++] = new FaceSegment(aFace, aSeg, bSeg);
        } else {
            S2Point ab = S2.robustCrossProd(a, b);
            aFace = S2EdgeUtil.moveOriginToValidFace(aFace, a, ab, aSeg);
            bFace = S2EdgeUtil.moveOriginToValidFace(bFace, b, S2Point.neg(ab), bSeg);
            R2Vector bSaved = bSeg;
            int face = aFace;
            while (face != bFace) {
                S2Point n = S2Projections.faceXyzToUvw(face, ab);
                int exitAxis = S2EdgeUtil.getExitAxis(n);
                bSeg = S2EdgeUtil.getExitPoint(n, exitAxis);
                segments[size++] = new FaceSegment(face, aSeg, bSeg);
                S2Point exitXyz = S2Projections.faceUvToXyz(face, bSeg);
                face = S2EdgeUtil.getNextFace(face, bSeg, exitAxis, n, bFace);
                S2Point exitUvw = S2Projections.faceXyzToUvw(face, exitXyz);
                aSeg = new R2Vector(exitUvw.x, exitUvw.y);
            }
            segments[size++] = new FaceSegment(bFace, aSeg, bSaved);
        }
        return size;
    }

    static int clipDestination(S2Point a, S2Point b, S2Point nScaled, S2Point aTangent, S2Point bTangent, double uvScale, R2Vector uv) {
        double kMaxSafeUVCoord = 1.0 - FACE_CLIP_ERROR_UV_COORD;
        if (b.z > 0.0) {
            uv.set(b.x / b.z, b.y / b.z);
            if (Math.max(Math.abs(uv.x), Math.abs(uv.y)) <= kMaxSafeUVCoord) {
                return 0;
            }
        }
        R2Vector exit = S2EdgeUtil.getExitPoint(nScaled, S2EdgeUtil.getExitAxis(nScaled));
        uv.set(uvScale * exit.x, uvScale * exit.y);
        S2Point p = new S2Point(uv.x, uv.y, 1.0);
        int score = 0;
        if (S2Point.sub(p, a).dotProd(aTangent) < 0.0) {
            score = 2;
        } else if (S2Point.sub(p, b).dotProd(bTangent) < 0.0) {
            score = 1;
        }
        if (score > 0) {
            if (b.z <= 0.0) {
                score = 3;
            } else {
                uv.set(b.x / b.z, b.y / b.z);
            }
        }
        return score;
    }

    static boolean clipToPaddedFace(S2Point aXyz, S2Point bXyz, int face, double padding, R2Vector aUv, R2Vector bUv) {
        int bScore;
        if (S2Projections.xyzToFace(aXyz) == face && S2Projections.xyzToFace(bXyz) == face) {
            S2Projections.validFaceXyzToUv(face, aXyz, aUv);
            S2Projections.validFaceXyzToUv(face, bXyz, bUv);
            return true;
        }
        S2Point n = S2Projections.faceXyzToUvw(face, S2.robustCrossProd(aXyz, bXyz));
        S2Point a = S2Projections.faceXyzToUvw(face, aXyz);
        S2Point b = S2Projections.faceXyzToUvw(face, bXyz);
        double uvScale = 1.0 + padding;
        S2Point nScaled = new S2Point(uvScale * n.x, uvScale * n.y, n.z);
        if (!S2EdgeUtil.intersectsFace(nScaled)) {
            return false;
        }
        if (Math.max(Math.abs(n.x), Math.max(Math.abs(n.y), Math.abs(n.z))) < Math.scalb(1.0, -511)) {
            n = S2Point.mul(n, Math.scalb(1.0, 563));
        }
        n = S2Point.normalize(n);
        S2Point aTangent = S2Point.crossProd(n, a);
        S2Point bTangent = S2Point.crossProd(b, n);
        int aScore = S2EdgeUtil.clipDestination(b, a, S2Point.neg(nScaled), bTangent, aTangent, uvScale, aUv);
        return aScore + (bScore = S2EdgeUtil.clipDestination(a, b, nScaled, aTangent, bTangent, uvScale, bUv)) < 3;
    }

    static boolean intersectsRect(R2Vector a, R2Vector b, R2Rect rect) {
        R2Rect bound = R2Rect.fromPointPair(a, b);
        if (!rect.intersects(bound)) {
            return false;
        }
        R2Vector n = R2Vector.sub(b, a).ortho();
        int i = n.x >= 0.0 ? 1 : 0;
        int j = n.y >= 0.0 ? 1 : 0;
        double max = n.dotProd(R2Vector.sub(rect.getVertex(i, j), a));
        double min = n.dotProd(R2Vector.sub(rect.getVertex(1 - i, 1 - j), a));
        return max >= 0.0 && min <= 0.0;
    }

    static boolean updateEndpoint(R1Interval bound, boolean slopeNegative, double value) {
        if (!slopeNegative) {
            if (bound.hi() < value) {
                return false;
            }
            if (bound.lo() < value) {
                bound.setLo(value);
            }
        } else {
            if (bound.lo() > value) {
                return false;
            }
            if (bound.hi() > value) {
                bound.setHi(value);
            }
        }
        return true;
    }

    static boolean clipBoundAxis(double a0, double b0, R1Interval bound0, double a1, double b1, R1Interval bound1, boolean slopeNegative, R1Interval clip0) {
        if (bound0.lo() < clip0.lo()) {
            if (bound0.hi() < clip0.lo()) {
                return false;
            }
            bound0.setLo(clip0.lo());
            if (!S2EdgeUtil.updateEndpoint(bound1, slopeNegative, S2EdgeUtil.interpolateDouble(clip0.lo(), a0, b0, a1, b1))) {
                return false;
            }
        }
        if (bound0.hi() > clip0.hi()) {
            if (bound0.lo() > clip0.hi()) {
                return false;
            }
            bound0.setHi(clip0.hi());
            if (!S2EdgeUtil.updateEndpoint(bound1, !slopeNegative, S2EdgeUtil.interpolateDouble(clip0.hi(), a0, b0, a1, b1))) {
                return false;
            }
        }
        return true;
    }

    static R2Rect getClippedEdgeBound(R2Vector a, R2Vector b, R2Rect clip) {
        R2Rect bound = R2Rect.fromPointPair(a, b);
        if (S2EdgeUtil.clipEdgeBound(a, b, clip, bound)) {
            return bound;
        }
        return R2Rect.empty();
    }

    static boolean clipEdgeBound(R2Vector a, R2Vector b, R2Rect clip, R2Rect bound) {
        boolean slopeNegative = a.x > b.x != a.y > b.y;
        return S2EdgeUtil.clipBoundAxis(a.x, b.x, bound.x(), a.y, b.y, bound.y(), slopeNegative, clip.x()) && S2EdgeUtil.clipBoundAxis(a.y, b.y, bound.y(), a.x, b.x, bound.x(), slopeNegative, clip.y());
    }

    static boolean clipEdge(R2Vector a, R2Vector b, R2Rect clip, R2Vector aClipped, R2Vector bClipped) {
        R2Rect bound = R2Rect.fromPointPair(a, b);
        if (S2EdgeUtil.clipEdgeBound(a, b, clip, bound)) {
            int iEnd = a.x > b.x ? 1 : 0;
            int jEnd = a.y > b.y ? 1 : 0;
            aClipped.set(bound.getVertex(iEnd, jEnd));
            bClipped.set(bound.getVertex(1 - iEnd, 1 - jEnd));
            return true;
        }
        return false;
    }

    static double interpolateDouble(double x, double a, double b, double a1, double b1) {
        if (Math.abs(a - x) <= Math.abs(b - x)) {
            return a1 + (b1 - a1) * (x - a) / (b - a);
        }
        return b1 + (a1 - b1) * (x - b) / (a - b);
    }

    static boolean clipToFace(S2Point a, S2Point b, int face, R2Vector aUv, R2Vector bUv) {
        return S2EdgeUtil.clipToPaddedFace(a, b, face, 0.0, aUv, bUv);
    }

    public static boolean simpleCrossing(S2Point a, S2Point b, S2Point c, S2Point d) {
        double bda;
        S2Point ab = S2Point.crossProd(a, b);
        double acb = -ab.dotProd(c);
        if (acb * (bda = ab.dotProd(d)) <= 0.0) {
            return false;
        }
        S2Point cd = S2Point.crossProd(c, d);
        double cbd = -cd.dotProd(b);
        double dac = cd.dotProd(a);
        return acb * cbd > 0.0 && acb * dac > 0.0;
    }

    public static int robustCrossing(S2Point a, S2Point b, S2Point c, S2Point d) {
        EdgeCrosser crosser = new EdgeCrosser(a, b, c);
        return crosser.robustCrossing(d);
    }

    public static boolean vertexCrossing(S2Point a, S2Point b, S2Point c, S2Point d) {
        if (a.equalsPoint(b) || c.equalsPoint(d)) {
            return false;
        }
        if (a.equalsPoint(d)) {
            return S2.orderedCCW(S2.ortho(a), c, b, a);
        }
        if (b.equalsPoint(c)) {
            return S2.orderedCCW(S2.ortho(b), d, a, b);
        }
        if (a.equalsPoint(c)) {
            return S2.orderedCCW(S2.ortho(a), d, b, a);
        }
        if (b.equalsPoint(d)) {
            return S2.orderedCCW(S2.ortho(b), c, a, b);
        }
        return false;
    }

    public static boolean edgeOrVertexCrossing(S2Point a, S2Point b, S2Point c, S2Point d) {
        int crossing = S2EdgeUtil.robustCrossing(a, b, c, d);
        if (crossing < 0) {
            return false;
        }
        if (crossing > 0) {
            return true;
        }
        return S2EdgeUtil.vertexCrossing(a, b, c, d);
    }

    public static final boolean lenientCrossing(S2Point a, S2Point b, S2Point c, S2Point d) {
        double acb = S2Point.scalarTripleProduct(b, a, c);
        if (Math.abs(acb) < 1.0E-14) {
            return true;
        }
        double bda = S2Point.scalarTripleProduct(a, b, d);
        if (Math.abs(bda) < 1.0E-14) {
            return true;
        }
        if (acb * bda < 0.0) {
            return false;
        }
        double cbd = S2Point.scalarTripleProduct(d, c, b);
        if (Math.abs(cbd) < 1.0E-14) {
            return true;
        }
        double dac = S2Point.scalarTripleProduct(c, d, a);
        if (Math.abs(dac) < 1.0E-14) {
            return true;
        }
        return acb * cbd >= 0.0 && acb * dac >= 0.0;
    }

    public static S2Point getIntersection(S2Point a0, S2Point a1, S2Point b0, S2Point b1) {
        Preconditions.checkArgument((S2EdgeUtil.robustCrossing(a0, a1, b0, b1) > 0 ? 1 : 0) != 0, (Object)"Input edges a0a1 and b0b1 must have a true robustCrossing.");
        S2Point aNorm = S2Point.normalize(S2.robustCrossProd(a0, a1));
        S2Point bNorm = S2Point.normalize(S2.robustCrossProd(b0, b1));
        S2Point x = S2Point.normalize(S2.robustCrossProd(aNorm, bNorm));
        if (x.dotProd(S2Point.add(S2Point.add(a0, a1), S2Point.add(b0, b1))) < 0.0) {
            x = S2Point.neg(x);
        }
        if (S2.orderedCCW(a0, x, a1, aNorm) && S2.orderedCCW(b0, x, b1, bNorm)) {
            return x;
        }
        CloserResult r = new CloserResult(10.0, x);
        if (S2.orderedCCW(b0, a0, b1, bNorm)) {
            r.replaceIfCloser(x, a0);
        }
        if (S2.orderedCCW(b0, a1, b1, bNorm)) {
            r.replaceIfCloser(x, a1);
        }
        if (S2.orderedCCW(a0, b0, a1, aNorm)) {
            r.replaceIfCloser(x, b0);
        }
        if (S2.orderedCCW(a0, b1, a1, aNorm)) {
            r.replaceIfCloser(x, b1);
        }
        return r.getVmin();
    }

    public static double getDistanceFraction(S2Point x, S2Point a0, S2Point a1) {
        Preconditions.checkArgument((!a0.equalsPoint(a1) ? 1 : 0) != 0);
        double d0 = x.angle(a0);
        double d1 = x.angle(a1);
        return d0 / (d0 + d1);
    }

    public static S1Angle getDistance(S2Point x, S2Point a, S2Point b) {
        Preconditions.checkArgument((boolean)S2.isUnitLength(x), (String)"S2Point not normalized: %s", (Object[])new Object[]{x});
        Preconditions.checkArgument((boolean)S2.isUnitLength(a), (String)"S2Point not normalized: %s", (Object[])new Object[]{a});
        Preconditions.checkArgument((boolean)S2.isUnitLength(b), (String)"S2Point not normalized: %s", (Object[])new Object[]{b});
        return S1Angle.radians(S2EdgeUtil.getDistanceRadians(x, a, b, S2.robustCrossProd(a, b)));
    }

    public static S1ChordAngle updateMinDistance(S2Point x, S2Point a, S2Point b, S1ChordAngle minDistance) {
        Preconditions.checkArgument((boolean)S2.isUnitLength(x), (String)"S2Point not normalized: %s", (Object[])new Object[]{x});
        Preconditions.checkArgument((boolean)S2.isUnitLength(a), (String)"S2Point not normalized: %s", (Object[])new Object[]{a});
        Preconditions.checkArgument((boolean)S2.isUnitLength(b), (String)"S2Point not normalized: %s", (Object[])new Object[]{b});
        double xa2 = x.getDistance2(a);
        double xb2 = x.getDistance2(b);
        double ab2 = a.getDistance2(b);
        double dist2 = Math.min(xa2, xb2);
        if (xa2 + xb2 < ab2 + 2.0 * dist2) {
            S2Point c = S2.robustCrossProd(a, b);
            double c2 = c.norm2();
            double xDotC = x.dotProd(c);
            double xDotC2 = xDotC * xDotC;
            if (xDotC2 >= c2 * minDistance.getLength2()) {
                return minDistance;
            }
            S2Point cx = S2Point.crossProd(c, x);
            if (a.dotProd(cx) < 0.0 && b.dotProd(cx) > 0.0) {
                double qr = 1.0 - Math.sqrt(cx.norm2() / c2);
                dist2 = xDotC2 / c2 + qr * qr;
            }
        }
        if (dist2 >= minDistance.getLength2()) {
            return minDistance;
        }
        return S1ChordAngle.fromLength2(dist2);
    }

    public static S1Angle getDistance(S2Point x, S2Point a, S2Point b, S2Point aCrossB) {
        Preconditions.checkArgument((boolean)S2.isUnitLength(x), (String)"S2Point not normalized: %s", (Object[])new Object[]{x});
        Preconditions.checkArgument((boolean)S2.isUnitLength(a), (String)"S2Point not normalized: %s", (Object[])new Object[]{a});
        Preconditions.checkArgument((boolean)S2.isUnitLength(b), (String)"S2Point not normalized: %s", (Object[])new Object[]{b});
        return S1Angle.radians(S2EdgeUtil.getDistanceRadians(x, a, b, aCrossB));
    }

    public static double getDistanceRadians(S2Point x, S2Point a, S2Point b, S2Point aCrossB) {
        if (S2.simpleCCW(aCrossB, a, x) && S2.simpleCCW(x, b, aCrossB)) {
            double sinDist = Math.abs(x.dotProd(aCrossB)) / aCrossB.norm();
            return Math.asin(Math.min(1.0, sinDist));
        }
        double linearDist2 = Math.min(S2EdgeUtil.diffMag2(x, a), S2EdgeUtil.diffMag2(x, b));
        return 2.0 * Math.asin(Math.min(1.0, 0.5 * Math.sqrt(linearDist2)));
    }

    private static final double diffMag2(S2Point a, S2Point b) {
        double dx = a.getX() - b.getX();
        double dy = a.getY() - b.getY();
        double dz = a.getZ() - b.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public static S2Point getClosestPoint(S2Point x, S2Point a, S2Point b, S2Point aCrossB) {
        S2Point p = S2Point.sub(x, S2Point.mul(aCrossB, x.dotProd(aCrossB) / aCrossB.norm2()));
        if (S2.simpleCCW(aCrossB, a, p) && S2.simpleCCW(p, b, aCrossB)) {
            return S2Point.normalize(p);
        }
        return x.getDistance2(a) <= x.getDistance2(b) ? a : b;
    }

    public static S2Point getClosestPoint(S2Point x, S2Point a, S2Point b) {
        return S2EdgeUtil.getClosestPoint(x, a, b, S2.robustCrossProd(a, b));
    }

    public static S2Point interpolateAtDistance(S1Angle ax, S2Point a, S2Point b, S1Angle ab) {
        double axRadians = ax.radians();
        double abRadians = ab.radians();
        double f = Math.sin(axRadians) / Math.sin(abRadians);
        double e = Math.cos(axRadians) - f * Math.cos(abRadians);
        return S2Point.normalize(S2Point.add(S2Point.mul(a, e), S2Point.mul(b, f)));
    }

    public static S2Point interpolateAtDistance(S1Angle ax, S2Point a, S2Point b) {
        return S2EdgeUtil.interpolateAtDistance(ax, a, b, new S1Angle(a, b));
    }

    public static S2Point interpolate(double t, S2Point a, S2Point b) {
        if (t == 0.0) {
            return a;
        }
        if (t == 1.0) {
            return b;
        }
        S1Angle ab = new S1Angle(a, b);
        return S2EdgeUtil.interpolateAtDistance(S1Angle.radians(t * ab.radians()), a, b, ab);
    }

    private S2EdgeUtil() {
    }

    strictfp static class CloserResult {
        private double dmin2;
        private S2Point vmin;

        public double getDmin2() {
            return this.dmin2;
        }

        public S2Point getVmin() {
            return this.vmin;
        }

        public CloserResult(double dmin2, S2Point vmin) {
            this.dmin2 = dmin2;
            this.vmin = vmin;
        }

        public void replaceIfCloser(S2Point x, S2Point y) {
            double d2 = S2Point.minus(x, y).norm2();
            if (d2 < this.dmin2 || d2 == this.dmin2 && y.lessThan(this.vmin)) {
                this.dmin2 = d2;
                this.vmin = y;
            }
        }
    }

    strictfp static final class FaceSegment {
        final int face;
        final R2Vector a;
        final R2Vector b;

        public FaceSegment(int face, R2Vector a, R2Vector b) {
            this.face = face;
            this.a = a;
            this.b = b;
        }
    }

    public strictfp static class WedgeContainsOrCrosses
    implements WedgeProcessor {
        @Override
        public int test(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            if (S2.orderedCCW(a0, a2, b2, ab1)) {
                if (S2.orderedCCW(b2, b0, a0, ab1)) {
                    return 1;
                }
                return a2.equalsPoint(b2) ? 0 : -1;
            }
            return S2.orderedCCW(a0, b0, a2, ab1) ? 0 : -1;
        }
    }

    public strictfp static class WedgeContainsOrIntersects
    implements WedgeProcessor {
        @Override
        public int test(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            if (S2.orderedCCW(a0, a2, b2, ab1)) {
                return S2.orderedCCW(b2, b0, a0, ab1) ? 1 : -1;
            }
            if (!S2.orderedCCW(a2, b0, b2, ab1)) {
                return 0;
            }
            return a2.equalsPoint(b0) ? 0 : -1;
        }
    }

    public strictfp static class WedgeIntersects
    implements WedgeProcessor {
        @Override
        public int test(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            return S2.orderedCCW(a0, b2, b0, ab1) && S2.orderedCCW(b0, a2, a0, ab1) ? 0 : -1;
        }
    }

    public strictfp static class WedgeContains
    implements WedgeProcessor {
        @Override
        public int test(S2Point a0, S2Point ab1, S2Point a2, S2Point b0, S2Point b2) {
            return S2.orderedCCW(a2, b2, b0, ab1) && S2.orderedCCW(b0, a0, a2, ab1) ? 1 : 0;
        }
    }

    public static interface WedgeProcessor {
        public int test(S2Point var1, S2Point var2, S2Point var3, S2Point var4, S2Point var5);
    }

    strictfp static enum WedgeRelation {
        WEDGE_EQUALS,
        WEDGE_PROPERLY_CONTAINS,
        WEDGE_IS_PROPERLY_CONTAINED,
        WEDGE_PROPERLY_OVERLAPS,
        WEDGE_IS_DISJOINT;

    }

    public strictfp static class LongitudePruner {
        private S1Interval interval;
        private double lng0;

        public LongitudePruner(S1Interval interval, S2Point v0) {
            this.interval = interval;
            this.lng0 = S2LatLng.longitude(v0).radians();
        }

        public boolean intersects(S2Point v1) {
            double lng1 = S2LatLng.longitude(v1).radians();
            boolean result = this.interval.intersects(S1Interval.fromPointPair(this.lng0, lng1));
            this.lng0 = lng1;
            return result;
        }
    }

    public strictfp static class XYZPruner {
        private S2Point lastVertex;
        private boolean boundSet = false;
        private double xmin;
        private double ymin;
        private double zmin;
        private double xmax;
        private double ymax;
        private double zmax;
        private double maxDeformation;

        public void addEdgeToBounds(S2Point from, S2Point to) {
            if (!this.boundSet) {
                this.boundSet = true;
                this.xmin = this.xmax = from.x;
                this.ymin = this.ymax = from.y;
                this.zmin = this.zmax = from.z;
            }
            this.xmin = Math.min(this.xmin, Math.min(to.x, from.x));
            this.ymin = Math.min(this.ymin, Math.min(to.y, from.y));
            this.zmin = Math.min(this.zmin, Math.min(to.z, from.z));
            this.xmax = Math.max(this.xmax, Math.max(to.x, from.x));
            this.ymax = Math.max(this.ymax, Math.max(to.y, from.y));
            this.zmax = Math.max(this.zmax, Math.max(to.z, from.z));
            double approxArcLen = Math.abs(from.x - to.x) + Math.abs(from.y - to.y) + Math.abs(from.z - to.z);
            this.maxDeformation = approxArcLen < 0.025 ? Math.max(this.maxDeformation, approxArcLen * 0.0025) : (approxArcLen < 1.0 ? Math.max(this.maxDeformation, approxArcLen * 0.11) : approxArcLen * 0.5);
        }

        public void setFirstIntersectPoint(S2Point v0) {
            this.xmin -= this.maxDeformation;
            this.ymin -= this.maxDeformation;
            this.zmin -= this.maxDeformation;
            this.xmax += this.maxDeformation;
            this.ymax += this.maxDeformation;
            this.zmax += this.maxDeformation;
            this.lastVertex = v0;
        }

        public boolean intersects(S2Point v1) {
            boolean result = true;
            if (v1.x < this.xmin && this.lastVertex.x < this.xmin || v1.x > this.xmax && this.lastVertex.x > this.xmax) {
                result = false;
            } else if (v1.y < this.ymin && this.lastVertex.y < this.ymin || v1.y > this.ymax && this.lastVertex.y > this.ymax) {
                result = false;
            } else if (v1.z < this.zmin && this.lastVertex.z < this.zmin || v1.z > this.zmax && this.lastVertex.z > this.zmax) {
                result = false;
            }
            this.lastVertex = v1;
            return result;
        }
    }

    public strictfp static class RectBounder {
        private S2LatLngRect.Builder builder = S2LatLngRect.Builder.empty();
        private S2Point a;
        private S2LatLng aLatLng;
        private final S1Interval lngAB = new S1Interval();
        private final R1Interval latAB = new R1Interval();

        public void addPoint(S2LatLng b) {
            this.addPoint(b.toPoint(), b);
        }

        public void addPoint(S2Point b) {
            this.addPoint(b, new S2LatLng(b));
        }

        private void addPoint(S2Point b, S2LatLng bLatLng) {
            if (this.builder.isEmpty()) {
                this.builder.addPoint(bLatLng);
            } else {
                S2Point n = S2Point.crossProd(S2Point.sub(this.a, b), S2Point.add(this.a, b));
                double nNorm = n.norm();
                if (nNorm < 1.91346E-15) {
                    if (this.a.dotProd(b) < 0.0) {
                        this.builder.setFull();
                    } else {
                        this.builder.union(S2LatLngRect.fromPointPair(this.aLatLng, bLatLng));
                    }
                } else {
                    this.lngAB.initFromPointPair(this.aLatLng.lng().radians(), bLatLng.lng().radians());
                    if (this.lngAB.getLength() >= Math.PI - 2.0 * S2.DBL_EPSILON) {
                        this.lngAB.setFull();
                    }
                    this.latAB.initFromPointPair(this.aLatLng.lat().radians(), bLatLng.lat().radians());
                    S2Point m = S2Point.crossProd(n, S2Point.Z_POS);
                    double mDotA = m.dotProd(this.a);
                    double mDotB = m.dotProd(b);
                    double mError = 6.06638E-16 * nNorm + 6.83174E-31;
                    if (mDotA * mDotB < 0.0 || Math.abs(mDotA) <= mError || Math.abs(mDotB) <= mError) {
                        double maxLat = Math.min(1.5707963267948966, 3.0 * S2.DBL_EPSILON + Math.atan2(Math.sqrt(n.getX() * n.getX() + n.getY() * n.getY()), Math.abs(n.getZ())));
                        double latBudget = 2.0 * Math.asin(0.5 * S2Point.sub(this.a, b).norm() * Math.sin(maxLat));
                        double maxDelta = 0.5 * (latBudget - this.latAB.getLength()) + S2.DBL_EPSILON;
                        if (mDotA <= mError && mDotB >= -mError) {
                            this.latAB.setHi(Math.min(maxLat, this.latAB.hi() + maxDelta));
                        }
                        if (mDotB <= mError && mDotA >= -mError) {
                            this.latAB.setLo(Math.max(-maxLat, this.latAB.lo() - maxDelta));
                        }
                    }
                    this.builder.union(new S2LatLngRect(this.latAB, this.lngAB));
                }
            }
            this.a = b;
            this.aLatLng = bLatLng;
        }

        public S2LatLngRect getBound() {
            S2LatLng expansion = S2LatLng.fromRadians(2.0 * S2.DBL_EPSILON, 0.0);
            return this.builder.build().expanded(expansion).polarClosure();
        }

        static S2LatLng maxErrorForTests() {
            return S2LatLng.fromRadians(10.0 * S2.DBL_EPSILON, 1.0 * S2.DBL_EPSILON);
        }

        static S2LatLngRect expandForSubregions(S2LatLngRect bound) {
            if (bound.isEmpty()) {
                return bound;
            }
            double lngGap = Math.max(0.0, Math.PI - bound.lng().getLength() - 2.5 * S2.DBL_EPSILON);
            double minAbsLat = Math.max(bound.lat().lo(), -bound.lat().hi());
            double latGap1 = 1.5707963267948966 + bound.lat().lo();
            double latGap2 = 1.5707963267948966 - bound.lat().hi();
            if (minAbsLat >= 0.0 ? 2.0 * minAbsLat + lngGap < 1.354E-15 : (lngGap >= 1.5707963267948966 ? latGap1 + latGap2 < 1.687E-15 : Math.max(latGap1, latGap2) * lngGap < 1.765E-15)) {
                return S2LatLngRect.full();
            }
            double latExpansion = 9.0 * S2.DBL_EPSILON;
            double lngExpansion = lngGap <= 0.0 ? Math.PI : 0.0;
            return bound.expanded(S2LatLng.fromRadians(latExpansion, lngExpansion)).polarClosure();
        }
    }

    public strictfp static final class EdgeCrosser {
        private final S2Point a;
        private final S2Point b;
        private final S2Point aCrossB;
        private S2Point c;
        private int acb;
        int bdaReturn;
        private boolean hasTangents;
        private S2Point aTangent;
        private S2Point bTangent;

        public EdgeCrosser(S2Point a, S2Point b) {
            this.a = a;
            this.b = b;
            this.aCrossB = S2Point.crossProd(a, b);
        }

        public EdgeCrosser(S2Point a, S2Point b, S2Point c) {
            this(a, b);
            this.restartAt(c);
        }

        public void restartAt(S2Point c) {
            this.c = c;
            this.acb = -S2.robustCCW(this.a, this.b, c, this.aCrossB);
        }

        public int robustCrossing(S2Point d) {
            int bda = S2.triageCCW(this.aCrossB.dotProd(d));
            if (this.acb == -bda && bda != 0) {
                this.c = d;
                this.acb = -bda;
                return -1;
            }
            this.bdaReturn = bda;
            return this.robustCrossingInternal(d);
        }

        public boolean edgeOrVertexCrossing(S2Point d) {
            S2Point c2 = this.c;
            int crossing = this.robustCrossing(d);
            if (crossing < 0) {
                return false;
            }
            if (crossing > 0) {
                return true;
            }
            return S2EdgeUtil.vertexCrossing(this.a, this.b, c2, d);
        }

        private int robustCrossingInternal(S2Point d) {
            int result = this.robustCrossingInternal2(d);
            this.c = d;
            this.acb = -this.bdaReturn;
            return result;
        }

        private int robustCrossingInternal2(S2Point d) {
            if (this.a.equalsPoint(this.c) || this.a.equalsPoint(d) || this.b.equalsPoint(this.c) || this.b.equalsPoint(d)) {
                return 0;
            }
            if (!this.hasTangents) {
                S2Point norm = S2Point.normalize(S2.robustCrossProd(this.a, this.b));
                this.aTangent = S2Point.crossProd(this.a, norm);
                this.bTangent = S2Point.crossProd(norm, this.b);
                this.hasTangents = true;
            }
            double kError = (1.5 + 1.0 / Math.sqrt(3.0)) * S2.DBL_EPSILON;
            if (this.c.dotProd(this.aTangent) > kError && d.dotProd(this.aTangent) > kError || this.c.dotProd(this.bTangent) > kError && d.dotProd(this.bTangent) > kError) {
                return -1;
            }
            if (this.acb == 0) {
                this.acb = -S2.expensiveCCW(this.a, this.b, this.c);
            }
            if (this.bdaReturn == 0) {
                this.bdaReturn = S2.expensiveCCW(this.a, this.b, d);
            }
            if (this.bdaReturn != this.acb) {
                return -1;
            }
            S2Point cCrossD = S2Point.crossProd(this.c, d);
            int cbd = -S2.robustCCW(this.c, d, this.b, cCrossD);
            if (cbd != this.acb) {
                return -1;
            }
            int dac = S2.robustCCW(this.c, d, this.a, cCrossD);
            return dac == this.acb ? 1 : -1;
        }
    }
}

