/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResult;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResultOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponseOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatchOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptionsOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponseOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.EntityV3V1Converter;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class BaseDatastoreServiceProtoConverter {
    private static final String UNKNOWN_PROJECT_ID = "__unknown__";
    protected final DatastoreProtoConverter datastoreConverter;

    public BaseDatastoreServiceProtoConverter(DatastoreProtoConverter datastoreConverter) {
        this.datastoreConverter = datastoreConverter;
    }

    public DatastoreProtoConverter getDatastoreConverter() {
        return this.datastoreConverter;
    }

    public EntityV4Converter getEntityConverter() {
        return this.datastoreConverter.getEntityConverter();
    }

    public abstract DatastorePb.Transaction toV3Transaction(ByteString var1, String var2) throws InvalidConversionException;

    protected abstract ByteString toTransactionBytes(DatastorePb.Transaction var1) throws InvalidConversionException;

    public DatastorePb.GetRequest toV3GetRequest(ProjectIdAppIdResolver resolver, LookupRequestOrBuilder req, String app) throws InvalidConversionException {
        DatastorePb.GetRequest get = new DatastorePb.GetRequest();
        get.setAllowDeferred(true);
        if (!req.getReadOptionsOrBuilder().getTransaction().isEmpty()) {
            get.setTransaction(this.toV3Transaction(req.getReadOptionsOrBuilder().getTransaction(), app));
        } else if (req.getReadOptionsOrBuilder().getReadConsistency() == ReadOptions.ReadConsistency.STRONG) {
            get.setStrong(true);
        } else if (req.getReadOptionsOrBuilder().getReadConsistency() == ReadOptions.ReadConsistency.EVENTUAL) {
            get.setStrong(false);
            get.setFailoverMs(-1L);
        }
        for (Key key : req.getKeysList()) {
            get.addKey(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)key));
        }
        return get;
    }

    @VisibleForTesting
    public LookupRequest.Builder toV1LookupRequest(ProjectIdAppIdResolver resolver, DatastorePb.GetRequest req) throws InvalidConversionException {
        LookupRequest.Builder builder = LookupRequest.newBuilder();
        InvalidConversionException.checkConversion(req.isAllowDeferred(), "allow_deferred must be true", new Object[0]);
        if (req.hasTransaction()) {
            builder.getReadOptionsBuilder().setTransaction(this.toTransactionBytes(req.getTransaction()));
        } else if (req.isStrong()) {
            builder.getReadOptionsBuilder().setReadConsistency(ReadOptions.ReadConsistency.STRONG);
        } else if (req.hasStrong()) {
            builder.getReadOptionsBuilder().setReadConsistency(ReadOptions.ReadConsistency.EVENTUAL);
        }
        for (OnestoreEntity.Reference key : req.keys()) {
            builder.addKeys(EntityV3V1Converter.INSTANCE.toV1Key(resolver, key));
        }
        this.inferRequestHeader(builder);
        return builder;
    }

    protected void inferRequestHeader(LookupRequest.Builder reqV1) {
        reqV1.setProjectId(reqV1.getKeysCount() > 0 ? reqV1.getKeys(0).getPartitionIdOrBuilder().getProjectId() : UNKNOWN_PROJECT_ID);
    }

    public LookupResponse.Builder toV1LookupResponse(ProjectIdAppIdResolver resolver, DatastorePb.GetResponse res) throws InvalidConversionException {
        LookupResponse.Builder builder = LookupResponse.newBuilder();
        for (OnestoreEntity.Reference key : res.deferreds()) {
            builder.addDeferred(EntityV3V1Converter.INSTANCE.toV1Key(resolver, key));
        }
        for (DatastorePb.GetResponse.Entity entity : res.entitys()) {
            EntityResult.Builder entityResult = this.datastoreConverter.toV1EntityResult(resolver, entity);
            if (entity.hasEntity()) {
                builder.addFound(entityResult);
            }
            if (!entity.hasKey()) continue;
            builder.addMissing(entityResult);
        }
        return builder;
    }

    @VisibleForTesting
    public DatastorePb.GetResponse toV3GetResponse(ProjectIdAppIdResolver resolver, LookupResponseOrBuilder res) throws InvalidConversionException {
        DatastorePb.GetResponse result = new DatastorePb.GetResponse();
        result.setInOrder(false);
        for (Key key : res.getDeferredList()) {
            result.addDeferred(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)key));
        }
        for (EntityResult found : res.getFoundList()) {
            result.addEntity(this.datastoreConverter.toV3Entity(resolver, (EntityResultOrBuilder)found, false));
        }
        for (EntityResult missing : res.getMissingList()) {
            result.addEntity(this.datastoreConverter.toV3Entity(resolver, (EntityResultOrBuilder)missing, true));
        }
        return result;
    }

    public DatastorePb.Query toV3Query(ProjectIdAppIdResolver resolver, RunQueryRequestOrBuilder request, boolean allowInMemoryOperations, Collection<OnestoreEntity.CompositeIndex> indexes) throws InvalidConversionException {
        DatastorePb.Query result = this.datastoreConverter.toV3Query(resolver, request.getPartitionIdOrBuilder(), (QueryOrBuilder)request.getQuery());
        result.setCount(Integer.MAX_VALUE);
        result.setRequirePerfectPlan(!allowInMemoryOperations);
        ReadOptionsOrBuilder options = request.getReadOptionsOrBuilder();
        if (!options.getTransaction().isEmpty()) {
            result.setTransaction(this.toV3Transaction(options.getTransaction(), result.getApp()));
        } else if (options.getReadConsistency() == ReadOptions.ReadConsistency.STRONG) {
            result.setStrong(true);
        } else if (options.getReadConsistency() == ReadOptions.ReadConsistency.EVENTUAL) {
            result.setStrong(false);
            result.setFailoverMs(-1L);
        }
        result.mutableCompositeIndexs().addAll(indexes);
        return result;
    }

    @VisibleForTesting
    public RunQueryRequest.Builder toV1RunQueryRequest(ProjectIdAppIdResolver resolver, DatastorePb.Query query) throws InvalidConversionException {
        RunQueryRequest.Builder builder = RunQueryRequest.newBuilder();
        PartitionId.Builder partition = builder.getPartitionIdBuilder();
        partition.setProjectId(resolver.toProjectId(query.getApp()));
        if (!query.getNameSpace().isEmpty()) {
            partition.setNamespaceId(query.getNameSpace());
        }
        if (query.hasTransaction()) {
            builder.getReadOptionsBuilder().setTransaction(this.toTransactionBytes(query.getTransaction()));
        } else if (query.isStrong()) {
            builder.getReadOptionsBuilder().setReadConsistency(ReadOptions.ReadConsistency.STRONG);
        } else if (query.hasStrong()) {
            builder.getReadOptionsBuilder().setReadConsistency(ReadOptions.ReadConsistency.EVENTUAL);
        }
        builder.setQuery(this.datastoreConverter.toV1Query(resolver, query));
        this.inferRequestHeader(builder);
        return builder;
    }

    protected void inferRequestHeader(RunQueryRequest.Builder reqV1) {
        reqV1.setProjectId(reqV1.getPartitionId().getProjectId());
    }

    public RunQueryResponse.Builder toV1RunQueryResponse(ProjectIdAppIdResolver resolver, DatastorePb.QueryResult result, @Nullable Query parsedQuery) throws InvalidConversionException {
        RunQueryResponse.Builder builder = RunQueryResponse.newBuilder();
        builder.setBatch(this.datastoreConverter.toV1QueryResultBatch(resolver, result));
        if (parsedQuery != null) {
            builder.setQuery(parsedQuery);
        }
        return builder;
    }

    @VisibleForTesting
    public DatastorePb.QueryResult toV3QueryResult(ProjectIdAppIdResolver resolver, RunQueryResponseOrBuilder resp) throws InvalidConversionException {
        DatastorePb.QueryResult result = this.datastoreConverter.toV3QueryResult(resolver, (QueryResultBatchOrBuilder)resp.getBatch());
        return result;
    }

    protected void inferRequestHeader(CommitRequest.Builder reqV1) {
        for (Mutation mutation : reqV1.getMutationsList()) {
            switch (mutation.getOperationCase()) {
                case INSERT: {
                    reqV1.setProjectId(mutation.getInsert().getKey().getPartitionId().getProjectId());
                    return;
                }
                case UPDATE: {
                    reqV1.setProjectId(mutation.getUpdate().getKey().getPartitionId().getProjectId());
                    return;
                }
                case UPSERT: {
                    reqV1.setProjectId(mutation.getUpsert().getKey().getPartitionId().getProjectId());
                    return;
                }
                case DELETE: {
                    reqV1.setProjectId(mutation.getDelete().getPartitionId().getProjectId());
                    return;
                }
            }
        }
        reqV1.setProjectId(UNKNOWN_PROJECT_ID);
    }
}

