/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.document.CompressionTools;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.document.Fieldable;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldInfo;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldInfos;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldsReader;
import com.google.appengine.repackaged.org.apache.lucene.store.Directory;
import com.google.appengine.repackaged.org.apache.lucene.store.IndexInput;
import com.google.appengine.repackaged.org.apache.lucene.store.IndexOutput;
import com.google.appengine.repackaged.org.apache.lucene.store.RAMOutputStream;
import java.io.IOException;
import java.util.Iterator;

final class FieldsWriter {
    static final byte FIELD_IS_TOKENIZED = 1;
    static final byte FIELD_IS_BINARY = 2;
    static final byte FIELD_IS_COMPRESSED = 4;
    static final int FORMAT = 0;
    static final int FORMAT_VERSION_UTF8_LENGTH_IN_BYTES = 1;
    static final int FORMAT_LUCENE_3_0_NO_COMPRESSED_FIELDS = 2;
    static final int FORMAT_CURRENT = 1;
    private FieldInfos fieldInfos;
    private IndexOutput fieldsStream;
    private IndexOutput indexStream;
    private boolean doClose;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsWriter(Directory d, String segment, FieldInfos fn) throws IOException {
        block23: {
            String fieldsName;
            boolean success;
            block21: {
                this.fieldInfos = fn;
                success = false;
                fieldsName = segment + "." + "fdt";
                try {
                    this.fieldsStream = d.createOutput(fieldsName);
                    this.fieldsStream.writeInt(1);
                    success = true;
                    Object var7_6 = null;
                    if (success) break block21;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!success) {
                        try {
                            this.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            d.deleteFile(fieldsName);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    this.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    d.deleteFile(fieldsName);
                }
                catch (Throwable t) {}
            }
            success = false;
            String indexName = segment + "." + "fdx";
            try {
                this.indexStream = d.createOutput(indexName);
                this.indexStream.writeInt(1);
                success = true;
                Object var10_12 = null;
                if (success) break block23;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (!success) {
                    try {
                        this.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        d.deleteFile(fieldsName);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        d.deleteFile(indexName);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                this.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                d.deleteFile(fieldsName);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                d.deleteFile(indexName);
            }
            catch (Throwable t) {}
        }
        this.doClose = true;
    }

    FieldsWriter(IndexOutput fdx, IndexOutput fdt, FieldInfos fn) {
        this.fieldInfos = fn;
        this.fieldsStream = fdt;
        this.indexStream = fdx;
        this.doClose = false;
    }

    void setFieldsStream(IndexOutput stream) {
        this.fieldsStream = stream;
    }

    void flushDocument(int numStoredFields, RAMOutputStream buffer) throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(numStoredFields);
        buffer.writeTo(this.fieldsStream);
    }

    void skipDocument() throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(0);
    }

    void flush() throws IOException {
        this.indexStream.flush();
        this.fieldsStream.flush();
    }

    /*
     * Exception decompiling
     */
    final void close() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final void writeField(FieldInfo fi, Fieldable field) throws IOException {
        boolean disableCompression = field instanceof FieldsReader.FieldForMerge;
        this.fieldsStream.writeVInt(fi.number);
        byte bits = 0;
        if (field.isTokenized()) {
            bits = (byte)(bits | 1);
        }
        if (field.isBinary()) {
            bits = (byte)(bits | 2);
        }
        if (field.isCompressed()) {
            bits = (byte)(bits | 4);
        }
        this.fieldsStream.writeByte(bits);
        if (field.isCompressed()) {
            int offset;
            int len;
            byte[] data;
            if (disableCompression) {
                data = field.getBinaryValue();
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError();
                }
                len = field.getBinaryLength();
                offset = field.getBinaryOffset();
            } else {
                if (field.isBinary()) {
                    data = CompressionTools.compress(field.getBinaryValue(), field.getBinaryOffset(), field.getBinaryLength());
                } else {
                    byte[] x = field.stringValue().getBytes("UTF-8");
                    data = CompressionTools.compress(x, 0, x.length);
                }
                len = data.length;
                offset = 0;
            }
            this.fieldsStream.writeVInt(len);
            this.fieldsStream.writeBytes(data, offset, len);
        } else if (field.isBinary()) {
            byte[] data = field.getBinaryValue();
            int len = field.getBinaryLength();
            int offset = field.getBinaryOffset();
            this.fieldsStream.writeVInt(len);
            this.fieldsStream.writeBytes(data, offset, len);
        } else {
            this.fieldsStream.writeString(field.stringValue());
        }
    }

    final void addRawDocuments(IndexInput stream, int[] lengths, int numDocs) throws IOException {
        long position;
        long start = position = this.fieldsStream.getFilePointer();
        for (int i = 0; i < numDocs; ++i) {
            this.indexStream.writeLong(position);
            position += (long)lengths[i];
        }
        this.fieldsStream.copyBytes(stream, position - start);
        if (!$assertionsDisabled && this.fieldsStream.getFilePointer() != position) {
            throw new AssertionError();
        }
    }

    final void addDocument(Document doc) throws IOException {
        Fieldable field;
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        int storedCount = 0;
        Iterator fieldIterator = doc.getFields().iterator();
        while (fieldIterator.hasNext()) {
            field = (Fieldable)fieldIterator.next();
            if (!field.isStored()) continue;
            ++storedCount;
        }
        this.fieldsStream.writeVInt(storedCount);
        fieldIterator = doc.getFields().iterator();
        while (fieldIterator.hasNext()) {
            field = (Fieldable)fieldIterator.next();
            if (!field.isStored()) continue;
            this.writeField(this.fieldInfos.fieldInfo(field.name()), field);
        }
    }

    static {
        $assertionsDisabled = !FieldsWriter.class.desiredAssertionStatus();
    }
}

