/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.DatabaseName;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.apphosting.datastore.shared.ValidationUtils;

public final class DatabaseNameV1Validator {
    public static final DatabaseNameV1Validator INSTANCE = new DatabaseNameV1Validator();

    private DatabaseNameV1Validator() {
    }

    public void validateDatabaseNameMatches(DatabaseName requestDatabaseName, ByteString projectIdBytes, ByteString databaseIdBytes) throws ValidationException {
        DatabaseName other = this.createAndValidateDatabaseName(projectIdBytes, databaseIdBytes);
        ValidationException.validateAssertion(other.isEmpty() || requestDatabaseName.equals(other), "%s%s vs. %s", "mismatched database names within request: ", requestDatabaseName, other);
    }

    public DatabaseName createAndValidateDatabaseName(ByteString projectIdBytes, ByteString databaseIdBytes) throws ValidationException {
        ValidationUtils.INSTANCE.validateStringUtf8(projectIdBytes, "project id");
        ValidationUtils.INSTANCE.validateStringUtf8(databaseIdBytes, "database id");
        String projectId = projectIdBytes.toStringUtf8();
        String databaseId = databaseIdBytes.toStringUtf8();
        if (!projectId.isEmpty()) {
            ValidationException.validateAssertion(DatastoreHelper.PROJECT_ID_REGEX.matcher(projectId).matches(), "\"%s\" is an invalid %s.", projectId, "project id");
        }
        if (!databaseId.isEmpty()) {
            ValidationException.validateAssertion(DatastoreHelper.DATABASE_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", databaseId, "database id");
        }
        return DatabaseName.of(projectIdBytes.toStringUtf8(), databaseIdBytes.toStringUtf8());
    }

    public DatabaseName createAndValidateRequiredDatabaseName(ByteString projectId, ByteString databaseId) throws ValidationException {
        ValidationException.validateAssertion(!projectId.isEmpty(), "missing project id in header", new Object[0]);
        return this.createAndValidateDatabaseName(projectId, databaseId);
    }
}

