/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.util.Constants;

public class FSDirectory
extends Directory {
    private static final Map DIRECTORIES = new HashMap();
    private static boolean disableLocks = false;
    public static final String LOCK_DIR = System.getProperty("org.apache.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private static Class IMPL;
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private boolean checked;
    protected File directory = null;
    private int refCount = 0;
    private static final char[] HEX_DIGITS;
    public static final int DEFAULT_READ_CHUNK_SIZE;
    private int chunkSize = DEFAULT_READ_CHUNK_SIZE;

    public static void setDisableLocks(boolean doDisableLocks) {
        disableLocks = doDisableLocks;
    }

    public static boolean getDisableLocks() {
        return disableLocks;
    }

    public static FSDirectory getDirectory(String path) throws IOException {
        return FSDirectory.getDirectory(new File(path), null);
    }

    public static FSDirectory getDirectory(String path, LockFactory lockFactory) throws IOException {
        return FSDirectory.getDirectory(new File(path), lockFactory);
    }

    public static FSDirectory getDirectory(File file) throws IOException {
        return FSDirectory.getDirectory(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, LockFactory lockFactory) throws IOException {
        FSDirectory dir;
        file = FSDirectory.getCanonicalPath(file);
        Object object = DIRECTORIES;
        synchronized (object) {
            dir = (FSDirectory)DIRECTORIES.get(file);
            if (dir == null) {
                try {
                    dir = (FSDirectory)IMPL.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
                }
                dir.init(file, lockFactory);
                DIRECTORIES.put(file, dir);
            } else {
                if (lockFactory != null && lockFactory != dir.getLockFactory()) {
                    throw new IOException("Directory was previously created with a different LockFactory instance; please pass null as the lockFactory instance and use setLockFactory to change it");
                }
                dir.checked = false;
            }
        }
        object = dir;
        synchronized (object) {
            ++dir.refCount;
        }
        return dir;
    }

    public static FSDirectory getDirectory(String path, boolean create) throws IOException {
        return FSDirectory.getDirectory(new File(path), create);
    }

    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(file, null);
        if (create) {
            dir.create();
        }
        return dir;
    }

    private void create() throws IOException {
        if (this.directory.exists()) {
            String[] files = this.directory.list(IndexFileNameFilter.getFilter());
            if (files == null) {
                throw new IOException("cannot read directory " + this.directory.getAbsolutePath() + ": list() returned null");
            }
            for (int i = 0; i < files.length; ++i) {
                File file = new File(this.directory, files[i]);
                if (file.delete()) continue;
                throw new IOException("Cannot delete " + file);
            }
        }
        this.lockFactory.clearLock("write.lock");
    }

    private static File getCanonicalPath(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    final void createDir() throws IOException {
        if (!this.checked) {
            if (!this.directory.exists() && !this.directory.mkdirs()) {
                throw new IOException("Cannot create directory: " + this.directory);
            }
            this.checked = true;
        }
    }

    protected final void initOutput(String name) throws IOException {
        this.ensureOpen();
        this.createDir();
        File file = new File(this.directory, name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
    }

    protected FSDirectory() {
    }

    protected FSDirectory(File path, LockFactory lockFactory) throws IOException {
        path = FSDirectory.getCanonicalPath(path);
        if (lockFactory == null) {
            lockFactory = new NativeFSLockFactory();
        }
        this.init(path, lockFactory);
        this.refCount = 1;
    }

    public static FSDirectory open(File path) throws IOException {
        return FSDirectory.open(path, null);
    }

    public static FSDirectory open(File path, LockFactory lockFactory) throws IOException {
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path, lockFactory);
        }
        return new NIOFSDirectory(path, lockFactory);
    }

    private void init(File path, LockFactory lockFactory) throws IOException {
        this.directory = path;
        if (this.directory.exists() && !this.directory.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + this.directory + "' exists but is not a directory");
        }
        if (lockFactory == null) {
            if (disableLocks) {
                lockFactory = NoLockFactory.getNoLockFactory();
            } else {
                String lockClassName = System.getProperty("org.apache.lucene.store.FSDirectoryLockFactoryClass");
                if (lockClassName != null && !lockClassName.equals("")) {
                    Class<?> c;
                    try {
                        c = Class.forName(lockClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("unable to find LockClass " + lockClassName);
                    }
                    try {
                        lockFactory = (LockFactory)c.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException("IllegalAccessException when instantiating LockClass " + lockClassName);
                    }
                    catch (InstantiationException e) {
                        throw new IOException("InstantiationException when instantiating LockClass " + lockClassName);
                    }
                    catch (ClassCastException e) {
                        throw new IOException("unable to cast LockClass " + lockClassName + " instance to a LockFactory");
                    }
                }
                lockFactory = new SimpleFSLockFactory();
            }
        }
        this.setLockFactory(lockFactory);
        if (lockFactory instanceof FSLockFactory) {
            FSLockFactory lf = (FSLockFactory)lockFactory;
            File dir = lf.getLockDir();
            if (dir == null) {
                lf.setLockDir(this.directory);
                lf.setLockPrefix(null);
            } else if (dir.getCanonicalPath().equals(this.directory.getCanonicalPath())) {
                lf.setLockPrefix(null);
            }
        }
    }

    public static String[] listAll(File dir) throws IOException {
        if (!dir.exists()) {
            throw new NoSuchDirectoryException("directory '" + dir + "' does not exist");
        }
        if (!dir.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + dir + "' exists but is not a directory");
        }
        String[] result = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String file) {
                return !new File(dir, file).isDirectory();
            }
        });
        if (result == null) {
            throw new IOException("directory '" + dir + "' exists and is a directory, but cannot be listed: list() returned null");
        }
        return result;
    }

    public String[] list() {
        this.ensureOpen();
        return this.directory.list(IndexFileNameFilter.getFilter());
    }

    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory);
    }

    public boolean fileExists(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.exists();
    }

    public long fileModified(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.lastModified();
    }

    public static long fileModified(File directory, String name) {
        File file = new File(directory, name);
        return file.lastModified();
    }

    public void touchFile(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        file.setLastModified(System.currentTimeMillis());
    }

    public long fileLength(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.length();
    }

    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void renameFile(String from, String to) throws IOException {
        int len;
        this.ensureOpen();
        File old = new File(this.directory, from);
        File nu = new File(this.directory, to);
        if (nu.exists() && !nu.delete()) {
            throw new IOException("Cannot delete " + nu);
        }
        if (old.renameTo(nu)) return;
        FileInputStream in = null;
        FileOutputStream out = null;
        in = new FileInputStream(old);
        out = new FileOutputStream(nu);
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        while ((len = ((InputStream)in).read(this.buffer)) >= 0) {
            ((OutputStream)out).write(this.buffer, 0, len);
        }
        old.delete();
        Object var10_9 = null;
        try {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot close input stream: " + e.toString(), e);
                }
            }
            Object var13_13 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
            }
        }
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
        }
        {
            catch (IOException ioe) {
                IOException newExc = new IOException("Cannot rename " + old + " to " + nu);
                newExc.initCause(ioe);
                throw newExc;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot close input stream: " + e.toString(), e);
                    }
                }
                Object var13_15 = null;
                if (out == null) throw throwable;
            }
            catch (Throwable throwable2) {
                Object var13_16 = null;
                if (out == null) throw throwable2;
                try {
                    ((OutputStream)out).close();
                    throw throwable2;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
                }
            }
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
            }
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        this.initOutput(name);
        return new FSIndexOutput(new File(this.directory, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(String name) throws IOException {
        this.ensureOpen();
        File fullFile = new File(this.directory, name);
        boolean success = false;
        int retryCount = 0;
        IOException exc = null;
        while (!success && retryCount < 5) {
            ++retryCount;
            RandomAccessFile file = null;
            try {
                Object var8_9;
                try {
                    file = new RandomAccessFile(fullFile, "rw");
                    file.getFD().sync();
                    success = true;
                    var8_9 = null;
                    if (file == null) continue;
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    if (file != null) {
                        file.close();
                    }
                    throw throwable;
                }
                file.close();
                {
                }
            }
            catch (IOException ioe) {
                if (exc == null) {
                    exc = ioe;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
            }
        }
        if (!success) {
            throw exc;
        }
    }

    public IndexInput openInput(String name) throws IOException {
        this.ensureOpen();
        return this.openInput(name, 1024);
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        this.ensureOpen();
        return new FSIndexInput(new File(this.directory, name), bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockID() {
        byte[] digest;
        String dirName;
        this.ensureOpen();
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.isOpen && --this.refCount <= 0) {
            this.isOpen = false;
            Map map = DIRECTORIES;
            synchronized (map) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public File getFile() {
        this.ensureOpen();
        return this.directory;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.directory + " lockFactory=" + this.getLockFactory();
    }

    public final void setReadChunkSize(int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be positive");
        }
        if (!Constants.JRE_IS_64BIT) {
            this.chunkSize = chunkSize;
        }
    }

    public final int getReadChunkSize() {
        return this.chunkSize;
    }

    static {
        try {
            String name = System.getProperty("org.apache.lucene.FSDirectory.class", SimpleFSDirectory.class.getName());
            IMPL = FSDirectory.class.getName().equals(name) ? SimpleFSDirectory.class : Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
        }
        catch (SecurityException se) {
            IMPL = SimpleFSDirectory.class;
        }
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.toString(), e);
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DEFAULT_READ_CHUNK_SIZE = Constants.JRE_IS_64BIT ? Integer.MAX_VALUE : 0x6400000;
    }

    protected static class FSIndexOutput
    extends SimpleFSDirectory.SimpleFSIndexOutput {
        public FSIndexOutput(File path) throws IOException {
            super(path);
        }
    }

    protected static class FSIndexInput
    extends SimpleFSDirectory.SimpleFSIndexInput {
        public FSIndexInput(File path) throws IOException {
            super(path);
        }

        public FSIndexInput(File path, int bufferSize) throws IOException {
            super(path, bufferSize);
        }

        protected static class Descriptor
        extends SimpleFSDirectory.SimpleFSIndexInput.Descriptor {
            public Descriptor(File file, String mode) throws IOException {
                super(file, mode);
            }
        }
    }
}

