/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.LoadingCache;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationResult;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.rpc.Code;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.CloudDatastoreV1ServiceValidator;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.DatastoreServiceProtoConverter;
import com.google.apphosting.datastore.shared.EntityV1Validator;
import com.google.apphosting.datastore.shared.EntityV3V1Converter;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.UserValueObfuscator;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@ServiceProvider(value=LocalRpcService.class)
public class LocalCloudDatastoreV1Service
extends AbstractLocalRpcService {
    public static final String PACKAGE = "cloud_datastore_v1beta3";
    public static final ProjectIdAppIdResolver RESOLVER = new ProjectIdAppIdResolver(){

        @Override
        public String toAppId(String projectId) throws InvalidConversionException {
            if (projectId.isEmpty()) {
                return ApiProxy.getCurrentEnvironment().getAppId();
            }
            return DatastoreHelper.projectIdToApp(this.getCluster(), projectId);
        }

        @Override
        public String toProjectId(String appId) {
            String cluster = this.getCluster();
            Preconditions.checkArgument((cluster.isEmpty() || appId.startsWith(cluster) ? 1 : 0) != 0);
            return DatastoreHelper.appToProjectId(appId);
        }

        private String getCluster() {
            return DatastoreHelper.getCluster(ApiProxy.getCurrentEnvironment().getAppId());
        }
    };
    private static final int MAX_REQUEST_SIZE = 0xA00000;
    private static final Collection<OnestoreEntity.CompositeIndex> EMPTY_INDEX_COLLECTION = Collections.emptySet();
    private static final boolean NO_IN_MEMORY_OPERATIONS = false;
    private static final Long NO_VERSION = 0L;
    private static final Long MINIMUM_VERSION = 1L;
    private static final int CONCURRENT_MODIFICATION_CANONICAL_CODE = DatastoreHelper.getCanonicalCodeForAppError(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue()).getNumber();
    private static final long BLIND_WRITE_MAX_RETRIES = 25L;
    private static final long BLIND_WRITE_MIN_WAIT_MS = 10L;
    private static final long BLIND_WRITE_MAX_WAIT_MS = 1000L;
    static final EntityV4Converter ENTITY_V4_CONVERTER = new EntityV4Converter(false, UserValueObfuscator.IDENTITY);
    private static final Config.DatastoreConfig LOCAL_CONFIG = Config.DatastoreConfig.newBuilder().setAllowIncompleteKeyPathsInQueryFilters(true).setEnableIndexedEntityValues(true).addAllReservedKindsToAllow(LocalDatastoreService.RESERVED_KIND_WHITELIST).setAllowMutationBaseVersion(true).setAllowSingleUseTransaction(true).setAllowNewTransactionReadOptions(true).build();
    static final DatastoreServiceProtoConverter LOCAL_SERVICE_CONVERTER = new DatastoreServiceProtoConverter(new DatastoreProtoConverter(ENTITY_V4_CONVERTER, LOCAL_CONFIG)){

        @Override
        public DatastorePb.Transaction toV3Transaction(ByteString transactionBytes, String unusedAppId) throws InvalidConversionException {
            try {
                return (DatastorePb.Transaction)DatastorePb.Transaction.parser().parseFrom(transactionBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toTransactionBytes(DatastorePb.Transaction transactionV3) {
            return transactionV3.toByteString();
        }

        @Override
        public DatastorePb.Cursor toV3Cursor(ByteString queryHandleV4) throws InvalidConversionException {
            try {
                return (DatastorePb.Cursor)DatastorePb.Cursor.parser().parseFrom(queryHandleV4);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toV4QueryHandle(DatastorePb.Cursor cursorV3) {
            return cursorV3.toByteString();
        }
    };
    private static final CloudDatastoreV1ServiceValidator LOCAL_VALIDATOR = new CloudDatastoreV1ServiceValidator(new CloudDatastoreV1Validator(new EntityV1Validator(LOCAL_CONFIG)));

    public String getPackage() {
        return PACKAGE;
    }

    public AllocateIdsResponse allocateIds(LocalRpcService.Status status, AllocateIdsRequest req) {
        DatastorePb.AllocateIdsResponse respV3;
        AllocateIdsResponse.Builder respBuilder = AllocateIdsResponse.newBuilder();
        try {
            LOCAL_VALIDATOR.validateAllocateIdsRequest((AllocateIdsRequestOrBuilder)req);
            DatastorePb.AllocateIdsRequest reqV3 = new DatastorePb.AllocateIdsRequest();
            reqV3.setSize((long)req.getKeysCount());
            respV3 = (DatastorePb.AllocateIdsResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.AllocateIds, (MessageLite)reqV3, DatastorePb.AllocateIdsResponse.parser());
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        if (respV3.getEnd() - respV3.getStart() + 1L < (long)req.getKeysCount()) {
            throw LocalCloudDatastoreV1Service.invalidArgument("could not allocate sufficent ids");
        }
        long i = respV3.getStart();
        for (Key reqKey : req.getKeysList()) {
            Key.Builder respKey;
            try {
                respKey = EntityV3V1Converter.INSTANCE.toV1Key(RESOLVER, EntityV3V1Converter.INSTANCE.toV3Reference(RESOLVER, (KeyOrBuilder)reqKey));
            }
            catch (InvalidConversionException e) {
                throw LocalCloudDatastoreV1Service.internalError(e);
            }
            respKey.getPathBuilder(respKey.getPathCount() - 1).setId(LocalDatastoreService.toScatteredId(i++));
            respBuilder.addKeys(respKey);
        }
        return respBuilder.build();
    }

    public BeginTransactionResponse beginTransaction(LocalRpcService.Status status, BeginTransactionRequest req) {
        try {
            LOCAL_VALIDATOR.validateBeginTransactionRequest((BeginTransactionRequestOrBuilder)req);
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        DatastorePb.BeginTransactionRequest reqV3 = new DatastorePb.BeginTransactionRequest().setApp(LocalCloudDatastoreV1Service.getAppId()).setAllowMultipleEg(true);
        DatastorePb.Transaction internalResp = (DatastorePb.Transaction)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)reqV3, DatastorePb.Transaction.parser());
        try {
            return LOCAL_SERVICE_CONVERTER.toV1BeginTransactionResponse(internalResp).build();
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.internalError(e);
        }
    }

    private ByteString beginAdHocTransaction(String projectId, String databaseId) {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setProjectId(projectId).setDatabaseId(databaseId).build();
        return this.beginTransaction(new LocalRpcService.Status(), request).getTransaction();
    }

    private void rollbackAdHocTransactionQuietly(ByteString txn, String projectId, String databaseId, Throwable cause) {
        RollbackRequest request = RollbackRequest.newBuilder().setProjectId(projectId).setDatabaseId(databaseId).setTransaction(txn).build();
        try {
            this.rollback(new LocalRpcService.Status(), request);
        }
        catch (ApiProxy.ApplicationException e) {
            cause.addSuppressed(e);
        }
    }

    private static LoadingCache<OnestoreEntity.Reference, Long> newExistenceCache(final DatastorePb.Transaction transactionV3) {
        Preconditions.checkNotNull((Object)transactionV3);
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<OnestoreEntity.Reference, Long>(){

            public Long load(OnestoreEntity.Reference key) throws Exception {
                DatastorePb.GetRequest get = new DatastorePb.GetRequest().setTransaction(transactionV3);
                get.addKey(key);
                DatastorePb.GetResponse res = (DatastorePb.GetResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)get, DatastorePb.GetResponse.parser());
                DatastorePb.GetResponse.Entity responseEntity = res.getEntity(0);
                return responseEntity.hasEntity() ? responseEntity.getVersion() : NO_VERSION.longValue();
            }
        });
    }

    public CommitResponse commit(LocalRpcService.Status status, CommitRequest req) {
        CommitResponse.Builder builder;
        block7: {
            builder = CommitResponse.newBuilder();
            try {
                LOCAL_VALIDATOR.validateCommitRequest(false, (CommitRequestOrBuilder)req);
                if (req.getMode() == CommitRequest.Mode.NON_TRANSACTIONAL) {
                    this.commitNonTransactional(req, builder, 25L, 10L, 1000L);
                    break block7;
                }
                ByteString singleUseTxn = null;
                ByteString txn = req.getTransaction();
                if (req.getTransactionSelectorCase() == CommitRequest.TransactionSelectorCase.SINGLE_USE_TRANSACTION) {
                    txn = singleUseTxn = this.beginAdHocTransaction(req.getProjectId(), req.getDatabaseId());
                }
                try {
                    this.applyMutationList(req.getMutationsList(), txn, builder);
                }
                catch (RuntimeException e) {
                    if (singleUseTxn != null) {
                        this.rollbackAdHocTransactionQuietly(singleUseTxn, req.getProjectId(), req.getDatabaseId(), e);
                    }
                    throw e;
                }
            }
            catch (InvalidConversionException | ValidationException e) {
                throw LocalCloudDatastoreV1Service.invalidArgument(e);
            }
        }
        return builder.build();
    }

    private void commitNonTransactional(CommitRequest originalRequest, CommitResponse.Builder response, long maxRetries, long minWaitMs, long maxWaitMs) {
        block4: for (Mutation mutation : originalRequest.getMutationsList()) {
            long waitMs = minWaitMs;
            long retries = maxRetries;
            while (true) {
                ByteString txn = null;
                try {
                    txn = this.beginAdHocTransaction(originalRequest.getProjectId(), originalRequest.getDatabaseId());
                    CommitRequest commitRequest = CommitRequest.newBuilder((CommitRequest)originalRequest).setMode(CommitRequest.Mode.TRANSACTIONAL).clearMutations().addMutations(mutation).setTransaction(txn).build();
                    CommitResponse commitResponse = this.commit(new LocalRpcService.Status(), commitRequest);
                    response.setIndexUpdates(response.getIndexUpdates() + commitResponse.getIndexUpdates());
                    response.addMutationResults(commitResponse.getMutationResults(0));
                    continue block4;
                }
                catch (ApiProxy.ApplicationException e) {
                    if (txn != null) {
                        this.rollbackAdHocTransactionQuietly(txn, originalRequest.getProjectId(), originalRequest.getDatabaseId(), e);
                    }
                    if (e.getApplicationError() == CONCURRENT_MODIFICATION_CANONICAL_CODE && retries-- > 0L) {
                        try {
                            Thread.sleep((long)(Math.random() * (double)waitMs));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        waitMs = Math.min(maxWaitMs, waitMs * 2L);
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
    }

    public RollbackResponse rollback(LocalRpcService.Status status, RollbackRequest req) {
        try {
            LOCAL_VALIDATOR.validateRollbackRequest((RollbackRequestOrBuilder)req);
            LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Rollback, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3Transaction((RollbackRequestOrBuilder)req, LocalCloudDatastoreV1Service.getAppId()), ApiBasePb.VoidProto.parser());
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        return RollbackResponse.getDefaultInstance();
    }

    public LookupResponse get(LocalRpcService.Status status, LookupRequest request) {
        return this.lookup(status, request);
    }

    public LookupResponse lookup(LocalRpcService.Status status, LookupRequest request) {
        ByteString newTxn = null;
        try {
            DatastorePb.GetResponse internResp;
            try {
                LOCAL_VALIDATOR.validateLookupRequest((LookupRequestOrBuilder)request);
                if (request.getReadOptions().getConsistencyTypeCase() == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION) {
                    newTxn = this.beginAdHocTransaction(request.getProjectId(), request.getDatabaseId());
                }
                internResp = (DatastorePb.GetResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3GetRequest(RESOLVER, (LookupRequestOrBuilder)request, newTxn, LocalCloudDatastoreV1Service.getAppId()), DatastorePb.GetResponse.parser());
            }
            catch (InvalidConversionException | ValidationException e) {
                throw LocalCloudDatastoreV1Service.invalidArgument(e);
            }
            try {
                return LOCAL_SERVICE_CONVERTER.toV1LookupResponse(RESOLVER, internResp, newTxn).build();
            }
            catch (InvalidConversionException e) {
                throw LocalCloudDatastoreV1Service.internalError(e);
            }
        }
        catch (RuntimeException e) {
            if (newTxn != null) {
                this.rollbackAdHocTransactionQuietly(newTxn, request.getProjectId(), request.getDatabaseId(), e);
            }
            throw e;
        }
    }

    private RunQueryRequest normalizeRunQueryRequest(RunQueryRequest request) throws ValidationException, InvalidConversionException {
        if (request.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.GQL_QUERY) {
            LOCAL_VALIDATOR.getDatastoreV1Validator().validateGqlQuery((GqlQueryOrBuilder)request.getGqlQuery());
            request = RunQueryRequest.newBuilder((RunQueryRequest)request).setQuery(LOCAL_SERVICE_CONVERTER.getDatastoreProtoConverter().toV1Query((GqlQueryOrBuilder)request.getGqlQuery(), request.getPartitionId())).clearGqlQuery().build();
        }
        return request;
    }

    public RunQueryResponse runQuery(LocalRpcService.Status status, RunQueryRequest request) {
        ByteString newTxn = null;
        try {
            DatastorePb.QueryResult internResp;
            RunQueryRequest normalizedRequest;
            try {
                normalizedRequest = this.normalizeRunQueryRequest(request);
                LOCAL_VALIDATOR.validateRunQueryRequest(normalizedRequest);
                if (normalizedRequest.getReadOptions().getConsistencyTypeCase() == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION) {
                    newTxn = this.beginAdHocTransaction(request.getProjectId(), request.getDatabaseId());
                }
                internResp = (DatastorePb.QueryResult)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.RunQuery, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3Query(RESOLVER, (RunQueryRequestOrBuilder)normalizedRequest, newTxn, false, EMPTY_INDEX_COLLECTION), DatastorePb.QueryResult.parser());
            }
            catch (InvalidConversionException | ValidationException e) {
                throw LocalCloudDatastoreV1Service.invalidArgument(e);
            }
            try {
                return LOCAL_SERVICE_CONVERTER.toV1RunQueryResponse(RESOLVER, internResp, request.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.GQL_QUERY ? normalizedRequest.getQuery() : null, newTxn).build();
            }
            catch (InvalidConversionException e) {
                throw LocalCloudDatastoreV1Service.internalError(e);
            }
        }
        catch (RuntimeException e) {
            if (newTxn != null) {
                this.rollbackAdHocTransactionQuietly(newTxn, request.getProjectId(), request.getDatabaseId(), e);
            }
            throw e;
        }
    }

    private static long getPersistedVersion(LoadingCache<OnestoreEntity.Reference, Long> existenceCache, OnestoreEntity.Reference key) {
        try {
            return (Long)existenceCache.get((Object)key);
        }
        catch (ExecutionException e) {
            throw LocalCloudDatastoreV1Service.internalError(e);
        }
    }

    private static boolean exists(LoadingCache<OnestoreEntity.Reference, Long> existenceCache, OnestoreEntity.Reference key) {
        return LocalCloudDatastoreV1Service.getPersistedVersion(existenceCache, key) != NO_VERSION;
    }

    private static boolean conflicts(long persistedVersion, long baseVersion) {
        if (persistedVersion != NO_VERSION && baseVersion > persistedVersion) {
            throw LocalCloudDatastoreV1Service.invalidArgument("Invalid base version, it is greater than the stored version");
        }
        return persistedVersion != baseVersion;
    }

    private OnestoreEntity.Reference put(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn) {
        Preconditions.checkNotNull((Object)txn);
        DatastorePb.PutRequest put = new DatastorePb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return ((DatastorePb.PutResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)put, DatastorePb.PutResponse.parser())).getKey(0);
    }

    private void delete(OnestoreEntity.Reference key, DatastorePb.Transaction txn) {
        Preconditions.checkNotNull((Object)txn);
        DatastorePb.DeleteRequest delete = new DatastorePb.DeleteRequest();
        delete.setTransaction(txn);
        delete.addKey(key);
        LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Delete, (MessageLite)delete, DatastorePb.DeleteResponse.parser());
    }

    private void applyMutationList(List<Mutation> mutationList, ByteString v1Txn, CommitResponse.Builder response) throws InvalidConversionException, ValidationException {
        DatastorePb.Transaction txn = LOCAL_SERVICE_CONVERTER.toV3Transaction(v1Txn, LocalCloudDatastoreV1Service.getAppId());
        LinkedList<Key> mutationKeys = new LinkedList<Key>();
        HashSet<Key> seenKeys = new HashSet<Key>();
        HashSet<Key> allocatedKeys = new HashSet<Key>();
        HashMap<Key, Long> conflictingVersions = new HashMap<Key, Long>();
        LoadingCache<OnestoreEntity.Reference, Long> existenceCache = LocalCloudDatastoreV1Service.newExistenceCache(txn);
        for (Mutation mutation : mutationList) {
            Long baseVersion;
            Long conflictingVersion;
            Key key = LocalCloudDatastoreV1Service.normalizeKey(LocalCloudDatastoreV1Service.getMutationKey(mutation));
            if (Paths.hasIncompleteLastElement((KeyOrBuilder)key)) {
                key = this.applyIncompleteKeyMutation(mutation, txn);
                allocatedKeys.add(key);
            } else if (!conflictingVersions.containsKey(key) && (conflictingVersion = this.applyMutation(mutation, txn, existenceCache, baseVersion = mutation.getConflictDetectionStrategyCase() == Mutation.ConflictDetectionStrategyCase.BASE_VERSION && !seenKeys.contains(key) ? Long.valueOf(mutation.getBaseVersion()) : null)) != null) {
                conflictingVersions.put(key, conflictingVersion);
            }
            mutationKeys.add(key);
            seenKeys.add(key);
        }
        this.commitMutations(txn, mutationKeys, allocatedKeys, conflictingVersions, response);
    }

    private Key applyIncompleteKeyMutation(Mutation mutation, DatastorePb.Transaction txn) throws InvalidConversionException {
        Preconditions.checkArgument((mutation.getOperationCase() == Mutation.OperationCase.INSERT || mutation.getOperationCase() == Mutation.OperationCase.UPSERT ? 1 : 0) != 0, (Object)"Invalid operation on an incomplete key.");
        OnestoreEntity.EntityProto entityV3 = EntityV3V1Converter.INSTANCE.toV3Entity(RESOLVER, (EntityOrBuilder)(mutation.getOperationCase() == Mutation.OperationCase.INSERT ? mutation.getInsert() : mutation.getUpsert()));
        OnestoreEntity.Reference keyV3 = this.put(entityV3, txn);
        return EntityV3V1Converter.INSTANCE.toV1Key(RESOLVER, keyV3).build();
    }

    private Long applyMutation(Mutation mutation, DatastorePb.Transaction txn, LoadingCache<OnestoreEntity.Reference, Long> existenceCache, Long baseVersion) throws InvalidConversionException, ValidationException {
        long persistedVersion;
        OnestoreEntity.Reference keyV3 = EntityV3V1Converter.INSTANCE.toV3Reference(RESOLVER, (KeyOrBuilder)LocalCloudDatastoreV1Service.getMutationKey(mutation));
        if (mutation.getOperationCase() == Mutation.OperationCase.INSERT) {
            if (baseVersion != null && !baseVersion.equals(NO_VERSION)) {
                throw LocalCloudDatastoreV1Service.invalidArgument("Cannot insert an entity with a base version greater than zero");
            }
            if (LocalCloudDatastoreV1Service.exists(existenceCache, keyV3)) {
                throw LocalCloudDatastoreV1Service.invalidArgument("entity already exists");
            }
        } else if (mutation.getOperationCase() == Mutation.OperationCase.UPDATE) {
            if (baseVersion != null && baseVersion.equals(NO_VERSION)) {
                throw LocalCloudDatastoreV1Service.invalidArgument("Cannot update an entity with a base version set to zero");
            }
            if (!LocalCloudDatastoreV1Service.exists(existenceCache, keyV3)) {
                throw LocalCloudDatastoreV1Service.invalidArgument("no entity to update");
            }
        }
        if (baseVersion != null && LocalCloudDatastoreV1Service.conflicts(persistedVersion = LocalCloudDatastoreV1Service.getPersistedVersion(existenceCache, keyV3), baseVersion)) {
            return persistedVersion;
        }
        if (mutation.getOperationCase() == Mutation.OperationCase.DELETE) {
            this.delete(keyV3, txn);
            existenceCache.put((Object)keyV3, (Object)NO_VERSION);
        } else {
            OnestoreEntity.EntityProto entityV3 = EntityV3V1Converter.INSTANCE.toV3Entity(RESOLVER, (EntityOrBuilder)LocalCloudDatastoreV1Service.getMutationEntity(mutation));
            this.put(entityV3, txn);
            existenceCache.put((Object)keyV3, (Object)MINIMUM_VERSION);
        }
        return null;
    }

    private void commitMutations(DatastorePb.Transaction txn, Collection<Key> mutationKeys, Set<Key> allocatedKeys, Map<Key, Long> conflictingVersions, CommitResponse.Builder responseBuilder) throws InvalidConversionException {
        DatastorePb.CommitResponse commitResponse = (DatastorePb.CommitResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)txn, DatastorePb.CommitResponse.parser());
        responseBuilder.setIndexUpdates(commitResponse.getCost().getIndexWrites());
        HashMap<Key, Long> nonConflictingVersions = new HashMap<Key, Long>();
        for (DatastorePb.CommitResponse.Version version : commitResponse.versions()) {
            Key key = EntityV3V1Converter.INSTANCE.toV1Key(RESOLVER, version.getRootEntityKey()).build();
            nonConflictingVersions.put(key, version.getVersion());
        }
        for (Key mutatedKey : mutationKeys) {
            MutationResult.Builder mutationResult = responseBuilder.addMutationResultsBuilder();
            if (allocatedKeys.contains(mutatedKey)) {
                mutationResult.setKey(mutatedKey);
            }
            if (conflictingVersions.containsKey(mutatedKey)) {
                mutationResult.setConflictDetected(true);
                mutationResult.setVersion(conflictingVersions.get(mutatedKey).longValue());
                continue;
            }
            mutationResult.setVersion(((Long)nonConflictingVersions.get(mutatedKey)).longValue());
        }
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Integer getMaxApiRequestSize() {
        return 0xA00000;
    }

    private static Key getMutationKey(Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return mutation.getInsert().getKey();
            }
            case UPSERT: {
                return mutation.getUpsert().getKey();
            }
            case UPDATE: {
                return mutation.getUpdate().getKey();
            }
            case DELETE: {
                return mutation.getDelete();
            }
        }
        String string = String.valueOf(mutation.getOperationCase());
        throw new ValidationException(new StringBuilder(28 + String.valueOf(string).length()).append("Unknown mutation operation: ").append(string).toString());
    }

    private static Entity getMutationEntity(Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return mutation.getInsert();
            }
            case UPSERT: {
                return mutation.getUpsert();
            }
            case UPDATE: {
                return mutation.getUpdate();
            }
            case DELETE: {
                return null;
            }
        }
        String string = String.valueOf(mutation.getOperationCase());
        throw new ValidationException(new StringBuilder(28 + String.valueOf(string).length()).append("Unknown mutation operation: ").append(string).toString());
    }

    private static Key normalizeKey(Key key) throws InvalidConversionException {
        OnestoreEntity.Reference keyV3 = EntityV3V1Converter.INSTANCE.toV3Reference(RESOLVER, (KeyOrBuilder)key);
        return EntityV3V1Converter.INSTANCE.toV1Key(RESOLVER, keyV3).build();
    }

    private static ApiProxy.ApplicationException invalidArgument(Throwable cause) {
        return LocalCloudDatastoreV1Service.invalidArgument(cause.getMessage());
    }

    private static ApiProxy.ApplicationException invalidArgument(String message) {
        return new CanonicalCodeException(Code.INVALID_ARGUMENT, message, DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue());
    }

    private static ApiProxy.ApplicationException internalError(Throwable cause) {
        return new CanonicalCodeException(Code.INTERNAL, cause.getMessage(), DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue());
    }

    private static <T> T makeV3Call(DatastorePb.DatastoreService_3.Method method, MessageLite req, Parser<T> respParser) {
        return LocalCloudDatastoreV1Service.makeV3Call(method, req, respParser, true);
    }

    static <T> T makeV3Call(DatastorePb.DatastoreService_3.Method method, MessageLite req, Parser<T> respParser, boolean translateToCanonicalErrorCode) {
        byte[] responseBytes;
        try {
            responseBytes = ApiProxy.makeSyncCall((String)"datastore_v3", (String)method.name(), (byte[])req.toByteArray());
        }
        catch (ApiProxy.ApplicationException e) {
            if (translateToCanonicalErrorCode) {
                throw new CanonicalCodeException(DatastoreHelper.getGoogleRpcCanonicalCodeForAppError(e.getApplicationError()), e.getErrorDetail(), e.getApplicationError());
            }
            throw e;
        }
        try {
            return (T)respParser.parseFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw LocalCloudDatastoreV1Service.internalError(e);
        }
    }

    static String getAppId() {
        return ApiProxy.getCurrentEnvironment().getAppId();
    }

    static DatastorePb.Transaction toV3Transaction(ByteString transactionBytes) throws InvalidConversionException {
        return LOCAL_SERVICE_CONVERTER.toV3Transaction(transactionBytes, null);
    }

    static class CanonicalCodeException
    extends ApiProxy.ApplicationException {
        private final int originalApplicationError;

        public CanonicalCodeException(Code canonicalCode, String errorDetail, int datastoreV3Error) {
            super(canonicalCode.getNumber(), errorDetail);
            this.originalApplicationError = datastoreV3Error;
        }

        public int getOriginalApplicationError() {
            return this.originalApplicationError;
        }
    }
}

