/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.prospectivesearch.dev;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.prospectivesearch.ErrorPb;
import com.google.appengine.api.prospectivesearch.ProspectiveSearchPb;
import com.google.appengine.api.prospectivesearch.dev.QueryEvaluator;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueFactory;
import com.google.appengine.api.taskqueue.TaskOptions;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class LocalSearchService
extends AbstractLocalRpcService {
    public static final String AUTOCOMMIT_PROPERTY = "prospectivesearch.autocommit";
    public static final String PACKAGE = "matcher";
    private static final String STORED_BLOB_PROP_NAME = "object";
    private static final Logger logger = Logger.getLogger(LocalSearchService.class.getName());
    private Key subMapsStorageKey = null;
    private ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>> subMapsByTopic = null;
    private Clock clock;
    private boolean dirty = false;

    static Key createSubMapsStorageKey() {
        return KeyFactory.createKey((String)"__ProspectiveSearchSubscriptions__", (String)"subMaps");
    }

    public LocalSearchService() {
        this(Clock.DEFAULT);
    }

    LocalSearchService(Clock clock) {
        this.clock = clock;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.subMapsStorageKey = LocalSearchService.createSubMapsStorageKey();
    }

    public String getPackage() {
        return PACKAGE;
    }

    ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>> getSubMaps() {
        if (this.subMapsByTopic == null) {
            this.subMapsByTopic = this.loadCreateSubMap();
        }
        return this.subMapsByTopic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>> loadCreateSubMap() {
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
            try {
                ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>> concurrentSkipListMap = LocalSearchService.entityToSubs(datastore.get(this.subMapsStorageKey));
                return concurrentSkipListMap;
            }
            catch (EntityNotFoundException e) {
                ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>> concurrentSkipListMap = new ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>>();
                NamespaceManager.set((String)namespace);
                return concurrentSkipListMap;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "GAE Local Prospective Search: cannot load persistent subscriptions: ", e);
                ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>> concurrentSkipListMap = new ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>>();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                NamespaceManager.set((String)namespace);
                return concurrentSkipListMap;
            }
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }

    static ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>> entityToSubs(Entity entity) throws IOException {
        Blob blob = (Blob)entity.getProperty(STORED_BLOB_PROP_NAME);
        byte[] buf = blob.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        GZIPInputStream gzipIn = new GZIPInputStream(bais);
        try (ObjectInputStream ois = new ObjectInputStream(gzipIn);){
            ConcurrentSkipListMap object;
            ConcurrentSkipListMap concurrentSkipListMap = object = (ConcurrentSkipListMap)ois.readObject();
            return concurrentSkipListMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Entity subsToEntity(Key storageKey, ConcurrentSkipListMap<String, SortedMap<String, InternalSubscriptionRecord>> subs) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
        try (ObjectOutputStream oos = new ObjectOutputStream(gzipOut);){
            oos.writeObject(subs);
        }
        byte[] buf = baos.toByteArray();
        Entity entity = new Entity(storageKey);
        entity.setProperty(STORED_BLOB_PROP_NAME, (Object)new Blob(buf));
        return entity;
    }

    void autosave() {
        String property = System.getProperty(AUTOCOMMIT_PROPERTY);
        if (property == null || Boolean.valueOf(property).booleanValue()) {
            this.save();
        } else {
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
            Transaction txn = datastore.beginTransaction();
            try {
                datastore.put(LocalSearchService.subsToEntity(this.subMapsStorageKey, this.subMapsByTopic));
            }
            finally {
                txn.commit();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "GAE Local Prospective Search: cannot persist subscriptions: ", e);
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }

    public ProspectiveSearchPb.SubscribeResponse subscribe(LocalRpcService.Status status, ProspectiveSearchPb.SubscribeRequest request) {
        try {
            new QueryEvaluator(request.getVanillaQuery());
        }
        catch (RecognitionException e) {
            String string = String.valueOf(request.getVanillaQuery());
            throw new ApiProxy.ApplicationException(ErrorPb.Error.ErrorCode.BAD_REQUEST.getValue(), string.length() != 0 ? "Invalid query syntax: ".concat(string) : new String("Invalid query syntax: "));
        }
        ProspectiveSearchPb.SubscriptionRecord sub = new ProspectiveSearchPb.SubscriptionRecord();
        sub.setId(request.getSubId());
        sub.setVanillaQuery(request.getVanillaQuery());
        if (request.getLeaseDurationSec() == 0.0) {
            sub.setExpirationTimeSec(0.0);
        } else {
            long curTimeSec = this.clock.getCurrentTime() / 1000L;
            sub.setExpirationTimeSec((double)curTimeSec + request.getLeaseDurationSec());
        }
        InternalSubscriptionRecord newSubRecord = new InternalSubscriptionRecord(sub, request.schemaEntrys());
        this.findCreateTopicSubMap(request.getTopic()).put(request.getSubId(), newSubRecord);
        this.autosave();
        return new ProspectiveSearchPb.SubscribeResponse();
    }

    public ProspectiveSearchPb.UnsubscribeResponse unsubscribe(LocalRpcService.Status status, ProspectiveSearchPb.UnsubscribeRequest request) {
        String topic = request.getTopic();
        SortedMap<String, InternalSubscriptionRecord> subsById = this.getTopicSubMapOrFail(topic);
        InternalSubscriptionRecord sub = (InternalSubscriptionRecord)subsById.remove(request.getSubId());
        if (sub == null) {
            String msg = String.format("The given topic '%s' has no subscription with the subId: '%s'", topic, request.getSubId());
            throw new IllegalArgumentException(msg);
        }
        if (subsById.isEmpty()) {
            this.getSubMaps().remove(topic);
        }
        this.autosave();
        return new ProspectiveSearchPb.UnsubscribeResponse();
    }

    public ProspectiveSearchPb.MatchResponse match(LocalRpcService.Status status, ProspectiveSearchPb.MatchRequest request) {
        this.expireStaleSubscriptions();
        String topic = request.getTopic();
        SortedMap<String, InternalSubscriptionRecord> subsById = this.getTopicSubMapOrFail(topic);
        Entity doc = EntityTranslator.createFromPb((OnestoreEntity.EntityProto)request.getDocument());
        ArrayList<String> matchingSubs = new ArrayList<String>();
        for (InternalSubscriptionRecord sub : subsById.values()) {
            String query = sub.sub.getVanillaQuery();
            try {
                if (!new QueryEvaluator(query).eval(doc, sub.schemaEntryMap)) continue;
                matchingSubs.add(sub.sub.getId());
            }
            catch (RecognitionException e) {
                String string = String.valueOf(sub.sub.getId());
                logger.severe(string.length() != 0 ? "Invalid subscription found with ID: ".concat(string) : new String("Invalid subscription found with ID: "));
            }
        }
        if (!matchingSubs.isEmpty()) {
            Queue queue = QueueFactory.getQueue((String)request.getResultTaskQueue());
            String relativeUrl = request.getResultRelativeUrl();
            int numMatches = matchingSubs.size();
            int batchSize = request.getResultBatchSize();
            for (int i = 0; i < numMatches; i += batchSize) {
                TaskOptions opts = TaskOptions.Builder.withMethod((TaskOptions.Method)TaskOptions.Method.POST).url(relativeUrl).header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8").param("action", "matched").param("topic", topic).param("key", request.getResultKey()).param("results_offset", Integer.toString(i)).param("results_count", Integer.toString(numMatches));
                int n = Math.min(numMatches, i + batchSize);
                for (int j = i; j < n; ++j) {
                    opts.param("id", (String)matchingSubs.get(j));
                }
                if (request.hasResultPythonDocumentClass()) {
                    opts.param("document", BaseEncoding.base64Url().encode(request.getDocument().toByteArray()));
                }
                queue.add(opts);
            }
        }
        return new ProspectiveSearchPb.MatchResponse();
    }

    public ProspectiveSearchPb.ListSubscriptionsResponse listSubscriptions(LocalRpcService.Status status, ProspectiveSearchPb.ListSubscriptionsRequest request) {
        this.expireStaleSubscriptions();
        SortedMap<String, InternalSubscriptionRecord> subsById = this.getTopicSubMapOrFail(request.getTopic());
        String reqSubIdStart = request.getSubscriptionIdStart();
        int reqMaxResults = (int)request.getMaxResults();
        Preconditions.checkArgument((reqMaxResults > 0 ? 1 : 0) != 0, (String)"List subscriptions maxResults should be a positive number: %s", (Object[])new Object[]{reqMaxResults});
        long reqExpiresBefore = Long.MAX_VALUE;
        if (request.hasExpiresBefore()) {
            reqExpiresBefore = request.getExpiresBefore();
        }
        ProspectiveSearchPb.ListSubscriptionsResponse response = new ProspectiveSearchPb.ListSubscriptionsResponse();
        int count = 0;
        for (InternalSubscriptionRecord sub : subsById.values()) {
            if (sub.sub.getId().compareTo(reqSubIdStart) < 0 || !(sub.sub.getExpirationTimeSec() < (double)reqExpiresBefore)) continue;
            response.addSubscription(sub.sub);
            if (++count != reqMaxResults) continue;
            break;
        }
        return response;
    }

    public ProspectiveSearchPb.ListTopicsResponse listTopics(LocalRpcService.Status status, ProspectiveSearchPb.ListTopicsRequest req) {
        this.expireStaleSubscriptions();
        List topics = new ArrayList();
        String topicStart = req.getTopicStart();
        if (topicStart == null) {
            topicStart = "";
        }
        topics.addAll(this.getSubMaps().tailMap((Object)"").keySet());
        if (req.getMaxResults() < (long)topics.size()) {
            topics = topics.subList(0, (int)req.getMaxResults());
        }
        ProspectiveSearchPb.ListTopicsResponse response = new ProspectiveSearchPb.ListTopicsResponse();
        for (String topic : topics) {
            response.addTopic(topic);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireStaleSubscriptions() {
        boolean modified = false;
        try {
            Iterator<Map.Entry<String, SortedMap<String, InternalSubscriptionRecord>>> topicSubsEntryItr = this.getSubMaps().entrySet().iterator();
            while (topicSubsEntryItr.hasNext()) {
                SortedMap<String, InternalSubscriptionRecord> subsById = topicSubsEntryItr.next().getValue();
                Iterator<Map.Entry<String, InternalSubscriptionRecord>> subEntryItr = subsById.entrySet().iterator();
                while (subEntryItr.hasNext()) {
                    InternalSubscriptionRecord sub = subEntryItr.next().getValue();
                    long curTime = this.clock.getCurrentTime() / 1000L;
                    double expirTime = sub.sub.getExpirationTimeSec();
                    if (!(expirTime > 0.0) || !(expirTime < (double)curTime)) continue;
                    subEntryItr.remove();
                    if (subsById.isEmpty()) {
                        topicSubsEntryItr.remove();
                    }
                    modified = true;
                }
            }
        }
        finally {
            if (modified || this.dirty) {
                this.autosave();
                this.dirty = false;
            }
        }
    }

    SortedMap<String, InternalSubscriptionRecord> findCreateTopicSubMap(String topic) {
        SortedMap<String, InternalSubscriptionRecord> subsById = this.getSubMaps().get(topic);
        if (subsById == null) {
            subsById = new ConcurrentSkipListMap<String, InternalSubscriptionRecord>();
            this.getSubMaps().put(topic, subsById);
        }
        return subsById;
    }

    SortedMap<String, InternalSubscriptionRecord> getTopicSubMapOrFail(String topic) throws IllegalArgumentException {
        SortedMap<String, InternalSubscriptionRecord> subsById = this.getSubMaps().get(topic);
        if (subsById == null) {
            String string = String.valueOf(topic);
            throw new IllegalArgumentException(string.length() != 0 ? "No such topic: ".concat(string) : new String("No such topic: "));
        }
        return subsById;
    }

    static class InternalSubscriptionRecord
    implements Serializable {
        static final long serialVersionUID = 5562784087180920209L;
        final ProspectiveSearchPb.SubscriptionRecord sub;
        final Map<String, ProspectiveSearchPb.SchemaEntry> schemaEntryMap;

        InternalSubscriptionRecord(ProspectiveSearchPb.SubscriptionRecord sub, List<ProspectiveSearchPb.SchemaEntry> schema) {
            this.sub = sub;
            this.schemaEntryMap = new HashMap<String, ProspectiveSearchPb.SchemaEntry>();
            for (ProspectiveSearchPb.SchemaEntry se : schema) {
                this.schemaEntryMap.put(se.getName(), se);
            }
        }

        public String toString() {
            return String.format("subscription:{id: %s, query: %s, expir: %s}, schema: %s", this.sub.getId(), this.sub.getVanillaQuery(), this.sub.getExpirationTimeSec(), this.schemaEntryMap);
        }
    }
}

