/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.InternalDatabase;
import com.google.apphosting.datastore.shared.UnvalidatedDatabaseName;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.apphosting.datastore.shared.ValidationUtils;
import javax.annotation.Nullable;

public final class InternalDatabaseValidator {
    public static final InternalDatabaseValidator INSTANCE = new InternalDatabaseValidator();

    private InternalDatabaseValidator() {
    }

    public void validateInternalDatabaseMatches(InternalDatabase requestDatabase, byte[] appIdBytes, byte[] databaseIdBytes) throws ValidationException {
        InternalDatabase other = this.createAndValidateInternalDatabase(appIdBytes, databaseIdBytes);
        ValidationException.validateAssertion(requestDatabase.equals(other), "%s%s vs. %s", "mismatched database names within request: ", requestDatabase, other);
    }

    public void validateInternalDatabaseMatch(InternalDatabase testDatabase, InternalDatabase expectedDatabase) throws ValidationException {
        ValidationException.validateAssertion(testDatabase.equals(expectedDatabase), "%s%s vs. %s", "mismatched database names within request: ", testDatabase, expectedDatabase);
    }

    public InternalDatabase createAndValidateInternalDatabase(@Nullable byte[] appIdBytesArray, @Nullable byte[] databaseIdBytesArray) throws ValidationException {
        if (appIdBytesArray == null) {
            appIdBytesArray = new byte[]{};
        }
        if (databaseIdBytesArray == null) {
            databaseIdBytesArray = new byte[]{};
        }
        ByteString appIdBytes = ByteString.copyFrom((byte[])appIdBytesArray);
        ByteString databaseIdBytes = ByteString.copyFrom((byte[])databaseIdBytesArray);
        ValidationUtils.INSTANCE.validateStringUtf8(appIdBytes, "app id");
        ValidationUtils.INSTANCE.validateStringUtf8(databaseIdBytes, "database id");
        String appId = appIdBytes.toStringUtf8();
        String databaseId = databaseIdBytes.toStringUtf8();
        ValidationException.validateAssertion(!appId.isEmpty(), "The app id is the empty string.", new Object[0]);
        ValidationException.validateAssertion(DatastoreHelper.APP_ID_REGEX.matcher(appId).matches(), "\"%s\" is an invalid %s.", appId, "app id");
        if (!databaseId.isEmpty()) {
            ValidationException.validateAssertion(DatastoreHelper.DATABASE_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", databaseId, "database id");
        }
        return InternalDatabase.of(appIdBytes.toStringUtf8(), databaseIdBytes.toStringUtf8());
    }

    public InternalDatabase createAndValidateInternalDatabase(UnvalidatedDatabaseName extract) throws ValidationException {
        return this.createAndValidateInternalDatabase(extract.appId().toByteArray(), extract.databaseId().toByteArray());
    }
}

