/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.InternalDatabase;
import com.google.apphosting.datastore.shared.V3DatabaseNameExtractor;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Arrays;
import java.util.Iterator;

public class Paths {
    protected Paths() {
    }

    public static String getKind(OnestoreEntity.Reference key) {
        return Paths.lastElement(key).getType();
    }

    public static String getKind(Key key) {
        return Paths.lastElement((KeyOrBuilder)key).getKind();
    }

    public static boolean hasIdOrName(OnestoreEntity.Reference key) {
        return Paths.hasIdOrName(Paths.lastElement(key));
    }

    public static boolean hasIdOrName(OnestoreEntity.Path.Element element) {
        return element.hasId() && element.getId() != 0L || element.hasName() && !element.getName().isEmpty();
    }

    public static boolean hasIncompleteLastElement(OnestoreEntity.Reference key) {
        if (key.getPath().elementSize() == 0) {
            return false;
        }
        return !Paths.hasIdOrName(key);
    }

    public static long getId(OnestoreEntity.Reference key) {
        return Paths.lastElement(key).getId();
    }

    public static String getName(OnestoreEntity.Reference key) {
        return Paths.lastElement(key).getName();
    }

    public static OnestoreEntity.Path.Element lastElement(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        Preconditions.checkArgument((path.elementSize() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return path.getElement(path.elementSize() - 1);
    }

    public static EntityV4.Key.PathElementOrBuilder lastElement(EntityV4.KeyOrBuilder key) {
        Preconditions.checkArgument((key.getPathElementCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPathElementOrBuilder(key.getPathElementCount() - 1);
    }

    public static EntityV4.Key.PathElement.Builder lastElement(EntityV4.Key.Builder key) {
        Preconditions.checkArgument((key.getPathElementCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPathElementBuilder(key.getPathElementCount() - 1);
    }

    public static boolean hasIncompleteLastElement(EntityV4.KeyOrBuilder key) {
        if (key.getPathElementCount() == 0) {
            return false;
        }
        EntityV4.Key.PathElementOrBuilder lastPathElement = Paths.lastElement(key);
        return !lastPathElement.hasId() && !lastPathElement.hasName();
    }

    public static Key.PathElement lastElement(KeyOrBuilder key) {
        Preconditions.checkArgument((key.getPathCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPath(key.getPathCount() - 1);
    }

    public static boolean hasIncompleteLastElement(KeyOrBuilder key) {
        if (key.getPathCount() == 0) {
            return false;
        }
        return Paths.lastElement(key).getIdTypeCase() == Key.PathElement.IdTypeCase.IDTYPE_NOT_SET;
    }

    public static OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        return Paths.getGroup(key.getPath());
    }

    public static OnestoreEntity.Path getGroup(OnestoreEntity.Path path) {
        Preconditions.checkArgument((path.elementSize() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    public static OnestoreEntity.Reference toEntityGroupReference(OnestoreEntity.Reference key) {
        OnestoreEntity.Reference egKey = (OnestoreEntity.Reference)key.clone();
        return egKey.setPath(Paths.getGroup(key));
    }

    public static OnestoreEntity.Reference createKeyFromPath(InternalDatabase internalDatabase, String namespace, Object ... elms) {
        Preconditions.checkNotNull((Object)internalDatabase);
        Preconditions.checkArgument((!internalDatabase.appId().isEmpty() ? 1 : 0) != 0, (Object)"Application name must be supplied");
        OnestoreEntity.Reference k = new OnestoreEntity.Reference();
        V3DatabaseNameExtractor.set(k, internalDatabase);
        if (namespace != null && !namespace.isEmpty()) {
            k.setNameSpace(namespace);
        }
        k.setPath(Paths.createPath(elms));
        return k;
    }

    public static OnestoreEntity.Path createPath(Object ... elms) {
        Preconditions.checkArgument((elms.length > 0 && elms.length % 2 == 0 ? 1 : 0) != 0, (String)"Bad path: wrong number of elements %s", (Object[])new Object[]{Arrays.toString(elms)});
        OnestoreEntity.Path p = new OnestoreEntity.Path();
        for (int i = 0; i < elms.length; i += 2) {
            Preconditions.checkArgument((boolean)(elms[i] instanceof String), (String)"Bad path: type should be String: %s", (Object[])new Object[]{elms[i]});
            String type = (String)elms[i];
            if (elms[i + 1] instanceof Long || elms[i + 1] instanceof Integer) {
                long id = ((Number)elms[i + 1]).longValue();
                Preconditions.checkArgument((id != 0L || i + 2 == elms.length ? 1 : 0) != 0, (Object)"Bad path: id can be 0 only for the last element");
                p.addElement().setType(type).setId(id);
                continue;
            }
            Preconditions.checkArgument((boolean)(elms[i + 1] instanceof String), (String)"Bad path: type should be String, int or long: %s", (Object[])new Object[]{elms[i + 1]});
            String name = (String)elms[i + 1];
            p.addElement().setType(type).setName(name);
        }
        return p;
    }

    public static EntityV4.Key createV4KeyFromPath(EntityV4.PartitionId partitionId, Object ... elms) {
        Preconditions.checkArgument((elms.length > 0 && elms.length % 2 == 0 ? 1 : 0) != 0, (String)"Bad path: wrong number of elements %s", (Object[])new Object[]{Arrays.toString(elms)});
        EntityV4.Key.Builder key = EntityV4.Key.newBuilder();
        key.setPartitionId(partitionId);
        for (int i = 0; i < elms.length; i += 2) {
            Preconditions.checkArgument((boolean)(elms[i] instanceof String), (String)"Bad path: kind should be String: %s", (Object[])new Object[]{elms[i]});
            EntityV4.Key.PathElement.Builder element = EntityV4.Key.PathElement.newBuilder();
            element.setKind((String)elms[i]);
            if (elms[i + 1] instanceof Long || elms[i + 1] instanceof Integer) {
                long id = ((Number)elms[i + 1]).longValue();
                Preconditions.checkArgument((id != 0L || i + 2 == elms.length ? 1 : 0) != 0, (Object)"Bad path: id can be 0 only for the last element");
                if (id != 0L) {
                    element.setId(id);
                }
            } else {
                Preconditions.checkArgument((boolean)(elms[i + 1] instanceof String), (String)"Bad path: id or name should be String, int or long: %s", (Object[])new Object[]{elms[i + 1]});
                element.setName((String)elms[i + 1]);
            }
            key.addPathElement(element);
        }
        return key.build();
    }

    public static OnestoreEntity.PropertyValue toReferenceProperty(OnestoreEntity.Reference key) {
        OnestoreEntity.PropertyValue prop = new OnestoreEntity.PropertyValue();
        OnestoreEntity.PropertyValue.ReferenceValue ref = prop.getMutableReferenceValue();
        if (key.hasApp()) {
            ref.setApp(key.getApp());
        }
        if (key.hasNameSpace()) {
            ref.setNameSpace(key.getNameSpace());
        }
        for (OnestoreEntity.Path.Element keyElem : key.getPath().elements()) {
            OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem = ref.addPathElement();
            if (keyElem.hasType()) {
                refElem.setType(keyElem.getType());
            }
            if (keyElem.hasId()) {
                refElem.setId(keyElem.getId());
            }
            if (!keyElem.hasName()) continue;
            refElem.setName(keyElem.getName());
        }
        return prop;
    }

    public static boolean descendsFrom(OnestoreEntity.Reference key, OnestoreEntity.Reference ancestor) {
        if (!ancestor.getApp().equals(key.getApp())) {
            return false;
        }
        Iterator ai = ancestor.getPath().elementIterator();
        Iterator ki = key.getPath().elementIterator();
        while (ai.hasNext()) {
            if (ki.hasNext() && ((OnestoreEntity.Path.Element)ai.next()).equals((OnestoreEntity.Path.Element)ki.next())) continue;
            return false;
        }
        return true;
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue value) {
        Preconditions.checkArgument((boolean)value.hasReferenceValue());
        return Paths.toReference(value.getReferenceValue());
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue.ReferenceValue ref) {
        OnestoreEntity.Reference key = new OnestoreEntity.Reference();
        if (ref.hasApp()) {
            key.setApp(ref.getApp());
        }
        if (ref.hasNameSpace()) {
            key.setNameSpace(ref.getNameSpace());
        }
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem : ref.pathElements()) {
            OnestoreEntity.Path.Element keyElem = key.getMutablePath().addElement();
            if (refElem.hasType()) {
                keyElem.setType(refElem.getType());
            }
            if (refElem.hasId()) {
                keyElem.setId(refElem.getId());
            }
            if (!refElem.hasName()) continue;
            keyElem.setName(refElem.getName());
        }
        return key;
    }

    public static String toPathString(KeyOrBuilder key) {
        if (key.getPathCount() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Key.PathElement element : key.getPathList()) {
            String kind = element.getKind();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            switch (element.getIdTypeCase()) {
                case ID: {
                    stringBuilder.append(element.getId());
                    break;
                }
                case NAME: {
                    stringBuilder.append(element.getName());
                    break;
                }
                case IDTYPE_NOT_SET: {
                    break;
                }
                default: {
                    String string = String.valueOf(element.getIdTypeCase());
                    throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(string).length()).append("Unrecognized id_type: ").append(string).toString());
                }
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toPathString(EntityV4.KeyOrBuilder key) {
        if (key.getPathElementCount() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (EntityV4.Key.PathElementOrBuilder element : key.getPathElementList()) {
            String kind = element.getKind();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            if (element.hasId()) {
                stringBuilder.append(element.getId());
            } else if (element.hasName()) {
                stringBuilder.append(element.getName());
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toPathString(OnestoreEntity.Reference key) {
        if (key.getPath().elementSize() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (OnestoreEntity.Path.Element element : key.getPath().elements()) {
            String kind = element.getType();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            if (element.hasId()) {
                stringBuilder.append(element.getId());
            } else if (element.hasName()) {
                stringBuilder.append(element.getName());
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

