/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.AutoValue_UnvalidatedDatabaseName;
import com.google.apphosting.datastore.shared.InternalDatabase;
import javax.annotation.Nullable;

public abstract class UnvalidatedDatabaseName {
    public static final UnvalidatedDatabaseName EMPTY = UnvalidatedDatabaseName.builder().appId(ByteString.EMPTY).databaseId(ByteString.EMPTY).build();

    @Nullable
    public abstract ByteString appId();

    @Nullable
    public abstract ByteString projectId();

    public abstract ByteString databaseId();

    public static Builder builder() {
        return new AutoValue_UnvalidatedDatabaseName.Builder();
    }

    public static UnvalidatedDatabaseName databaseNameFromAppId(String appId) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFromUtf8((String)appId)).databaseId(ByteString.EMPTY).build();
    }

    public static UnvalidatedDatabaseName databaseNameFromAppId(InternalDatabase internalDatabase) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFromUtf8((String)internalDatabase.appId())).databaseId(ByteString.copyFromUtf8((String)internalDatabase.databaseId())).build();
    }

    public static abstract class Builder {
        @Nullable
        public abstract Builder appId(ByteString var1);

        @Nullable
        public abstract Builder projectId(ByteString var1);

        public abstract Builder databaseId(ByteString var1);

        public abstract UnvalidatedDatabaseName autoBuild();

        public UnvalidatedDatabaseName build() {
            UnvalidatedDatabaseName built = this.autoBuild();
            Preconditions.checkArgument((built.projectId() != null || built.appId() != null ? 1 : 0) != 0, (Object)"Must specify a project id or app id");
            return built;
        }
    }
}

