/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.InternalDatabase;
import com.google.apphosting.datastore.shared.InternalDatabaseValidator;
import com.google.apphosting.datastore.shared.UnvalidatedDatabaseName;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;

public class V3DatabaseNameExtractor {
    private static final String UNVALIDATED_DATABASE_NAME_ERROR = "Database should have already been validated.";

    private V3DatabaseNameExtractor() {
    }

    private static UnvalidatedDatabaseName handleMissingKey() {
        return UnvalidatedDatabaseName.EMPTY;
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.GetRequest request) {
        if (request.keySize() == 0) {
            return V3DatabaseNameExtractor.handleMissingKey();
        }
        return V3DatabaseNameExtractor.extract(request.getKey(0));
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.AllocateIdsRequest request) {
        OnestoreEntity.Reference key;
        if (request.hasModelKey()) {
            key = request.getModelKey();
        } else if (request.reserveSize() > 0) {
            key = request.getReserve(0);
        } else {
            return V3DatabaseNameExtractor.handleMissingKey();
        }
        return V3DatabaseNameExtractor.extract(key);
    }

    public static UnvalidatedDatabaseName extract(OnestoreEntity.Reference key) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])key.getAppAsBytes())).databaseId(ByteString.copyFrom((byte[])key.getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(OnestoreEntity.PropertyValue.ReferenceValue referenceValue) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])referenceValue.getAppAsBytes())).databaseId(ByteString.copyFrom((byte[])referenceValue.getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.Transaction request) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])request.getAppAsBytes())).databaseId(ByteString.copyFrom((byte[])request.getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.BeginTransactionRequest request) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])request.getAppAsBytes())).databaseId(ByteString.copyFrom((byte[])request.getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.Cursor request) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])request.getAppAsBytes())).databaseId(ByteString.copyFrom((byte[])request.getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.NextRequest request) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])request.getCursor().getAppAsBytes())).databaseId(ByteString.copyFrom((byte[])request.getCursor().getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.Query request) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])request.getAppAsBytes())).databaseId(ByteString.copyFrom((byte[])request.getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.AddActionsRequest request) {
        DatastorePb.Transaction transaction = request.getTransaction();
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])transaction.getAppAsBytes())).databaseId(ByteString.copyFrom((byte[])transaction.getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.DeleteRequest request) {
        if (request.keySize() == 0) {
            return V3DatabaseNameExtractor.handleMissingKey();
        }
        return V3DatabaseNameExtractor.extract(request.getKey(0));
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.TouchRequest request) {
        if (request.keySize() == 0) {
            return UnvalidatedDatabaseName.EMPTY;
        }
        return V3DatabaseNameExtractor.extract(request.getKey(0));
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.PutRequest request) {
        if (request.entitySize() == 0) {
            return V3DatabaseNameExtractor.handleMissingKey();
        }
        return V3DatabaseNameExtractor.extract(request.getEntity(0).getKey());
    }

    public static UnvalidatedDatabaseName extract(OnestoreEntity.EntityProto entityProto) {
        return V3DatabaseNameExtractor.extract(entityProto.getKey());
    }

    public static UnvalidatedDatabaseName extract(OnestoreEntity.CompositeIndex req) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])req.getAppIdAsBytes())).databaseId(ByteString.copyFrom((byte[])req.getDatabaseIdAsBytes())).build();
    }

    public static UnvalidatedDatabaseName extract(DatastorePb.GetIndicesRequest request) {
        return UnvalidatedDatabaseName.builder().appId(ByteString.copyFrom((byte[])request.getAppIdAsBytes())).databaseId(ByteString.copyFrom((byte[])request.getDatabaseIdAsBytes())).build();
    }

    public static InternalDatabase extractValidated(UnvalidatedDatabaseName unvalidatedName) {
        try {
            return InternalDatabaseValidator.INSTANCE.createAndValidateInternalDatabase(unvalidatedName);
        }
        catch (ValidationException ex) {
            throw new IllegalStateException(UNVALIDATED_DATABASE_NAME_ERROR, ex);
        }
    }

    public static InternalDatabase extractValidated(OnestoreEntity.CompositeIndex index) {
        return V3DatabaseNameExtractor.extractValidated(V3DatabaseNameExtractor.extract(index));
    }

    public static InternalDatabase extractValidated(DatastorePb.Transaction transaction) {
        return V3DatabaseNameExtractor.extractValidated(V3DatabaseNameExtractor.extract(transaction));
    }

    public static InternalDatabase extractValidated(OnestoreEntity.Reference key) {
        return V3DatabaseNameExtractor.extractValidated(V3DatabaseNameExtractor.extract(key));
    }

    public static InternalDatabase extractValidated(DatastorePb.PutRequest req) {
        return V3DatabaseNameExtractor.extractValidated(V3DatabaseNameExtractor.extract(req));
    }

    public static InternalDatabase extractValidated(DatastorePb.GetRequest req) {
        return V3DatabaseNameExtractor.extractValidated(V3DatabaseNameExtractor.extract(req));
    }

    public static InternalDatabase extractValidated(DatastorePb.Query req) {
        return V3DatabaseNameExtractor.extractValidated(V3DatabaseNameExtractor.extract(req));
    }

    public static OnestoreEntity.CompositeIndex set(OnestoreEntity.CompositeIndex compositeIndex, InternalDatabase internalDatabase) {
        compositeIndex.setAppId(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            compositeIndex.setDatabaseId(internalDatabase.databaseId());
        }
        return compositeIndex;
    }

    public static DatastorePb.Query set(DatastorePb.Query query, InternalDatabase internalDatabase) {
        query.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            query.setDatabaseId(internalDatabase.databaseId());
        }
        return query;
    }

    public static OnestoreEntity.PropertyValue.ReferenceValue set(OnestoreEntity.PropertyValue.ReferenceValue key, InternalDatabase internalDatabase) {
        key.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            key.setDatabaseId(internalDatabase.databaseId());
        }
        return key;
    }

    public static OnestoreEntity.Reference set(OnestoreEntity.Reference key, InternalDatabase internalDatabase) {
        key.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            key.setDatabaseId(internalDatabase.databaseId());
        }
        return key;
    }

    public static DatastorePb.Transaction set(DatastorePb.Transaction transaction, InternalDatabase internalDatabase) {
        transaction.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            transaction.setDatabaseId(internalDatabase.databaseId());
        }
        return transaction;
    }

    public static DatastorePb.BeginTransactionRequest set(DatastorePb.BeginTransactionRequest beginTransactionRequest, InternalDatabase internalDatabase) {
        beginTransactionRequest.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            beginTransactionRequest.setDatabaseId(internalDatabase.databaseId());
        }
        return beginTransactionRequest;
    }

    public static DatastorePb.Cursor set(DatastorePb.Cursor cursor, InternalDatabase internalDatabase) {
        cursor.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            cursor.setDatabaseId(internalDatabase.databaseId());
        }
        return cursor;
    }

    public static DatastorePb.AllocateIdsRequest set(DatastorePb.AllocateIdsRequest request, InternalDatabase internalDatabase) {
        Preconditions.checkArgument((boolean)request.equals(DatastorePb.AllocateIdsRequest.getDefaultInstance()), (Object)"Because there are two places to set keys, and you sent an AllocateIdsRequest that already had something in it, you need to directly set the database where you want.");
        V3DatabaseNameExtractor.set(request.addReserve(), internalDatabase);
        return request;
    }

    public static DatastorePb.GetIndicesRequest set(DatastorePb.GetIndicesRequest getIndicesRequest, InternalDatabase internalDatabase) {
        getIndicesRequest.setAppId(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            getIndicesRequest.setDatabaseId(internalDatabase.databaseId());
        }
        return getIndicesRequest;
    }
}

