/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@GwtCompatible(emulated=true, serializable=true)
public strictfp final class S2CellId
implements Comparable<S2CellId>,
Serializable {
    public static final int FACE_BITS = 3;
    public static final int NUM_FACES = 6;
    public static final int MAX_LEVEL = 30;
    public static final int POS_BITS = 61;
    public static final int MAX_SIZE = 0x40000000;
    private static final double IJ_TO_ST = 9.313225746154785E-10;
    public static final long MAX_UNSIGNED = -1L;
    private static final int I_SHIFT = 33;
    private static final int J_SHIFT = 2;
    private static final long J_MASK = Integer.MAX_VALUE;
    private static final long ORIENTATION_MASK = 3L;
    private static final int SI_SHIFT = 32;
    private static final long TI_MASK = 0xFFFFFFFFL;
    private static final int LOOKUP_BITS = 4;
    private static final int SWAP_MASK = 1;
    private static final int INVERT_MASK = 2;
    private static final int LOOKUP_MASK = 15;
    private static final int[] LOOKUP_POS = new int[1024];
    private static final int[] LOOKUP_IJ = new int[1024];
    private static final S2CellId NONE = new S2CellId();
    private static final S2CellId SENTINEL = new S2CellId(-1L);
    private static final long WRAP_OFFSET = -4611686018427387904L;
    public static final S2CellId[] FACE_CELLS;
    private final long id;
    private static final CharMatcher MATCHES_ZERO;

    public S2CellId(long id) {
        this.id = id;
    }

    public S2CellId() {
        this.id = 0L;
    }

    public static S2CellId none() {
        return NONE;
    }

    public static S2CellId sentinel() {
        return SENTINEL;
    }

    public static S2CellId fromFace(int face) {
        return new S2CellId(S2CellId.fromFaceAsLong(face));
    }

    public static S2CellId fromFacePosLevel(int face, long pos, int level) {
        return new S2CellId(S2CellId.fromFacePosLevelAsLong(face, pos, level));
    }

    public static S2CellId fromPoint(S2Point p) {
        int face = S2Projections.xyzToFace(p);
        S2Projections.UvTransform t = S2Projections.faceToUvTransform(face);
        int i = S2Projections.stToIj(S2Projections.PROJ.uvToST(t.xyzToU(p.x, p.y, p.z)));
        int j = S2Projections.stToIj(S2Projections.PROJ.uvToST(t.xyzToV(p.x, p.y, p.z)));
        return S2CellId.fromFaceIJ(face, i, j);
    }

    public static S2CellId fromLatLng(S2LatLng ll) {
        return S2CellId.fromPoint(ll.toPoint());
    }

    public R2Vector getCenterUV() {
        long center = this.getCenterSiTi();
        return new R2Vector(S2Projections.PROJ.stToUV(S2Projections.siTiToSt(S2CellId.getSi(center))), S2Projections.PROJ.stToUV(S2Projections.siTiToSt(S2CellId.getTi(center))));
    }

    public R2Vector getCenterST() {
        long center = this.getCenterSiTi();
        return new R2Vector(S2Projections.siTiToSt(S2CellId.getSi(center)), S2Projections.siTiToSt(S2CellId.getTi(center)));
    }

    public R2Rect getBoundST() {
        double size = this.getSizeST();
        return R2Rect.fromCenterSize(this.getCenterST(), new R2Vector(size, size));
    }

    public R2Rect getBoundUV() {
        long ijo = this.toIJOrientation();
        return S2CellId.ijLevelToBoundUv(S2CellId.getI(ijo), S2CellId.getJ(ijo), this.level());
    }

    public S2Point toPoint() {
        return S2Point.normalize(this.toPointRaw());
    }

    public S2Point toPointRaw() {
        long center = this.getCenterSiTi();
        return S2Projections.PROJ.faceSiTiToXyz(this.face(), S2CellId.getSi(center), S2CellId.getTi(center));
    }

    long getCenterSiTi() {
        long ijo = this.toIJOrientation();
        int i = S2CellId.getI(ijo);
        int j = S2CellId.getJ(ijo);
        int delta = this.isLeaf() ? 1 : (((i ^ (int)this.id >>> 2) & 1) != 0 ? 2 : 0);
        return (long)(2 * i + delta) << 32 | (long)(2 * j + delta) & 0xFFFFFFFFL;
    }

    static int getSi(long center) {
        return (int)(center >> 32);
    }

    static int getTi(long center) {
        return (int)center;
    }

    public S2LatLng toLatLng() {
        return new S2LatLng(this.toPointRaw());
    }

    public long id() {
        return this.id;
    }

    public boolean isValid() {
        return this.face() < 6 && (this.lowestOnBit() & 0x1555555555555555L) != 0L;
    }

    public int face() {
        return (int)(this.id >>> 61);
    }

    public long pos() {
        return this.id & 0x1FFFFFFFFFFFFFFFL;
    }

    public int level() {
        if (this.isLeaf()) {
            return 30;
        }
        return 30 - (Long.numberOfTrailingZeros(this.id) >> 1);
    }

    public int getSizeIJ() {
        return S2CellId.getSizeIJ(this.level());
    }

    public double getSizeST() {
        return S2CellId.getSizeST(this.level());
    }

    public static int getSizeIJ(int level) {
        return 1 << 30 - level;
    }

    public static double getSizeST(int level) {
        return S2Projections.ijToStMin(S2CellId.getSizeIJ(level));
    }

    public boolean isLeaf() {
        return ((int)this.id & 1) != 0;
    }

    public boolean isFace() {
        return (this.id & S2CellId.lowestOnBitForLevel(0) - 1L) == 0L;
    }

    public int childPosition(int level) {
        return (int)(this.id >>> 2 * (30 - level) + 1) & 3;
    }

    public S2CellId rangeMin() {
        return new S2CellId(S2CellId.rangeMinAsLong(this.id));
    }

    public S2CellId rangeMax() {
        return new S2CellId(S2CellId.rangeMaxAsLong(this.id));
    }

    public boolean contains(S2CellId other) {
        return S2CellId.unsignedLongGreaterOrEquals(other.id, S2CellId.rangeMinAsLong(this.id)) && S2CellId.unsignedLongLessOrEquals(other.id, S2CellId.rangeMaxAsLong(this.id));
    }

    public boolean intersects(S2CellId other) {
        return S2CellId.unsignedLongLessOrEquals(S2CellId.rangeMinAsLong(other.id), S2CellId.rangeMaxAsLong(this.id)) && S2CellId.unsignedLongGreaterOrEquals(S2CellId.rangeMaxAsLong(other.id), S2CellId.rangeMinAsLong(this.id));
    }

    public S2CellId parent() {
        return new S2CellId(S2CellId.parentAsLong(this.id));
    }

    public S2CellId parent(int level) {
        return new S2CellId(S2CellId.parentAsLong(this.id, level));
    }

    public S2CellId child(int position) {
        long newLsb = this.lowestOnBit() >>> 2;
        return new S2CellId(this.id + (long)(2 * position + 1 - 4) * newLsb);
    }

    public Iterable<S2CellId> children() {
        if (this.isLeaf()) {
            return ImmutableList.of();
        }
        return this.childrenAtLevel(this.level() + 1);
    }

    public Iterable<S2CellId> childrenAtLevel(final int level) {
        Preconditions.checkState((boolean)this.isValid());
        Preconditions.checkArgument((level >= this.level() && level <= 30 ? 1 : 0) != 0);
        return new Iterable<S2CellId>(){

            @Override
            public Iterator<S2CellId> iterator() {
                return new UnmodifiableIterator<S2CellId>(){
                    private S2CellId next;
                    private long childEnd;
                    {
                        this.next = S2CellId.this.childBegin(level);
                        this.childEnd = S2CellId.this.childEnd(level).id();
                    }

                    public boolean hasNext() {
                        return this.next.id() != this.childEnd;
                    }

                    public S2CellId next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        S2CellId oldNext = this.next;
                        this.next = this.next.next();
                        return oldNext;
                    }
                };
            }
        };
    }

    public S2CellId childBegin() {
        return new S2CellId(S2CellId.childBeginAsLong(this.id));
    }

    public S2CellId childBegin(int level) {
        return new S2CellId(S2CellId.childBeginAsLong(this.id, level));
    }

    public S2CellId childEnd() {
        return new S2CellId(S2CellId.childEndAsLong(this.id));
    }

    public S2CellId childEnd(int level) {
        return new S2CellId(S2CellId.childEndAsLong(this.id, level));
    }

    public S2CellId next() {
        return new S2CellId(this.id + (this.lowestOnBit() << 1));
    }

    public S2CellId prev() {
        return new S2CellId(this.id - (this.lowestOnBit() << 1));
    }

    public S2CellId nextWrap() {
        S2CellId n = this.next();
        if (S2CellId.unsignedLongLessThan(n.id, -4611686018427387904L)) {
            return n;
        }
        return new S2CellId(n.id - -4611686018427387904L);
    }

    public S2CellId prevWrap() {
        S2CellId p = this.prev();
        if (p.id < -4611686018427387904L) {
            return p;
        }
        return new S2CellId(p.id + -4611686018427387904L);
    }

    public static S2CellId begin(int level) {
        return new S2CellId(S2CellId.childBeginAsLong(S2CellId.fromFaceAsLong(0), level));
    }

    public static S2CellId end(int level) {
        return new S2CellId(S2CellId.childEndAsLong(S2CellId.fromFaceAsLong(5), level));
    }

    public S2CellId advance(long steps) {
        if (steps == 0L) {
            return this;
        }
        int stepShift = 2 * (30 - this.level()) + 1;
        if (steps < 0L) {
            long minSteps = -(this.id >>> stepShift);
            if (steps < minSteps) {
                steps = minSteps;
            }
        } else {
            long maxSteps = -4611686018427387904L + this.lowestOnBit() - this.id >>> stepShift;
            if (steps > maxSteps) {
                steps = maxSteps;
            }
        }
        return new S2CellId(this.id + (steps << stepShift));
    }

    public S2CellId advanceWrap(long steps) {
        if (steps == 0L) {
            return this;
        }
        int stepShift = 2 * (30 - this.level()) + 1;
        if (steps < 0L) {
            long stepWrap;
            long minSteps = -(this.id >>> stepShift);
            if (steps < minSteps && (steps %= (stepWrap = -4611686018427387904L >>> stepShift)) < minSteps) {
                steps += stepWrap;
            }
        } else {
            long stepWrap;
            long maxSteps = -4611686018427387904L - this.id >>> stepShift;
            if (steps > maxSteps && (steps %= (stepWrap = -4611686018427387904L >>> stepShift)) > maxSteps) {
                steps -= stepWrap;
            }
        }
        return new S2CellId(this.id + (steps << stepShift));
    }

    public int getCommonAncestorLevel(S2CellId other) {
        long bits = UnsignedLongs.max((long[])new long[]{this.id ^ other.id, this.lowestOnBit(), other.lowestOnBit()});
        return Math.max(Long.numberOfLeadingZeros(bits) - 3, -1) >> 1;
    }

    public static S2CellId fromOldToken(String token) {
        return S2CellId.fromTokenImpl(token, false);
    }

    public String toOldToken() {
        return Ascii.toUpperCase((String)Long.toHexString(this.id));
    }

    public static S2CellId fromToken(String token) {
        return S2CellId.fromTokenImpl(token, true);
    }

    private static S2CellId fromTokenImpl(String token, boolean implicitZeroes) {
        if (token == null) {
            throw new NumberFormatException("Null string in S2CellId.fromToken");
        }
        if (token.isEmpty()) {
            throw new NumberFormatException("Empty string in S2CellId.fromToken");
        }
        int length = token.length();
        if (length > 16 || "X".equals(token)) {
            return S2CellId.none();
        }
        long value = 0L;
        for (int pos = 0; pos < length; ++pos) {
            int digitValue = Character.digit(token.charAt(pos), 16);
            if (digitValue == -1) {
                throw new NumberFormatException(token);
            }
            value = value * 16L + (long)digitValue;
        }
        if (implicitZeroes) {
            value <<= 4 * (16 - length);
        }
        return new S2CellId(value);
    }

    public String toToken() {
        if (this.id == 0L) {
            return "X";
        }
        String hex = Ascii.toLowerCase((String)Long.toHexString(this.id));
        String padded = Strings.padStart((String)hex, (int)16, (char)'0');
        return MATCHES_ZERO.trimTrailingFrom((CharSequence)padded);
    }

    public String toTokenOld() {
        String hex = Ascii.toLowerCase((String)Long.toHexString(this.id));
        StringBuilder sb = new StringBuilder(16);
        for (int i = hex.length(); i < 16; ++i) {
            sb.append('0');
        }
        sb.append(hex);
        for (int len = 16; len > 0; --len) {
            if (sb.charAt(len - 1) == '0') continue;
            return sb.substring(0, len);
        }
        throw new RuntimeException("Shouldn't make it here");
    }

    public void getEdgeNeighbors(S2CellId[] neighbors) {
        int j;
        int level = this.level();
        int size = S2CellId.getSizeIJ(level);
        int face = this.face();
        long ijo = this.toIJOrientation();
        int i = S2CellId.getI(ijo);
        neighbors[0] = S2CellId.fromFaceIJSame(face, i, j - size, (j = S2CellId.getJ(ijo)) - size >= 0).parent(level);
        neighbors[1] = S2CellId.fromFaceIJSame(face, i + size, j, i + size < 0x40000000).parent(level);
        neighbors[2] = S2CellId.fromFaceIJSame(face, i, j + size, j + size < 0x40000000).parent(level);
        neighbors[3] = S2CellId.fromFaceIJSame(face, i - size, j, i - size >= 0).parent(level);
    }

    public void getVertexNeighbors(int level, Collection<S2CellId> output) {
        boolean jsame;
        int joffset;
        boolean isame;
        int ioffset;
        long ijo = this.toIJOrientation();
        int i = S2CellId.getI(ijo);
        int j = S2CellId.getJ(ijo);
        int halfsize = S2CellId.getSizeIJ(level + 1);
        int size = halfsize << 1;
        if ((i & halfsize) != 0) {
            ioffset = size;
            isame = i + size < 0x40000000;
        } else {
            ioffset = -size;
            boolean bl = isame = i - size >= 0;
        }
        if ((j & halfsize) != 0) {
            joffset = size;
            jsame = j + size < 0x40000000;
        } else {
            joffset = -size;
            jsame = j - size >= 0;
        }
        int face = this.face();
        output.add(this.parent(level));
        output.add(S2CellId.fromFaceIJSame(face, i + ioffset, j, isame).parent(level));
        output.add(S2CellId.fromFaceIJSame(face, i, j + joffset, jsame).parent(level));
        if (isame || jsame) {
            output.add(S2CellId.fromFaceIJSame(face, i + ioffset, j + joffset, isame && jsame).parent(level));
        }
    }

    public void getAllNeighbors(int nbrLevel, List<S2CellId> output) {
        long ijo = this.toIJOrientation();
        int size = this.getSizeIJ();
        int face = this.face();
        int i = S2CellId.getI(ijo) & -size;
        int j = S2CellId.getJ(ijo) & -size;
        int nbrSize = S2CellId.getSizeIJ(nbrLevel);
        int k = -nbrSize;
        while (true) {
            boolean sameFace;
            if (k < 0) {
                sameFace = j + k >= 0;
            } else if (k >= size) {
                sameFace = j + k < 0x40000000;
            } else {
                sameFace = true;
                output.add(S2CellId.fromFaceIJSame(face, i + k, j - nbrSize, j - size >= 0).parent(nbrLevel));
                output.add(S2CellId.fromFaceIJSame(face, i + k, j + size, j + size < 0x40000000).parent(nbrLevel));
            }
            output.add(S2CellId.fromFaceIJSame(face, i - nbrSize, j + k, sameFace && i - size >= 0).parent(nbrLevel));
            output.add(S2CellId.fromFaceIJSame(face, i + size, j + k, sameFace && i + size < 0x40000000).parent(nbrLevel));
            if (k >= size) break;
            k += nbrSize;
        }
    }

    public static S2CellId fromFaceIJ(int face, int i, int j) {
        int k;
        long lsb = 0L;
        long msb = (long)face << 28;
        int bits = face & 1;
        for (k = 7; k >= 4; --k) {
            bits = S2CellId.lookupBits(i, j, k, bits);
            msb = S2CellId.updateBits(msb, k, bits);
            bits = S2CellId.maskBits(bits);
        }
        for (k = 3; k >= 0; --k) {
            bits = S2CellId.lookupBits(i, j, k, bits);
            lsb = S2CellId.updateBits(lsb, k, bits);
            bits = S2CellId.maskBits(bits);
        }
        return new S2CellId(((msb << 32) + lsb << 1) + 1L);
    }

    private static final int lookupBits(int i, int j, int k, int bits) {
        bits += (i >> k * 4 & 0xF) << 6;
        return LOOKUP_POS[bits += (j >> k * 4 & 0xF) << 2];
    }

    private static final long updateBits(long sb, int k, int bits) {
        return sb | (long)bits >> 2 << (k & 3) * 2 * 4;
    }

    private static final int maskBits(int bits) {
        return bits & 3;
    }

    long toIJOrientation() {
        int face = this.face();
        int bits = face & 1;
        int i = 0;
        int j = 0;
        for (int k = 7; k >= 0; --k) {
            int nbits = k == 7 ? 2 : 4;
            bits += ((int)(this.id >>> k * 2 * 4 + 1) & (1 << 2 * nbits) - 1) << 2;
            bits = LOOKUP_IJ[bits];
            i += bits >> 6 << k * 4;
            j += (bits >> 2 & 0xF) << k * 4;
            bits = S2CellId.maskBits(bits);
        }
        if ((this.lowestOnBit() & 0x1111111111111110L) != 0L) {
            bits ^= 1;
        }
        int orientation = bits;
        return (long)i << 33 | (long)j << 2 | (long)orientation;
    }

    public int getI() {
        return S2CellId.getI(this.toIJOrientation());
    }

    static int getI(long ijo) {
        return (int)(ijo >>> 33);
    }

    public int getJ() {
        return S2CellId.getJ(this.toIJOrientation());
    }

    static int getJ(long ijo) {
        return (int)(ijo >>> 2 & Integer.MAX_VALUE);
    }

    public int getOrientation() {
        return S2CellId.getOrientation(this.toIJOrientation());
    }

    static int getOrientation(long ijo) {
        return (int)(ijo & 3L);
    }

    public long lowestOnBit() {
        return S2CellId.lowestOnBit(this.id);
    }

    public static long lowestOnBitForLevel(int level) {
        return 1L << 2 * (30 - level);
    }

    static R2Rect ijLevelToBoundUv(int i, int j, int level) {
        R2Rect bound = new R2Rect();
        int cellSize = S2CellId.getSizeIJ(level);
        S2CellId.setAxisRange(i, cellSize, bound.x());
        S2CellId.setAxisRange(j, cellSize, bound.y());
        return bound;
    }

    private static void setAxisRange(int ij, int cellSize, R1Interval interval) {
        int lo = ij & -cellSize;
        int hi = lo + cellSize;
        interval.set(S2Projections.PROJ.stToUV(S2Projections.ijToStMin(lo)), S2Projections.PROJ.stToUV(S2Projections.ijToStMin(hi)));
    }

    private static S2CellId fromFaceIJWrap(int face, int i, int j) {
        i = Math.max(-1, Math.min(0x40000000, i));
        j = Math.max(-1, Math.min(0x40000000, j));
        double kLimit = 1.0 + S2.DBL_EPSILON;
        double u = Math.max(-kLimit, Math.min(kLimit, 9.313225746154785E-10 * (double)((i << 1) + 1 - 0x40000000)));
        double v = Math.max(-kLimit, Math.min(kLimit, 9.313225746154785E-10 * (double)((j << 1) + 1 - 0x40000000)));
        S2Projections.XyzTransform xyzTransform = S2Projections.faceToXyzTransform(face);
        double x = xyzTransform.uvToX(u, v);
        double y = xyzTransform.uvToY(u, v);
        double z = xyzTransform.uvToZ(u, v);
        face = S2Projections.xyzToFace(x, y, z);
        S2Projections.UvTransform uvTransform = S2Projections.faceToUvTransform(face);
        return S2CellId.fromFaceIJ(face, S2Projections.stToIj(0.5 * (1.0 + uvTransform.xyzToU(x, y, z))), S2Projections.stToIj(0.5 * (1.0 + uvTransform.xyzToV(x, y, z))));
    }

    public static S2CellId fromFaceIJSame(int face, int i, int j, boolean sameFace) {
        if (sameFace) {
            return S2CellId.fromFaceIJ(face, i, j);
        }
        return S2CellId.fromFaceIJWrap(face, i, j);
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2CellId)) {
            return false;
        }
        S2CellId x = (S2CellId)that;
        return this.id() == x.id();
    }

    public static boolean unsignedLongLessThan(long x1, long x2) {
        return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
    }

    public static boolean unsignedLongLessOrEquals(long x1, long x2) {
        return x1 + Long.MIN_VALUE <= x2 + Long.MIN_VALUE;
    }

    public static boolean unsignedLongGreaterThan(long x1, long x2) {
        return x1 + Long.MIN_VALUE > x2 + Long.MIN_VALUE;
    }

    public static boolean unsignedLongGreaterOrEquals(long x1, long x2) {
        return x1 + Long.MIN_VALUE >= x2 + Long.MIN_VALUE;
    }

    public boolean lessThan(S2CellId x) {
        return S2CellId.unsignedLongLessThan(this.id, x.id);
    }

    public boolean greaterThan(S2CellId x) {
        return S2CellId.unsignedLongGreaterThan(this.id, x.id);
    }

    public boolean lessOrEquals(S2CellId x) {
        return S2CellId.unsignedLongLessOrEquals(this.id, x.id);
    }

    public boolean greaterOrEquals(S2CellId x) {
        return S2CellId.unsignedLongGreaterOrEquals(this.id, x.id);
    }

    public int hashCode() {
        return (int)((this.id >>> 32) + this.id);
    }

    public String toString() {
        int n = this.face();
        String string = String.valueOf(Long.toHexString(this.pos()));
        int n2 = this.level();
        return new StringBuilder(43 + String.valueOf(string).length()).append("(face=").append(n).append(", pos=").append(string).append(", level=").append(n2).append(")").toString();
    }

    private static void initLookupCell(int level, int i, int j, int origOrientation, int pos, int orientation) {
        if (level == 4) {
            int ij = (i << 4) + j;
            S2CellId.LOOKUP_POS[(ij << 2) + origOrientation] = (pos << 2) + orientation;
            S2CellId.LOOKUP_IJ[(pos << 2) + origOrientation] = (ij << 2) + orientation;
        } else {
            ++level;
            i <<= 1;
            j <<= 1;
            pos <<= 2;
            for (int subPos = 0; subPos < 4; ++subPos) {
                int ij = S2.posToIJ(orientation, subPos);
                int orientationMask = S2.posToOrientation(subPos);
                S2CellId.initLookupCell(level, i + (ij >>> 1), j + (ij & 1), origOrientation, pos + subPos, orientation ^ orientationMask);
            }
        }
    }

    @Override
    public int compareTo(S2CellId that) {
        return S2CellId.unsignedLongLessThan(this.id, that.id) ? -1 : (S2CellId.unsignedLongGreaterThan(this.id, that.id) ? 1 : 0);
    }

    private static long fromFaceAsLong(int face) {
        return ((long)face << 61) + S2CellId.lowestOnBitForLevel(0);
    }

    private static long childBeginAsLong(long id) {
        long oldLsb = S2CellId.lowestOnBit(id);
        return id - oldLsb + (oldLsb >>> 2);
    }

    private static long childBeginAsLong(long id, int level) {
        return id - S2CellId.lowestOnBit(id) + S2CellId.lowestOnBitForLevel(level);
    }

    private static long childEndAsLong(long id) {
        long oldLsb = S2CellId.lowestOnBit(id);
        return id + oldLsb + (oldLsb >>> 2);
    }

    private static long childEndAsLong(long id, int level) {
        return id + S2CellId.lowestOnBit(id) + S2CellId.lowestOnBitForLevel(level);
    }

    private static long rangeMinAsLong(long id) {
        return id - (S2CellId.lowestOnBit(id) - 1L);
    }

    private static long rangeMaxAsLong(long id) {
        return id + (S2CellId.lowestOnBit(id) - 1L);
    }

    private static long lowestOnBit(long id) {
        return Long.lowestOneBit(id);
    }

    private static long parentAsLong(long id) {
        long newLsb = S2CellId.lowestOnBit(id) << 2;
        return id & -newLsb | newLsb;
    }

    private static long parentAsLong(long id, int level) {
        long newLsb = S2CellId.lowestOnBitForLevel(level);
        return id & -newLsb | newLsb;
    }

    private static long fromFacePosLevelAsLong(int face, long pos, int level) {
        return S2CellId.parentAsLong(((long)face << 61) + (pos | 1L), level);
    }

    static {
        S2CellId.initLookupCell(0, 0, 0, 0, 0, 0);
        S2CellId.initLookupCell(0, 0, 0, 1, 0, 1);
        S2CellId.initLookupCell(0, 0, 0, 2, 0, 2);
        S2CellId.initLookupCell(0, 0, 0, 3, 0, 3);
        FACE_CELLS = new S2CellId[6];
        for (int face = 0; face < 6; ++face) {
            S2CellId.FACE_CELLS[face] = S2CellId.fromFace(face);
        }
        MATCHES_ZERO = CharMatcher.is((char)'0');
    }
}

