/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@GwtCompatible
public final class S2PointIndex<Data> {
    private final List<Entry<Data>> entries = Lists.newArrayList();
    private boolean sorted = true;

    public int numPoints() {
        return this.entries.size();
    }

    public S2Iterator<Entry<Data>> iterator() {
        if (!this.sorted) {
            Collections.sort(this.entries);
            this.sorted = true;
        }
        return S2Iterator.create(this.entries);
    }

    public void add(S2Point point, Data data) {
        this.add(S2PointIndex.createEntry(point, data));
    }

    public void add(Entry<Data> entry) {
        this.sorted = false;
        this.entries.add(entry);
    }

    public boolean remove(S2Point point, Data data) {
        return this.remove(S2PointIndex.createEntry(point, data));
    }

    public boolean remove(Entry<Data> entry) {
        return this.entries.remove(entry);
    }

    public void reset() {
        this.sorted = true;
        this.entries.clear();
    }

    public static <Data> Entry<Data> createEntry(S2Point point, Data data) {
        return new Entry(S2CellId.fromPoint(point), point, data);
    }

    public static class Entry<Data>
    implements S2Iterator.Entry,
    Comparable<Entry<Data>> {
        private final long id;
        private final S2Point point;
        private final Data data;

        private Entry(S2CellId cellId, S2Point point, Data data) {
            this.id = cellId.id();
            this.point = point;
            this.data = data;
        }

        @Override
        public long id() {
            return this.id;
        }

        public S2Point point() {
            return this.point;
        }

        public Data data() {
            return this.data;
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                Entry e = (Entry)other;
                return this.point.equalsPoint(e.point) && Objects.equals(this.data, e.data);
            }
            return false;
        }

        public int hashCode() {
            return this.point.hashCode() * 31 + (this.data == null ? 0 : this.data.hashCode());
        }

        @Override
        public int compareTo(Entry<Data> other) {
            return UnsignedLongs.compare((long)this.id, (long)other.id);
        }

        public String toString() {
            String string = String.valueOf(new S2LatLng(this.point));
            String string2 = String.valueOf(this.data);
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString();
        }
    }
}

