/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.datastore.v1.ArrayValue;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.datastore.v1.ValueOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.NullValue;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.TimestampOrBuilder;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.appengine.repackaged.com.google.type.LatLngOrBuilder;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.ValidationUtils;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class EntityV3V1Converter {
    private static final int NANOSECONDS_PER_MICROSECOND = 1000;
    public static final EntityV3V1Converter INSTANCE = new EntityV3V1Converter();

    private EntityV3V1Converter() {
    }

    public static Timestamp microsecondsToTimestamp(long microseconds) {
        long seconds = microseconds / 1000000L;
        long microsecondsRemainder = microseconds % 1000000L;
        if (microsecondsRemainder < 0L) {
            microsecondsRemainder += 1000000L;
            --seconds;
        }
        return Timestamp.newBuilder().setSeconds(seconds).setNanos((int)microsecondsRemainder * 1000).build();
    }

    public static long toMicroseconds(TimestampOrBuilder timestamp) {
        return timestamp.getSeconds() * 1000000L + (long)(timestamp.getNanos() / 1000);
    }

    public OnestoreEntity.Reference toV3Reference(ProjectIdAppIdResolver resolver, KeyOrBuilder keyV1) throws InvalidConversionException {
        PartitionId partitionId = keyV1.getPartitionId();
        OnestoreEntity.Reference referenceV3 = this.toV3Reference(resolver, (PartitionIdOrBuilder)partitionId);
        referenceV3.setPath(this.toV3Path(keyV1.getPathList()));
        return referenceV3;
    }

    public Key.Builder toV1Key(ProjectIdAppIdResolver resolver, OnestoreEntity.Reference referenceV3) throws InvalidConversionException {
        Key.Builder keyV1 = Key.newBuilder();
        PartitionId.Builder partitionId = this.toV1PartitionId(resolver, referenceV3);
        if (partitionId != null) {
            keyV1.setPartitionId(partitionId);
        }
        for (OnestoreEntity.Path.Element pathElementV3 : referenceV3.getPath().elements()) {
            keyV1.addPath(this.toV1KeyPathElement(pathElementV3));
        }
        return keyV1;
    }

    public OnestoreEntity.Path toV3Path(List<? extends Key.PathElementOrBuilder> pathV1) {
        OnestoreEntity.Path pathV3 = new OnestoreEntity.Path();
        for (Key.PathElementOrBuilder pathElementOrBuilder : pathV1) {
            pathV3.addElement(this.toV3PathElement(pathElementOrBuilder));
        }
        return pathV3;
    }

    public List<Key.PathElement.Builder> toV1Path(OnestoreEntity.Path pathV3) throws InvalidConversionException {
        ArrayList<Key.PathElement.Builder> pathV1 = new ArrayList<Key.PathElement.Builder>(pathV3.elementSize());
        for (OnestoreEntity.Path.Element pathElementV3 : pathV3.elements()) {
            pathV1.add(this.toV1KeyPathElement(pathElementV3));
        }
        return pathV1;
    }

    public Entity.Builder toV1Entity(ProjectIdAppIdResolver resolver, OnestoreEntity.EntityProto entityV3) throws InvalidConversionException {
        Entity.Builder entityV1 = Entity.newBuilder();
        if (entityV3.hasKey() && !entityV3.getKey().getApp().isEmpty()) {
            entityV1.setKey(this.toV1Key(resolver, entityV3.getKey()));
        }
        HashMap propertyMap = Maps.newHashMap();
        for (OnestoreEntity.Property property : entityV3.propertys()) {
            this.addV3PropertyToV1Map(resolver, true, property, propertyMap);
        }
        for (OnestoreEntity.Property property : entityV3.rawPropertys()) {
            this.addV3PropertyToV1Map(resolver, false, property, propertyMap);
        }
        for (Map.Entry entry : propertyMap.entrySet()) {
            entityV1.getMutableProperties().put((String)entry.getKey(), ((Value.Builder)entry.getValue()).build());
        }
        return entityV1;
    }

    private void addV3Property(ProjectIdAppIdResolver resolver, String propertyName, boolean isMulti, ValueOrBuilder valueV1, OnestoreEntity.EntityProto entityV3) throws InvalidConversionException {
        OnestoreEntity.Property propertyV3 = this.toV3Property(resolver, propertyName, isMulti, valueV1);
        if (valueV1.getExcludeFromIndexes()) {
            entityV3.addRawProperty(propertyV3);
        } else {
            entityV3.addProperty(propertyV3);
        }
    }

    public OnestoreEntity.EntityProto toV3Entity(ProjectIdAppIdResolver resolver, EntityOrBuilder entityV1) throws InvalidConversionException {
        OnestoreEntity.EntityProto entityV3 = new OnestoreEntity.EntityProto();
        for (Map.Entry propertyV1 : entityV1.getProperties().entrySet()) {
            String propertyName = (String)propertyV1.getKey();
            Value valueV1 = (Value)propertyV1.getValue();
            if (valueV1.getValueTypeCase() == Value.ValueTypeCase.ARRAY_VALUE && valueV1.getArrayValueOrBuilder().getValuesCount() > 0) {
                for (Value subValueV1 : valueV1.getArrayValueOrBuilder().getValuesList()) {
                    this.addV3Property(resolver, propertyName, true, (ValueOrBuilder)subValueV1, entityV3);
                }
                continue;
            }
            this.addV3Property(resolver, propertyName, false, (ValueOrBuilder)valueV1, entityV3);
        }
        if (entityV1.hasKey()) {
            KeyOrBuilder keyV1 = entityV1.getKeyOrBuilder();
            OnestoreEntity.Reference referenceV3 = this.toV3Reference(resolver, keyV1);
            entityV3.setKey(referenceV3);
            if (Paths.hasIdOrName(referenceV3) || referenceV3.getPath().elementSize() > 1) {
                entityV3.setEntityGroup(Paths.getGroup(referenceV3));
            }
        }
        return entityV3;
    }

    Value.Builder toV1Value(ProjectIdAppIdResolver resolver, OnestoreEntity.Property propertyV3, boolean indexed) throws InvalidConversionException {
        String uriMeaningV3 = propertyV3.hasMeaningUri() ? propertyV3.getMeaningUri() : null;
        return this.toV1Value(resolver, propertyV3.getValue(), propertyV3.getMeaningEnum(), uriMeaningV3, indexed);
    }

    Value.Builder toV1Value(ProjectIdAppIdResolver resolver, OnestoreEntity.PropertyValue propertyValueV3, OnestoreEntity.Property.Meaning meaning, @Nullable String uriMeaning, boolean indexed) throws InvalidConversionException {
        OnestoreEntity.Property.Meaning meaningV3 = meaning;
        String uriMeaningV3 = uriMeaning;
        Value.Builder valueV1 = Value.newBuilder();
        valueV1.setExcludeFromIndexes(!indexed);
        if (!this.doubleCheckIsInternValueUnionValid(propertyValueV3)) {
            meaningV3 = null;
            uriMeaningV3 = null;
        } else if (meaningV3 == OnestoreEntity.Property.Meaning.NO_MEANING) {
            meaningV3 = null;
        } else if (!this.doubleCheckIsInternValueMeaningValid(meaningV3, propertyValueV3)) {
            meaningV3 = null;
        }
        if (meaningV3 == OnestoreEntity.Property.Meaning.EMPTY_LIST) {
            meaningV3 = null;
        }
        boolean isZlibValue = false;
        if (uriMeaningV3 != null && uriMeaningV3.equals("ZLIB") && propertyValueV3.hasStringValue()) {
            isZlibValue = true;
            if (meaningV3 != OnestoreEntity.Property.Meaning.BLOB) {
                meaningV3 = OnestoreEntity.Property.Meaning.BLOB;
            }
        }
        if (propertyValueV3.hasBooleanValue()) {
            valueV1.setBooleanValue(propertyValueV3.isBooleanValue());
        } else if (propertyValueV3.hasInt64Value()) {
            if (meaningV3 == OnestoreEntity.Property.Meaning.GD_WHEN && ValidationUtils.INSTANCE.isInRfc3339Bounds(propertyValueV3.getInt64Value())) {
                valueV1.setTimestampValue(EntityV3V1Converter.microsecondsToTimestamp(propertyValueV3.getInt64Value()));
                meaningV3 = null;
            } else {
                valueV1.setIntegerValue(propertyValueV3.getInt64Value());
            }
        } else if (propertyValueV3.hasDoubleValue()) {
            valueV1.setDoubleValue(propertyValueV3.getDoubleValue());
        } else if (propertyValueV3.hasReferenceValue()) {
            valueV1.setKeyValue(this.toV1Key(resolver, Paths.toReference(propertyValueV3)));
        } else if (propertyValueV3.hasStringValue()) {
            if (meaningV3 == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                OnestoreEntity.EntityProto entityV3;
                byte[] serializedEntityV3 = propertyValueV3.getStringValueAsBytes();
                try {
                    entityV3 = (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.parser().parsePartialFrom(serializedEntityV3);
                }
                catch (InvalidProtocolBufferException exception) {
                    entityV3 = null;
                }
                if (entityV3 == null) {
                    valueV1.setBlobValue(ByteString.copyFrom((byte[])serializedEntityV3));
                } else {
                    valueV1.setEntityValue(this.toV1Entity(resolver, entityV3));
                }
                meaningV3 = null;
            } else if (meaningV3 == OnestoreEntity.Property.Meaning.BLOB || meaningV3 == OnestoreEntity.Property.Meaning.BYTESTRING) {
                valueV1.setBlobValue(ByteString.copyFrom((byte[])propertyValueV3.getStringValueAsBytes()));
                if (indexed || meaningV3 == OnestoreEntity.Property.Meaning.BLOB) {
                    meaningV3 = null;
                }
            } else {
                ByteString byteStringValue = ByteString.copyFrom((byte[])propertyValueV3.getStringValueAsBytes());
                if (byteStringValue.isValidUtf8()) {
                    valueV1.setStringValue(propertyValueV3.getStringValue());
                } else {
                    valueV1.setBlobValue(byteStringValue);
                    if (meaningV3 != OnestoreEntity.Property.Meaning.INDEX_VALUE) {
                        meaningV3 = null;
                    }
                }
            }
        } else if (propertyValueV3.hasPointValue()) {
            valueV1.setGeoPointValue(this.toV1GeoPointValue(propertyValueV3.getPointValue()));
            if (meaningV3 == OnestoreEntity.Property.Meaning.GEORSS_POINT) {
                meaningV3 = null;
            } else if (meaningV3 != OnestoreEntity.Property.Meaning.INDEX_VALUE) {
                valueV1.setMeaning(23);
                meaningV3 = null;
            }
        } else if (propertyValueV3.hasUserValue()) {
            valueV1.setEntityValue(this.toV1Entity(propertyValueV3.getUserValue()));
            valueV1.setMeaning(20);
            meaningV3 = null;
        } else if (meaning == OnestoreEntity.Property.Meaning.EMPTY_LIST) {
            valueV1.setArrayValue(ArrayValue.getDefaultInstance());
        } else {
            valueV1.setNullValue(NullValue.NULL_VALUE);
        }
        if (isZlibValue) {
            valueV1.setMeaning(22);
        } else if (meaningV3 != null) {
            valueV1.setMeaning(meaningV3.getValue());
        }
        return valueV1;
    }

    private LatLng.Builder toV1GeoPointValue(OnestoreEntity.PropertyValue.PointValue pointValueV3) {
        return LatLng.newBuilder().setLatitude(pointValueV3.getX()).setLongitude(pointValueV3.getY());
    }

    public OnestoreEntity.PropertyValue toV3PropertyValue(ProjectIdAppIdResolver resolver, ValueOrBuilder valueV1) throws InvalidConversionException {
        OnestoreEntity.PropertyValue propertyValueV3 = new OnestoreEntity.PropertyValue();
        switch (valueV1.getValueTypeCase()) {
            case BOOLEAN_VALUE: {
                propertyValueV3.setBooleanValue(valueV1.getBooleanValue());
                break;
            }
            case INTEGER_VALUE: {
                propertyValueV3.setInt64Value(valueV1.getIntegerValue());
                break;
            }
            case DOUBLE_VALUE: {
                propertyValueV3.setDoubleValue(valueV1.getDoubleValue());
                break;
            }
            case TIMESTAMP_VALUE: {
                propertyValueV3.setInt64Value(EntityV3V1Converter.toMicroseconds(valueV1.getTimestampValueOrBuilder()));
                break;
            }
            case KEY_VALUE: {
                KeyOrBuilder keyV1 = valueV1.getKeyValueOrBuilder();
                OnestoreEntity.PropertyValue.ReferenceValue referenceValueV3 = Paths.toReferenceProperty(this.toV3Reference(resolver, keyV1)).getReferenceValue();
                propertyValueV3.setReferenceValue(referenceValueV3);
                break;
            }
            case STRING_VALUE: {
                propertyValueV3.setStringValue(valueV1.getStringValue());
                break;
            }
            case BLOB_VALUE: {
                propertyValueV3.setStringValueAsBytes(valueV1.getBlobValue().toByteArray());
                break;
            }
            case ENTITY_VALUE: {
                EntityOrBuilder entityValueV1 = valueV1.getEntityValueOrBuilder();
                if (valueV1.getMeaning() == 20) {
                    OnestoreEntity.PropertyValue.UserValue userValueV3 = this.toV3UserValue(entityValueV1);
                    propertyValueV3.setUserValue(userValueV3);
                    break;
                }
                OnestoreEntity.EntityProto entityValueV3 = this.toV3Entity(resolver, entityValueV1);
                propertyValueV3.setStringValueAsBytes(entityValueV3.toByteArray());
                break;
            }
            case GEO_POINT_VALUE: {
                propertyValueV3.setPointValue(this.toV3PointValue(valueV1.getGeoPointValueOrBuilder()));
                break;
            }
            case NULL_VALUE: {
                break;
            }
            case ARRAY_VALUE: {
                Preconditions.checkArgument((valueV1.getArrayValue().getValuesCount() == 0 ? 1 : 0) != 0, (Object)"Only empty arrays allowed");
                break;
            }
            default: {
                String string = String.valueOf(valueV1.getValueTypeCase());
                throw new InvalidConversionException(new StringBuilder(25 + String.valueOf(string).length()).append("Unrecognized value_type: ").append(string).toString());
            }
        }
        return propertyValueV3;
    }

    public OnestoreEntity.Property toV3Property(ProjectIdAppIdResolver resolver, String propertyName, boolean isMultiple, ValueOrBuilder valueV1) throws InvalidConversionException {
        OnestoreEntity.Property propertyV3 = new OnestoreEntity.Property();
        propertyV3.setName(propertyName);
        propertyV3.setMultiple(isMultiple);
        propertyV3.setValue(this.toV3PropertyValue(resolver, valueV1));
        int meaningV1 = valueV1.getMeaning();
        switch (valueV1.getValueTypeCase()) {
            case TIMESTAMP_VALUE: {
                propertyV3.setMeaning(OnestoreEntity.Property.Meaning.GD_WHEN);
                break;
            }
            case BLOB_VALUE: {
                if (meaningV1 == 22) {
                    propertyV3.setMeaningUri("ZLIB");
                }
                if (meaningV1 == 16) {
                    if (valueV1.getExcludeFromIndexes()) break;
                    break;
                }
                if (valueV1.getExcludeFromIndexes()) {
                    propertyV3.setMeaning(OnestoreEntity.Property.Meaning.BLOB);
                } else {
                    propertyV3.setMeaning(OnestoreEntity.Property.Meaning.BYTESTRING);
                }
                meaningV1 = 0;
                break;
            }
            case ENTITY_VALUE: {
                if (meaningV1 != 20) {
                    propertyV3.setMeaning(OnestoreEntity.Property.Meaning.ENTITY_PROTO);
                }
                meaningV1 = 0;
                break;
            }
            case GEO_POINT_VALUE: {
                if (meaningV1 != 23) {
                    propertyV3.setMeaning(OnestoreEntity.Property.Meaning.GEORSS_POINT);
                }
                meaningV1 = 0;
                break;
            }
            case BOOLEAN_VALUE: 
            case INTEGER_VALUE: 
            case DOUBLE_VALUE: 
            case KEY_VALUE: 
            case STRING_VALUE: 
            case NULL_VALUE: {
                break;
            }
            case ARRAY_VALUE: {
                Preconditions.checkArgument((meaningV1 == 0 ? 1 : 0) != 0, (Object)"Missing prior validation - lists have no meaning");
                Preconditions.checkArgument((valueV1.getArrayValue().getValuesCount() == 0 ? 1 : 0) != 0, (Object)"Missing prior validation - non empty lists do not belong here");
                propertyV3.setMeaning(OnestoreEntity.Property.Meaning.EMPTY_LIST);
                break;
            }
            default: {
                String string = String.valueOf(valueV1.getValueTypeCase());
                throw new InvalidConversionException(new StringBuilder(25 + String.valueOf(string).length()).append("Unrecognized value_type: ").append(string).toString());
            }
        }
        if (meaningV1 != 0) {
            OnestoreEntity.Property.Meaning meaningV3 = OnestoreEntity.Property.Meaning.valueOf((int)meaningV1);
            propertyV3.setMeaning(meaningV3);
        }
        return propertyV3;
    }

    private OnestoreEntity.Reference toV3Reference(ProjectIdAppIdResolver resolver, PartitionIdOrBuilder partitionId) throws InvalidConversionException {
        OnestoreEntity.Reference referenceV3 = new OnestoreEntity.Reference();
        referenceV3.setApp(resolver.toAppId(partitionId.getProjectId()));
        if (!partitionId.getDatabaseId().isEmpty()) {
            referenceV3.setDatabaseId(partitionId.getDatabaseId());
        }
        if (!partitionId.getNamespaceId().isEmpty()) {
            referenceV3.setNameSpace(partitionId.getNamespaceId());
        }
        return referenceV3;
    }

    private OnestoreEntity.Path.Element toV3PathElement(Key.PathElementOrBuilder keyPathElementV1) {
        OnestoreEntity.Path.Element pathElementV3 = new OnestoreEntity.Path.Element();
        pathElementV3.setType(keyPathElementV1.getKind());
        if (keyPathElementV1.getId() != 0L) {
            pathElementV3.setId(keyPathElementV1.getId());
        } else if (!keyPathElementV1.getName().isEmpty()) {
            pathElementV3.setName(keyPathElementV1.getName());
        }
        return pathElementV3;
    }

    OnestoreEntity.PropertyValue.PointValue toV3PointValue(LatLngOrBuilder latLng) {
        OnestoreEntity.PropertyValue.PointValue pointValueV3 = new OnestoreEntity.PropertyValue.PointValue();
        pointValueV3.setX(latLng.getLatitude());
        pointValueV3.setY(latLng.getLongitude());
        return pointValueV3;
    }

    OnestoreEntity.PropertyValue.UserValue toV3UserValue(EntityOrBuilder userEntity) {
        ValueOrBuilder federatedProvider;
        ValueOrBuilder federatedId;
        Map props = userEntity.getProperties();
        OnestoreEntity.PropertyValue.UserValue userValueV3 = new OnestoreEntity.PropertyValue.UserValue();
        userValueV3.setEmail(((ValueOrBuilder)props.get("email")).getStringValue());
        userValueV3.setAuthDomain(((ValueOrBuilder)props.get("auth_domain")).getStringValue());
        ValueOrBuilder internalId = (ValueOrBuilder)props.get("internal_id");
        userValueV3.setGaiaid(internalId == null ? 0L : internalId.getIntegerValue());
        ValueOrBuilder userId = (ValueOrBuilder)props.get("user_id");
        if (userId != null) {
            userValueV3.setObfuscatedGaiaid(userId.getStringValue());
        }
        if ((federatedId = (ValueOrBuilder)props.get("federated_identity")) != null) {
            userValueV3.setFederatedIdentity(federatedId.getStringValue());
        }
        if ((federatedProvider = (ValueOrBuilder)props.get("federated_provider")) != null) {
            userValueV3.setFederatedProvider(federatedProvider.getStringValue());
        }
        return userValueV3;
    }

    private void addV3PropertyToV1Map(ProjectIdAppIdResolver resolver, boolean isIndexed, OnestoreEntity.Property propertyV3, Map<String, Value.Builder> propertyMap) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!propertyV3.hasStashed(), "Property \"%s\" has field stashed", propertyV3.getName());
        InvalidConversionException.checkConversion(!propertyV3.hasComputed(), "Property \"%s\" has field computed", propertyV3.getName());
        String propertyName = propertyV3.getName();
        Value.Builder prevValueV1 = propertyMap.get(propertyName);
        if (prevValueV1 == null) {
            Value.Builder valueV1 = this.toV1Value(resolver, propertyV3, isIndexed);
            if (propertyV3.isMultiple()) {
                valueV1 = Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(valueV1));
            }
            propertyMap.put(propertyName, valueV1);
            return;
        }
        if (prevValueV1.getArrayValue().getValuesCount() == 0) {
            prevValueV1 = Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(prevValueV1));
            propertyMap.put(propertyName, prevValueV1);
        }
        if (!propertyV3.isMultiple()) {
            // empty if block
        }
        prevValueV1.getArrayValueBuilder().addValues(this.toV1Value(resolver, propertyV3, isIndexed));
    }

    boolean doubleCheckIsInternValueUnionValid(OnestoreEntity.PropertyValue propertyValueV3) {
        int numSubValues = 0;
        if (propertyValueV3.hasBooleanValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasInt64Value()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasDoubleValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasReferenceValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasStringValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasPointValue()) {
            ++numSubValues;
        }
        if (propertyValueV3.hasUserValue()) {
            ++numSubValues;
        }
        return numSubValues <= 1;
    }

    boolean doubleCheckIsInternValueMeaningValid(OnestoreEntity.Property.Meaning meaningV3, OnestoreEntity.PropertyValue propertyValueV3) {
        switch (meaningV3) {
            case NO_MEANING: 
            case INDEX_VALUE: {
                return true;
            }
            case EMPTY_LIST: {
                return propertyValueV3.equals(OnestoreEntity.PropertyValue.getDefaultInstance());
            }
            case BLOB: 
            case TEXT: 
            case BYTESTRING: 
            case ATOM_CATEGORY: 
            case ATOM_LINK: 
            case ATOM_TITLE: 
            case ATOM_CONTENT: 
            case ATOM_SUMMARY: 
            case ATOM_AUTHOR: 
            case GD_EMAIL: 
            case GD_IM: 
            case GD_PHONENUMBER: 
            case GD_POSTALADDRESS: 
            case BLOBKEY: 
            case ENTITY_PROTO: {
                return propertyValueV3.hasStringValue();
            }
            case GD_WHEN: 
            case GD_RATING: {
                return propertyValueV3.hasInt64Value();
            }
            case GEORSS_POINT: {
                return propertyValueV3.hasPointValue();
            }
        }
        return false;
    }

    public PartitionId.Builder toV1PartitionId(ProjectIdAppIdResolver resolver, OnestoreEntity.Reference referenceV3) throws InvalidConversionException {
        if (referenceV3.getApp().isEmpty()) {
            return null;
        }
        PartitionId.Builder partitionId = PartitionId.newBuilder();
        partitionId.setProjectId(resolver.toProjectId(referenceV3.getApp()));
        partitionId.setDatabaseId(referenceV3.getDatabaseId());
        InvalidConversionException.checkConversion(!referenceV3.hasNameSpace() || !referenceV3.getNameSpace().isEmpty(), "The namespace is the empty string.", new Object[0]);
        partitionId.setNamespaceId(referenceV3.getNameSpace());
        return partitionId;
    }

    private Key.PathElement.Builder toV1KeyPathElement(OnestoreEntity.Path.Element pathElementV3) throws InvalidConversionException {
        Key.PathElement.Builder keyPathElementV1 = Key.PathElement.newBuilder();
        keyPathElementV1.setKind(pathElementV3.getType());
        if (pathElementV3.getId() != 0L) {
            keyPathElementV1.setId(pathElementV3.getId());
            InvalidConversionException.checkConversion(!pathElementV3.hasName(), "Key path element has both id (%d) and name (\"%s\").", pathElementV3.getId(), pathElementV3.getName());
        } else if (pathElementV3.hasName()) {
            keyPathElementV1.setName(pathElementV3.getName());
        }
        return keyPathElementV1;
    }

    public Entity.Builder toV1Entity(OnestoreEntity.PropertyValue.UserValue userValueV3) {
        Entity.Builder entityV1 = Entity.newBuilder();
        entityV1.getMutableProperties().put("email", this.toV1UnindexedValue(userValueV3.getEmail()));
        entityV1.getMutableProperties().put("auth_domain", this.toV1UnindexedValue(userValueV3.getAuthDomain()));
        if (userValueV3.hasObfuscatedGaiaid()) {
            entityV1.getMutableProperties().put("user_id", this.toV1UnindexedValue(userValueV3.getObfuscatedGaiaid()));
        }
        if (userValueV3.getGaiaid() != 0L) {
            entityV1.getMutableProperties().put("internal_id", this.toV1UnindexedValue(userValueV3.getGaiaid()));
        }
        if (userValueV3.hasFederatedIdentity()) {
            entityV1.getMutableProperties().put("federated_identity", this.toV1UnindexedValue(userValueV3.getFederatedIdentity()));
        }
        if (userValueV3.hasFederatedProvider()) {
            entityV1.getMutableProperties().put("federated_provider", this.toV1UnindexedValue(userValueV3.getFederatedProvider()));
        }
        return entityV1;
    }

    private Value toV1UnindexedValue(String stringValue) {
        return Value.newBuilder().setStringValue(stringValue).setExcludeFromIndexes(true).build();
    }

    private Value toV1UnindexedValue(long integerValue) {
        return Value.newBuilder().setIntegerValue(integerValue).setExcludeFromIndexes(true).build();
    }

    void checkValidUtf8(ByteString byteString, String desc) throws InvalidConversionException {
        InvalidConversionException.checkConversion(byteString.isValidUtf8(), "The %s is not valid UTF-8.", desc);
    }
}

