/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.rpc.Code;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.shared.DatastoreException;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.net.rpc3.RpcStatusFactory;
import com.google.net.util.Status;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public final class DatastoreHelper
extends RepHelper {
    public static final ProjectIdResolver PROJECT_ID_RESOLVER = new ProjectIdResolver();
    public static final Function<OnestoreEntity.EntityProto, OnestoreEntity.Reference> ENTITY_TO_REFERENCE = new Function<OnestoreEntity.EntityProto, OnestoreEntity.Reference>(){

        public OnestoreEntity.Reference apply(OnestoreEntity.EntityProto entity) {
            return entity.getKey();
        }
    };
    public static final String KEY_PROPERTY_NAME = "__key__";
    public static final byte[] KEY_PROPERTY_NAME_BYTE_ARRAY = "__key__".getBytes(StandardCharsets.UTF_8);
    public static final String NAMESPACE_KIND_NAME = "__namespace__";
    public static final String NONE_KIND_NAME = "__none__";
    public static final String SPLITS_PROPERTY_NAME = "__splits__";
    public static final String ALL_NAMESPACES = "__all__";
    public static final String BLOBINFO_KIND_NAME = "__BlobInfo__";
    public static final String PROPERTY_KIND_NAME = "__property__";
    public static final String KIND_KIND_NAME = "__kind__";
    public static final Set<String> GLOBAL_STATS_KIND_NAMES = ImmutableSet.of((Object)"__Stat_Total__", (Object)"__Stat_Namespace__", (Object)"__Stat_Kind_CompositeIndex__", (Object)"__Stat_Kind__", (Object)"__Stat_Kind_IsRootEntity__", (Object)"__Stat_Kind_NotRootEntity__", (Object[])new String[]{"__Stat_PropertyType__", "__Stat_PropertyType_Kind__", "__Stat_PropertyName_Kind__", "__Stat_PropertyType_PropertyName_Kind__"});
    public static final Set<String> NAMESPACE_STATS_KIND_NAMES = ImmutableSet.of((Object)"__Stat_Ns_Total__", (Object)"__Stat_Ns_Kind_CompositeIndex__", (Object)"__Stat_Ns_Kind__", (Object)"__Stat_Ns_Kind_IsRootEntity__", (Object)"__Stat_Ns_Kind_NotRootEntity__", (Object)"__Stat_Ns_PropertyType__", (Object[])new String[]{"__Stat_Ns_PropertyType_Kind__", "__Stat_Ns_PropertyName_Kind__", "__Stat_Ns_PropertyType_PropertyName_Kind__"});
    private static final String RESERVED_DELIMITER = "__";
    private static final ByteString RESERVED_DELIMITER_BYTES = ByteString.copyFromUtf8((String)"__");
    private static final byte[] RESERVED_DELIMITER_BYTE_ARRAY = RESERVED_DELIMITER_BYTES.toByteArray();
    public static final Set<ByteString> ALLOWED_RESERVED_PROPERTY_NAMES_BYTES = ImmutableSet.of((Object)ByteString.copyFromUtf8((String)"__version__"));
    public static final Set<DatastorePb.Query.Filter.Operator> INEQUALITY_OPERATORS = ImmutableSet.of((Object)DatastorePb.Query.Filter.Operator.GREATER_THAN, (Object)DatastorePb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL, (Object)DatastorePb.Query.Filter.Operator.LESS_THAN, (Object)DatastorePb.Query.Filter.Operator.LESS_THAN_OR_EQUAL);
    public static final int MAX_QUERY_COMPONENTS = 100;
    @VisibleForTesting
    public static final ImmutableMap<Integer, Codes.Code> CANONICAL_ERROR_MAPPING = ImmutableMap.builder().put((Object)DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), (Object)Codes.Code.INVALID_ARGUMENT).put((Object)DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), (Object)Codes.Code.ABORTED).put((Object)DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), (Object)Codes.Code.INTERNAL).put((Object)DatastorePb.Error.ErrorCode.NEED_INDEX.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)DatastorePb.Error.ErrorCode.TIMEOUT.getValue(), (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)DatastorePb.Error.ErrorCode.PERMISSION_DENIED.getValue(), (Object)Codes.Code.PERMISSION_DENIED).put((Object)DatastorePb.Error.ErrorCode.BIGTABLE_ERROR.getValue(), (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)DatastorePb.Error.ErrorCode.COMMITTED_BUT_STILL_APPLYING.getValue(), (Object)Codes.Code.INTERNAL).put((Object)DatastorePb.Error.ErrorCode.CAPABILITY_DISABLED.getValue(), (Object)Codes.Code.UNAVAILABLE).put((Object)DatastorePb.Error.ErrorCode.TRY_ALTERNATE_BACKEND.getValue(), (Object)Codes.Code.UNAVAILABLE).put((Object)DatastorePb.Error.ErrorCode.SAFE_TIME_TOO_OLD.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)DatastorePb.Error.ErrorCode.RESOURCE_EXHAUSTED.getValue(), (Object)Codes.Code.RESOURCE_EXHAUSTED).put((Object)90000, (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)90001, (Object)Codes.Code.INTERNAL).put((Object)90002, (Object)Codes.Code.INTERNAL).build();

    private DatastoreHelper() {
    }

    @Deprecated
    public static String toMetadataAppIdNoDatabaseSupport(String appId) {
        return DatabaseRef.createForApp(appId, "").toMetadataDatabase().appId();
    }

    public static String fromMetadataAppId(String metadataAppId) {
        DatabaseRef databaseRef = DatabaseRef.createForApp(metadataAppId, "");
        Preconditions.checkArgument((boolean)databaseRef.isMetadata(), (String)"Invalid metadata app id: %s", (Object)metadataAppId);
        return databaseRef.toBuilder().isMetadata(false).build().appId();
    }

    public static String appToProjectId(String appId) {
        DatabaseRef parsed = DatabaseRef.createForApp(appId, "");
        if (parsed.isMetadata()) {
            String string = String.valueOf("__metadata-");
            String string2 = String.valueOf(parsed.projectId());
            String string3 = String.valueOf(RESERVED_DELIMITER);
            return new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(string3).toString();
        }
        return parsed.projectId();
    }

    public static String getCluster(String appId) {
        Matcher patternMatch = APP_ID_REGEX.matcher(appId);
        if (patternMatch.matches()) {
            return (String)MoreObjects.firstNonNull((Object)patternMatch.group("cluster"), (Object)"");
        }
        return "";
    }

    public static boolean isReserved(String name) {
        return name.length() > 2 * RESERVED_DELIMITER.length() && name.startsWith(RESERVED_DELIMITER) && name.endsWith(RESERVED_DELIMITER);
    }

    public static boolean isReserved(ByteString name) {
        return name.size() > 2 * RESERVED_DELIMITER_BYTES.size() && name.startsWith(RESERVED_DELIMITER_BYTES) && name.endsWith(RESERVED_DELIMITER_BYTES);
    }

    public static boolean isReserved(byte[] name) {
        if (name.length <= 2 * RESERVED_DELIMITER_BYTE_ARRAY.length) {
            return false;
        }
        int endBase = name.length - RESERVED_DELIMITER_BYTE_ARRAY.length;
        for (int i = 0; i < RESERVED_DELIMITER_BYTE_ARRAY.length; ++i) {
            if (name[i] != RESERVED_DELIMITER_BYTE_ARRAY[i]) {
                return false;
            }
            if (name[endBase + i] == RESERVED_DELIMITER_BYTE_ARRAY[i]) continue;
            return false;
        }
        return true;
    }

    public static Codes.Code getCanonicalCodeForAppError(@Nullable DatastorePb.Error.ErrorCode appCode) {
        if (appCode == null) {
            return Codes.Code.UNKNOWN;
        }
        return DatastoreHelper.getCanonicalCodeForAppError(appCode.getValue());
    }

    public static Codes.Code getCanonicalCodeForAppError(int appCode) {
        Codes.Code code = (Codes.Code)CANONICAL_ERROR_MAPPING.get((Object)appCode);
        if (code != null) {
            return code;
        }
        return Codes.Code.UNKNOWN;
    }

    public static Code getGoogleRpcCanonicalCodeForAppError(int appCode) {
        return Code.forNumber((int)DatastoreHelper.getCanonicalCodeForAppError(appCode).getNumber());
    }

    public static boolean isEntityValue(OnestoreEntity.Property property) {
        return property.getMeaningEnum().equals((Object)OnestoreEntity.Property.Meaning.ENTITY_PROTO);
    }

    public static Status statusFromException(DatastoreException datastoreException) {
        return RpcStatusFactory.createApplicationError((int)datastoreException.getErrorCode().getValue(), (String)datastoreException.getMessage()).withCanonicalCode(DatastoreHelper.getCanonicalCodeForAppError(datastoreException.getErrorCode()));
    }

    public static class ProjectIdResolver
    implements ProjectIdAppIdResolver {
        @Override
        public String toAppId(String projectId) throws InvalidConversionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public final String toProjectId(String appId) {
            return DatastoreHelper.appToProjectId(appId);
        }
    }
}

