/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.capabilities.dev;

import com.google.appengine.api.capabilities.CapabilityServicePb;
import com.google.appengine.api.capabilities.CapabilityStatus;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalCapabilitiesEnvironment;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import java.util.Map;

public class LocalCapabilitiesService
extends AbstractLocalRpcService {
    static final ImmutableMap<String, CapabilityStatus> CAPABILITY_STATUS_TO_SUMMARY_STATUS = new ImmutableMap.Builder().put((Object)"DEFAULT", (Object)CapabilityStatus.ENABLED).put((Object)CapabilityStatus.ENABLED.name(), (Object)CapabilityStatus.ENABLED).put((Object)CapabilityStatus.DISABLED.name(), (Object)CapabilityStatus.DISABLED).put((Object)CapabilityStatus.UNKNOWN.name(), (Object)CapabilityStatus.UNKNOWN).put((Object)CapabilityStatus.SCHEDULED_MAINTENANCE.name(), (Object)CapabilityStatus.SCHEDULED_MAINTENANCE).put((Object)String.valueOf(CapabilityStatus.SCHEDULED_MAINTENANCE.name()).concat(".future"), (Object)CapabilityStatus.SCHEDULED_MAINTENANCE).build();
    private LocalCapabilitiesEnvironment localCapabilitiesEnvironment = null;
    public static final String PACKAGE = "capability_service";

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.localCapabilitiesEnvironment = context.getLocalCapabilitiesEnvironment();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith("capability.status.")) continue;
            String value = entry.getValue();
            CapabilityStatus status = (CapabilityStatus)CAPABILITY_STATUS_TO_SUMMARY_STATUS.get((Object)value);
            if (status == null) {
                throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(value).length()).append("Capability Status: ").append(value).append(" is not known").toString());
            }
            this.localCapabilitiesEnvironment.setCapabilitiesStatus(entry.getKey(), status);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public CapabilityServicePb.IsEnabledResponse isEnabled(LocalRpcService.Status status, CapabilityServicePb.IsEnabledRequest request) {
        CapabilityServicePb.IsEnabledResponse.Builder builder = CapabilityServicePb.IsEnabledResponse.newBuilder();
        String packageName = request.getPackage();
        String capability = request.getCapability(0);
        builder.setSummaryStatus(this.getStatus(packageName, capability));
        builder.setTimeUntilScheduled(0L);
        return builder.build();
    }

    protected CapabilityServicePb.IsEnabledResponse.SummaryStatus getStatus(String packageName, String capability) {
        CapabilityStatus status = this.localCapabilitiesEnvironment.getStatusFromCapabilityName(packageName, capability);
        if (status != null) {
            if (status == CapabilityStatus.SCHEDULED_MAINTENANCE) {
                return CapabilityServicePb.IsEnabledResponse.SummaryStatus.SCHEDULED_NOW;
            }
            return CapabilityServicePb.IsEnabledResponse.SummaryStatus.valueOf((String)status.name());
        }
        return CapabilityServicePb.IsEnabledResponse.SummaryStatus.ENABLED;
    }

    public LocalCapabilitiesEnvironment getLocalCapabilitiesEnvironment() {
        return this.localCapabilitiesEnvironment;
    }

    public static String geCapabilityPropertyKey(String packageName, String capability) {
        return LocalCapabilitiesEnvironment.geCapabilityPropertyKey((String)packageName, (String)capability);
    }
}

