/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.datastore.rep.AutoValue_PropertyMask_EntityProperty;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PropertyMask {
    public static final PropertyMask FULL = new PropertyMask(false, Collections.emptyMap()){

        @Override
        public String toString() {
            return "*";
        }

        @Override
        public void mask(OnestoreEntity.EntityProto entity) {
        }

        @Override
        public void maskInto(OnestoreEntity.EntityProto newEntity, OnestoreEntity.EntityProto oldEntity) {
        }

        @Override
        public PropertyMask merge(PropertyMask other) {
            return this;
        }
    };
    private final boolean key;
    private final Map<PropertyName, PropertyMask> properties;

    public PropertyMask(boolean key, Map<PropertyName, PropertyMask> properties) {
        this.key = key;
        this.properties = ImmutableMap.copyOf(properties);
    }

    public Set<PropertyName> getPropertyNames() {
        return this.properties.keySet();
    }

    public PropertyMask getNestedMask(PropertyName name) {
        Preconditions.checkArgument((boolean)this.properties.containsKey(name));
        return this.properties.get(name);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == FULL || obj == FULL) {
            return obj == this;
        }
        if (obj instanceof PropertyMask) {
            PropertyMask that = (PropertyMask)obj;
            return this.key == that.key && this.properties.equals(that.properties);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("properties", this.properties).toString();
    }

    public PropertyMask merge(PropertyMask other) {
        if (FULL.equals(other)) {
            return other;
        }
        HashMap<PropertyName, PropertyMask> merged = new HashMap<PropertyName, PropertyMask>();
        for (PropertyName name : Sets.union(this.properties.keySet(), other.properties.keySet())) {
            PropertyMask thisNestedMask = this.properties.get(name);
            PropertyMask otherNestedMask = other.properties.get(name);
            if (thisNestedMask == null) {
                merged.put(name, otherNestedMask);
                continue;
            }
            if (otherNestedMask == null) {
                merged.put(name, thisNestedMask);
                continue;
            }
            merged.put(name, thisNestedMask.merge(otherNestedMask));
        }
        return new PropertyMask(this.key || other.key, merged);
    }

    public void mask(OnestoreEntity.EntityProto entity) {
        this.maskInternal(entity);
    }

    private boolean maskInternal(OnestoreEntity.EntityProto entity) {
        if (!this.key) {
            entity.clearKey();
        }
        boolean hasMaskedProperties = false;
        Iterator it = Iterators.concat((Iterator)entity.propertyIterator(), (Iterator)entity.rawPropertyIterator());
        while (it.hasNext()) {
            OnestoreEntity.Property property = (OnestoreEntity.Property)it.next();
            PropertyName name = PropertyName.from(property);
            PropertyMask nestedMask = this.properties.get(name);
            if (nestedMask == null) {
                it.remove();
                continue;
            }
            if (nestedMask.equals(FULL)) {
                hasMaskedProperties = true;
                continue;
            }
            OnestoreEntity.EntityProto nestedEntity = PropertyMask.getNestedEntity(property);
            if (nestedEntity == null || !nestedMask.maskInternal(nestedEntity)) {
                it.remove();
                continue;
            }
            property.getMutableValue().setStringValueAsBytes(nestedEntity.toByteArray());
            hasMaskedProperties = true;
        }
        return this.key || hasMaskedProperties;
    }

    public void maskInto(OnestoreEntity.EntityProto newEntity, OnestoreEntity.EntityProto oldEntity) {
        if (!this.key) {
            PropertyMask.copyKeyInto(oldEntity, newEntity);
        }
        HashMap<PropertyName, EntityProperty> newMerges = new HashMap<PropertyName, EntityProperty>();
        for (EntityProperty entityProperty : this.getAllProperties(newEntity)) {
            PropertyMask nestedMask = this.properties.get(entityProperty.name());
            if (nestedMask == null || nestedMask.equals(FULL)) continue;
            newMerges.put(entityProperty.name(), entityProperty);
        }
        HashMap<PropertyName, EntityProperty> oldMerges = new HashMap<PropertyName, EntityProperty>();
        for (EntityProperty oldProperty : this.getAllProperties(oldEntity)) {
            PropertyMask nestedMask = this.properties.get(oldProperty.name());
            if (nestedMask == null) {
                oldProperty.addTo(newEntity);
                continue;
            }
            if (nestedMask.equals(FULL)) continue;
            if (oldProperty.isNestedEntity()) {
                oldMerges.put(oldProperty.name(), oldProperty);
                continue;
            }
            if (newMerges.containsKey(oldProperty.name())) continue;
            oldProperty.addTo(newEntity);
        }
        Iterator iterator = Iterators.concat((Iterator)newEntity.propertyIterator(), (Iterator)newEntity.rawPropertyIterator());
        while (iterator.hasNext()) {
            if (!oldMerges.containsKey(PropertyName.from((OnestoreEntity.Property)iterator.next()))) continue;
            iterator.remove();
        }
        for (EntityProperty oldProperty : oldMerges.values()) {
            PropertyMask nestedMask = this.properties.get(oldProperty.name());
            OnestoreEntity.EntityProto merged = newMerges.containsKey(oldProperty.name()) ? ((EntityProperty)newMerges.get(oldProperty.name())).nestedEntity() : new OnestoreEntity.EntityProto();
            nestedMask.maskInto(merged, oldProperty.nestedEntity());
            oldProperty.withNestedEntity(merged).addTo(newEntity);
        }
    }

    @Nullable
    private static OnestoreEntity.EntityProto getNestedEntity(OnestoreEntity.Property property) {
        if (property.isMultiple() || property.getMeaningEnum() != OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
            return null;
        }
        try {
            return (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.parser().parsePartialFrom(property.getValue().getStringValueAsBytes());
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    private List<EntityProperty> getAllProperties(OnestoreEntity.EntityProto entity) {
        LinkedList<EntityProperty> entityProperties = new LinkedList<EntityProperty>();
        for (OnestoreEntity.Property property : entity.propertys()) {
            entityProperties.add(EntityProperty.fromIndexed(property));
        }
        for (OnestoreEntity.Property property : entity.rawPropertys()) {
            entityProperties.add(EntityProperty.fromUnindexed(property));
        }
        return entityProperties;
    }

    private static void copyKeyInto(OnestoreEntity.EntityProto src, OnestoreEntity.EntityProto dst) {
        if (src.hasKey()) {
            dst.setKey(src.getKey());
        } else {
            dst.clearKey();
        }
        if (src.hasEntityGroup()) {
            dst.setEntityGroup(src.getEntityGroup());
        } else {
            dst.clearEntityGroup();
        }
        if (src.hasKind()) {
            dst.setKind(src.getKind());
        } else {
            dst.clearKind();
        }
        if (src.hasKindUri()) {
            dst.setKindUri(src.getKindUri());
        } else {
            dst.clearKindUri();
        }
    }

    static abstract class EntityProperty {
        EntityProperty() {
        }

        abstract PropertyName name();

        abstract OnestoreEntity.Property property();

        abstract boolean indexed();

        @Nullable
        OnestoreEntity.EntityProto nestedEntity() {
            if (this.property().isMultiple() || this.property().getMeaningEnum() != OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                return null;
            }
            try {
                return (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.parser().parsePartialFrom(this.property().getValue().getStringValueAsBytes());
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }

        boolean isNestedEntity() {
            return this.nestedEntity() != null;
        }

        void addTo(OnestoreEntity.EntityProto entity) {
            if (this.indexed()) {
                entity.addProperty(this.property());
            } else {
                entity.addRawProperty(this.property());
            }
        }

        static EntityProperty fromIndexed(OnestoreEntity.Property property) {
            return new AutoValue_PropertyMask_EntityProperty(PropertyName.from(property), property, true);
        }

        static EntityProperty fromUnindexed(OnestoreEntity.Property property) {
            return new AutoValue_PropertyMask_EntityProperty(PropertyName.from(property), property, false);
        }

        EntityProperty withNestedEntity(OnestoreEntity.EntityProto nestedEntity) {
            Preconditions.checkState((boolean)this.isNestedEntity());
            OnestoreEntity.Property property = (OnestoreEntity.Property)this.property().clone();
            property.getMutableValue().setStringValueAsBytes(nestedEntity.toByteArray());
            return new AutoValue_PropertyMask_EntityProperty(this.name(), property, this.indexed());
        }
    }
}

