/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.rep.AutoValue_PropertyName;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public abstract class PropertyName {
    public abstract String string();

    public abstract byte[] bytes();

    public static PropertyName from(DatastorePb.Query.Order order) {
        return new AutoValue_PropertyName(order.getProperty(), order.getPropertyAsBytes());
    }

    public static PropertyName from(OnestoreEntity.Property property) {
        return new AutoValue_PropertyName(property.getName(), property.getNameAsBytes());
    }

    public static PropertyName from(OnestoreEntity.Index.Property indexProperty) {
        return new AutoValue_PropertyName(indexProperty.getName(), indexProperty.getNameAsBytes());
    }

    public static PropertyName fromUtf8(String name) {
        return new AutoValue_PropertyName(name, name.getBytes(StandardCharsets.UTF_8));
    }

    public static PropertyName from(byte[] nameBytes) {
        return new AutoValue_PropertyName(ProtocolSupport.toStringUtf8((byte[])nameBytes), nameBytes);
    }

    public boolean same(byte[] nameAsBytes) {
        return Arrays.equals(this.bytes(), nameAsBytes);
    }
}

