/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.RepHelper;

public class PropertyPathHelper {
    public static boolean isValidPropertyPath(ByteString propertyPath) {
        for (int i = 0; i < propertyPath.size(); ++i) {
            if (propertyPath.byteAt(i) != 92 || ++i < propertyPath.size() && (propertyPath.byteAt(i) == RepHelper.PROPERTY_PATH_DELIMITER_BYTE.byteValue() || propertyPath.byteAt(i) == 92)) continue;
            return false;
        }
        return true;
    }

    public static ImmutableList<ByteString> unescapePropertyPath(ByteString propertyPath) {
        ImmutableList.Builder propertyNames = ImmutableList.builder();
        int startIndex = 0;
        for (int i = 0; i < propertyPath.size(); ++i) {
            if (propertyPath.byteAt(i) == 92) {
                Preconditions.checkArgument((++i < propertyPath.size() && (propertyPath.byteAt(i) == RepHelper.PROPERTY_PATH_DELIMITER_BYTE.byteValue() || propertyPath.byteAt(i) == 92) ? 1 : 0) != 0);
                continue;
            }
            if (propertyPath.byteAt(i) != RepHelper.PROPERTY_PATH_DELIMITER_BYTE.byteValue()) continue;
            propertyNames.add((Object)PropertyPathHelper.unescapePropertyName(propertyPath.substring(startIndex, i)));
            startIndex = i + 1;
        }
        propertyNames.add((Object)PropertyPathHelper.unescapePropertyName(propertyPath.substring(startIndex)));
        return propertyNames.build();
    }

    private static ByteString unescapePropertyName(ByteString propertyName) {
        byte[] unescaped = new byte[propertyName.size()];
        int i = 0;
        boolean inEscapeSequence = false;
        ByteString.ByteIterator byteIterator = propertyName.iterator();
        while (byteIterator.hasNext()) {
            byte b = (Byte)byteIterator.next();
            if (!inEscapeSequence && b == 92) {
                inEscapeSequence = true;
                continue;
            }
            inEscapeSequence = false;
            unescaped[i++] = b;
        }
        return ByteString.copyFrom((byte[])unescaped, (int)0, (int)i);
    }
}

