/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.rep.QueryScope;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class Query {
    private final QueryScope scope;
    private final DatastorePb.Query v3Query;

    public Query(QueryScope scope, DatastorePb.Query v3Query) {
        this.scope = scope;
        this.v3Query = v3Query;
    }

    public QueryScope getScope() {
        return this.scope;
    }

    @Nullable
    public String getKind() {
        return this.v3Query.hasKind() && !this.v3Query.getKind().isEmpty() ? this.v3Query.getKind() : null;
    }

    public boolean isKeysOnly() {
        return this.v3Query.isKeysOnly();
    }

    public boolean isDistinct() {
        return this.v3Query.hasDistinct() ? this.v3Query.isDistinct() : true;
    }

    @Nullable
    public OnestoreEntity.Reference getAncestor() {
        return this.v3Query.hasAncestor() ? this.v3Query.getAncestor() : null;
    }

    public List<String> getProjection() {
        return this.v3Query.propertyNames();
    }

    public int getOffset() {
        return this.v3Query.getOffset();
    }

    @Nullable
    public Integer getLimit() {
        return this.v3Query.hasLimit() ? Integer.valueOf(this.v3Query.getLimit()) : null;
    }

    @Nullable
    public DatastorePb.CompiledCursor getStartCursor() {
        if (!this.v3Query.hasCompiledCursor()) {
            return null;
        }
        return this.v3Query.getCompiledCursor();
    }

    @Nullable
    public DatastorePb.CompiledCursor getEndCursor() {
        if (!this.v3Query.hasEndCompiledCursor()) {
            return null;
        }
        return this.v3Query.getEndCompiledCursor();
    }

    public List<DatastorePb.Query.Filter> getFilters() {
        return this.v3Query.filters();
    }

    public List<DatastorePb.Query.Order> getOrders() {
        return this.v3Query.orders();
    }

    public List<String> getGroupByPropertyNames() {
        return this.v3Query.groupByPropertyNames();
    }

    public boolean isShallow() {
        return this.v3Query.isShallow();
    }

    public String getLoggableString() {
        return this.v3Query.toFlatString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Query)) {
            return false;
        }
        Query other = (Query)object;
        return this.scope.equals(other.scope) && this.v3Query.equals(other.v3Query);
    }

    public int hashCode() {
        return this.v3Query.hashCode();
    }

    @Deprecated
    public DatastorePb.Query xjGetV3Query() {
        return this.v3Query;
    }
}

