/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.regex.Pattern;

public class RepHelper {
    public static final int MAX_KEY_PATH_LENGTH = 100;
    public static final int MAX_PARTITION_ID_LENGTH = 100;
    @VisibleForTesting
    public static final int MAX_APP_ID_SECTION_LENGTH = 100;
    protected static final String METADATA_PROJECT_PREFIX = "__metadata-";
    protected static final String METADATA_PROJECT_SUFFIX = "__";
    public static final String PROPERTY_PATH_DELIMITER = ".";
    public static final Byte PROPERTY_PATH_DELIMITER_BYTE = 46;
    public static final byte PROPERTY_PATH_ESCAPE_BYTE = 92;
    public static final String CLUSTER_DELIMITER = "~";
    public static final String CLUSTER_GROUP = "cluster";
    public static final String PROJECT_ID_GROUP = "project";
    public static final String METADATA_PROJECT_ID_GROUP = "metadata";
    private static final String APP_ID_PARTITION_STRING = String.format("[a-z\\d\\-]{1,%d}", 100);
    private static final String APP_ID_DOMAIN_STRING = String.format("[a-z\\d][a-z\\d\\-\\.]{0,%d}", 99);
    private static final String APP_ID_DISPLAY_STRING = String.format("[a-z\\d][a-z\\d\\-]{0,%d}", 99);
    private static final String PUBLIC_PROJECT_ID_STRING = String.format("(?:%s:)?%s", APP_ID_DOMAIN_STRING, APP_ID_DISPLAY_STRING);
    private static final String RESTRICTED_PROJECT_ID_STRING = String.format("__%s__", PUBLIC_PROJECT_ID_STRING);
    private static final String METADATA_PROJECT_ID_STRING = String.format("__metadata-(?<%s>%s|%s)__", "metadata", RESTRICTED_PROJECT_ID_STRING, PUBLIC_PROJECT_ID_STRING);
    private static final String PROJECT_ID_STRING = String.format("(?<%s>%s|%s|%s)", "project", METADATA_PROJECT_ID_STRING, RESTRICTED_PROJECT_ID_STRING, PUBLIC_PROJECT_ID_STRING);
    public static final Pattern APP_ID_REGEX = Pattern.compile(String.format("(?:(?<%s>%s)%s)?%s", "cluster", APP_ID_PARTITION_STRING, "~", PROJECT_ID_STRING));
    public static final Pattern PROJECT_ID_REGEX = Pattern.compile(PROJECT_ID_STRING);
    public static final Pattern PARTITION_ID_REGEX;
    public static final Pattern DATABASE_ID_REGEX;
    public static final Pattern PLACEMENT_ID_REGEX;
    public static final long ENTITY_VERSION_NONE = -1L;

    protected RepHelper() {
    }

    public static String projectIdToApp(String cluster, String projectId) {
        Preconditions.checkArgument((!projectId.contains(CLUSTER_DELIMITER) ? 1 : 0) != 0);
        if (cluster.isEmpty()) {
            return projectId;
        }
        return String.format("%s%s%s", cluster, CLUSTER_DELIMITER, projectId);
    }

    static {
        DATABASE_ID_REGEX = PARTITION_ID_REGEX = Pattern.compile(String.format("[0-9A-Za-z\\._\\-]{0,%d}", 100));
        PLACEMENT_ID_REGEX = PARTITION_ID_REGEX;
    }
}

