/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPathHelper;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class CloudDatastoreV1ToRepConverter {
    private static final PropertyMask KEY_ONLY = new PropertyMask(true, Collections.emptyMap());

    public PropertyMask toPropertyMask(com.google.appengine.repackaged.com.google.datastore.v1.PropertyMask propertyMask) throws InvalidConversionException {
        LinkedList<ListIterator<ByteString>> paths = new LinkedList<ListIterator<ByteString>>();
        for (ByteString path : propertyMask.getPathsList().asByteStringList()) {
            paths.add((ListIterator<ByteString>)PropertyPathHelper.unescapePropertyPath(path).listIterator());
        }
        return this.toPropertyMask(paths).merge(KEY_ONLY);
    }

    private PropertyMask toPropertyMask(Collection<ListIterator<ByteString>> paths) throws InvalidConversionException {
        boolean key = false;
        HashMap<PropertyName, PropertyMask> nestedMasks = new HashMap<PropertyName, PropertyMask>();
        HashMultimap nestedPaths = HashMultimap.create();
        for (ListIterator<ByteString> listIterator : paths) {
            PropertyName propertyName = PropertyName.from(listIterator.next().toByteArray());
            if (propertyName.same(DatastoreHelper.KEY_PROPERTY_NAME_BYTE_ARRAY)) {
                InvalidConversionException.checkConversion(!listIterator.hasNext(), "a property path in a field mask cannot traverse the __key__ property", new Object[0]);
                key = true;
                continue;
            }
            if (!listIterator.hasNext()) {
                nestedMasks.put(propertyName, PropertyMask.FULL);
                nestedPaths.removeAll((Object)propertyName);
                continue;
            }
            if (nestedMasks.containsKey(propertyName)) continue;
            nestedPaths.put((Object)propertyName, listIterator);
        }
        for (Map.Entry entry : nestedPaths.asMap().entrySet()) {
            nestedMasks.put((PropertyName)entry.getKey(), this.toPropertyMask((Collection)entry.getValue()));
        }
        return new PropertyMask(key, nestedMasks);
    }
}

