/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.FilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GeoRegion;
import com.google.appengine.repackaged.com.google.datastore.v1.GeoRegionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameter;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpressionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.ProjectionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyMask;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrderOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReferenceOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.StContainsFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.ValueOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.type.LatLngOrBuilder;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.rep.PropertyPathHelper;
import com.google.apphosting.datastore.shared.CloudV1DatabaseRefValidator;
import com.google.apphosting.datastore.shared.EntityV1Validator;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.QueryHelper;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CloudDatastoreV1Validator {
    private static final Pattern GQL_ARG_NAME_CHARACTER_SET_PATTERN = Pattern.compile("[A-Za-z0-9_$\u0080-\uffff]*");
    protected final EntityV1Validator entityValidator;

    public CloudDatastoreV1Validator(EntityV1Validator entityValidator) {
        this.entityValidator = entityValidator;
    }

    public EntityV1Validator getEntityValidator() {
        return this.entityValidator;
    }

    static ValidationConstraint constraintForMutation(Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return ValidationConstraint.INSERT;
            }
            case UPDATE: {
                return ValidationConstraint.UPDATE;
            }
            case UPSERT: {
                return ValidationConstraint.UPSERT;
            }
            case DELETE: {
                return ValidationConstraint.DELETE;
            }
        }
        throw new ValidationException("Mutation is missing operation.");
    }

    public void validateMutation(ValidationConstraint constraint, DatabaseRef requestInternalDatabase, Mutation mutation) throws ValidationException {
        Key keyToValidate = null;
        switch (mutation.getOperationCase()) {
            case INSERT: {
                this.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutation.getInsert());
                keyToValidate = mutation.getInsert().getKey();
                break;
            }
            case UPDATE: {
                this.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutation.getUpdate());
                keyToValidate = mutation.getUpdate().getKey();
                break;
            }
            case UPSERT: {
                this.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutation.getUpsert());
                keyToValidate = mutation.getUpsert().getKey();
                break;
            }
            case DELETE: {
                this.entityValidator.validateKey(constraint, (KeyOrBuilder)mutation.getDelete());
                keyToValidate = mutation.getDelete();
                break;
            }
            default: {
                throw new ValidationException("mutation lacks required op");
            }
        }
        PartitionId keyPartitionId = keyToValidate.getPartitionId();
        CloudV1DatabaseRefValidator.INSTANCE.validateDatabaseRefMatches(requestInternalDatabase, keyPartitionId.getProjectId(), keyPartitionId.getDatabaseId());
        ValidationException.validateAssertion(this.getEntityValidator().getConfig().getAllowMutationBaseVersion() || mutation.getConflictDetectionStrategyCase() == Mutation.ConflictDetectionStrategyCase.CONFLICTDETECTIONSTRATEGY_NOT_SET, "setting base_version in mutation is not allowed", new Object[0]);
        if (mutation.getConflictDetectionStrategyCase() != Mutation.ConflictDetectionStrategyCase.CONFLICTDETECTIONSTRATEGY_NOT_SET) {
            ValidationException.validateAssertion(!Paths.hasIncompleteLastElement((KeyOrBuilder)keyToValidate), "conflict detection is not allowed for incomplete keys", new Object[0]);
        }
        if (mutation.getConflictDetectionStrategyCase() == Mutation.ConflictDetectionStrategyCase.BASE_VERSION) {
            ValidationException.validateAssertion(mutation.getBaseVersion() >= 0L, "Invalid base_version: %d, it should be >= 0", mutation.getBaseVersion());
        }
        if (mutation.hasPropertyMask()) {
            this.validatePropertyMask(constraint.withContext(ValidationConstraint.Context.IN_PROPERTY_MASK), mutation.getPropertyMask());
        }
    }

    public void validatePropertyMask(ValidationConstraint constraint, PropertyMask propertyMask) throws ValidationException {
        for (ByteString path : propertyMask.getPathsList().asByteStringList()) {
            ValidationException.validateAssertion(!path.isEmpty(), "a property path must not be empty.", new Object[0]);
            ValidationException.validateAssertion(PropertyPathHelper.isValidPropertyPath(path), "a property path may not contain an invalid escape sequence", new Object[0]);
            this.validatePropertyPath(constraint, (List<ByteString>)PropertyPathHelper.unescapePropertyPath(path));
        }
    }

    private void validatePropertyPath(ValidationConstraint constraint, List<ByteString> path) throws ValidationException {
        int prefixLength = 0;
        for (ByteString propertyName : path) {
            this.entityValidator.validatePropertyName(constraint, propertyName, prefixLength, "property_mask");
            prefixLength += propertyName.size() + ".".length();
        }
    }

    public void validateCommitMode(CommitRequest.Mode mode, boolean hasTransaction) throws ValidationException {
        switch (mode) {
            case MODE_UNSPECIFIED: 
            case TRANSACTIONAL: {
                ValidationException.validateAssertion(hasTransaction, "transactional commit requires a transaction", new Object[0]);
                break;
            }
            case NON_TRANSACTIONAL: {
                ValidationException.validateAssertion(!hasTransaction, "non-transaction commit cannot specify a transaction", new Object[0]);
                break;
            }
            default: {
                String string = String.valueOf(mode);
                throw new ValidationException(new StringBuilder(21 + String.valueOf(string).length()).append("unknown commit mode: ").append(string).toString());
            }
        }
    }

    public void validateReadOptions(ReadOptions readOptions) throws ValidationException {
        if (readOptions.getConsistencyTypeCase() == ReadOptions.ConsistencyTypeCase.TRANSACTION) {
            this.validateTransactionBytes(readOptions.getTransaction());
        } else if (readOptions.getConsistencyTypeCase() == ReadOptions.ConsistencyTypeCase.READ_CONSISTENCY) {
            ValidationException.validateAssertion(readOptions.getReadConsistency() != ReadOptions.ReadConsistency.READ_CONSISTENCY_UNSPECIFIED, "ReadConsistency must be specified.", new Object[0]);
        }
        ValidationException.validateAssertion(readOptions.getConsistencyTypeCase() != ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION || this.getEntityValidator().getConfig().getAllowNewTransactionReadOptions(), "setting new_transaction in read_options is not allowed.", new Object[0]);
    }

    public void validateTransactionBytes(ByteString transaction) throws ValidationException {
        ValidationException.validateAssertion(!transaction.isEmpty(), "a transaction cannot be the empty string.", new Object[0]);
    }

    public void validateQuery(ValidationConstraint constraint, boolean isStrongReadConsistency, QueryOrBuilder query) throws ValidationException {
        boolean isSearchQuery = QueryHelper.isSearchQuery(query);
        if (isSearchQuery) {
            ValidationException.validateAssertion(!isStrongReadConsistency, "geo queries do not support strong consistency", new Object[0]);
            ValidationException.validateAssertion(query.getOrderCount() == 0, "geo queries do not support ordering", new Object[0]);
        }
        if (query.hasFilter()) {
            this.validateFilter(constraint, isSearchQuery, (FilterOrBuilder)query.getFilter());
        }
        ValidationException.validateAssertion(!isStrongReadConsistency || QueryHelper.hasAncestorOrParent(query), "global queries do not support strong consistency", new Object[0]);
        for (KindExpressionOrBuilder kindExp : query.getKindOrBuilderList()) {
            this.validateKindExpression(constraint, kindExp);
        }
        for (PropertyReferenceOrBuilder propRef : query.getDistinctOnOrBuilderList()) {
            this.validatePropertyReference(constraint, propRef);
        }
        for (ProjectionOrBuilder propExp : query.getProjectionOrBuilderList()) {
            this.validateProjection(constraint, propExp);
        }
        for (PropertyOrderOrBuilder order : query.getOrderOrBuilderList()) {
            this.validatePropertyOrder(constraint, order);
        }
        ValidationException.validateAssertion(query.getLimit().getValue() >= 0, "Limit must be non-negative.", new Object[0]);
        ValidationException.validateAssertion(query.getOffset() >= 0, "Offset must be non-negative.", new Object[0]);
    }

    public void validateGqlQuery(GqlQueryOrBuilder gqlQuery) throws ValidationException {
        for (Map.Entry namedGqlQueryParam : gqlQuery.getNamedBindings().entrySet()) {
            String name = (String)namedGqlQueryParam.getKey();
            this.entityValidator.validateStringNotEmpty(name, "GQL query parameter name is empty.");
            ValidationException.validateAssertion(GQL_ARG_NAME_CHARACTER_SET_PATTERN.matcher(name).matches(), "GQL query parameter name \"%s\" contains an invalid character.", name);
            ValidationException.validateAssertion(!Character.isDigit(name.charAt(0)), "GQL query parameter name \"%s\" starts with a digit.", name);
            this.entityValidator.validateStringNotReserved(name, "GQL query parameter name");
            this.validateGqlQueryParam((GqlQueryParameterOrBuilder)namedGqlQueryParam.getValue());
        }
        for (GqlQueryParameter numberedGqlQueryParam : gqlQuery.getPositionalBindingsList()) {
            this.validateGqlQueryParam((GqlQueryParameterOrBuilder)numberedGqlQueryParam);
        }
    }

    private void validateGqlQueryParam(GqlQueryParameterOrBuilder gqlQueryParam) throws ValidationException {
        switch (gqlQueryParam.getParameterTypeCase()) {
            case VALUE: 
            case CURSOR: {
                break;
            }
            case GEO_REGION: {
                ValidationException.validateAssertion(this.getEntityValidator().getConfig().getAllowStContainsFilter(), "using a geo region as GQL parameter is not allowed", new Object[0]);
                this.validateGeoRegion((GeoRegionOrBuilder)gqlQueryParam.getGeoRegion());
                break;
            }
            case PARAMETERTYPE_NOT_SET: {
                throw new ValidationException("A GQL query parameter is empty.");
            }
            default: {
                String string = String.valueOf(gqlQueryParam.getParameterTypeCase());
                throw new ValidationException(new StringBuilder(39 + String.valueOf(string).length()).append("Unrecognized GQL query parameter_type: ").append(string).toString());
            }
        }
    }

    private void validatePropertyOrder(ValidationConstraint constraint, PropertyOrderOrBuilder order) throws ValidationException {
        this.validatePropertyReference(constraint, (PropertyReferenceOrBuilder)order.getProperty());
    }

    private void validateProjection(ValidationConstraint constraint, ProjectionOrBuilder propExp) throws ValidationException {
        this.validatePropertyReference(constraint, propExp.getPropertyOrBuilder());
    }

    private void validateKindExpression(ValidationConstraint constraint, KindExpressionOrBuilder kindExp) throws ValidationException {
        this.entityValidator.validateKind(constraint, kindExp.getNameBytes());
    }

    void validatePropertyReference(ValidationConstraint constraint, PropertyReferenceOrBuilder propertyRef) throws ValidationException {
        this.entityValidator.validatePropertyName(constraint, propertyRef.getNameBytes());
    }

    private void validateFilter(ValidationConstraint constraint, boolean isSearchQuery, FilterOrBuilder filter) throws ValidationException {
        switch (filter.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                CompositeFilterOrBuilder cmpFilter = filter.getCompositeFilterOrBuilder();
                ValidationException.validateAssertion(cmpFilter.getOp() != CompositeFilter.Operator.OPERATOR_UNSPECIFIED, "a composite filter must specify an operator", new Object[0]);
                ValidationException.validateAssertion(cmpFilter.getFiltersCount() > 0, "a composite filter must have at least one sub-filter", new Object[0]);
                for (Filter subFilter : cmpFilter.getFiltersList()) {
                    this.validateFilter(constraint, isSearchQuery, (FilterOrBuilder)subFilter);
                }
                break;
            }
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
                ValidationException.validateAssertion(propFilter.getOp() != PropertyFilter.Operator.OPERATOR_UNSPECIFIED, "a property filter must specify an operator", new Object[0]);
                ValidationException.validateAssertion(!isSearchQuery || propFilter.getOp() == PropertyFilter.Operator.EQUAL, "only equality filters are allowed in geo queries", new Object[0]);
                this.validatePropertyReference(constraint, propFilter.getPropertyOrBuilder());
                ValidationException.validateAssertion(!propFilter.getValueOrBuilder().getExcludeFromIndexes(), "a filter value must be indexed", new Object[0]);
                if (propFilter.getProperty().getName().endsWith(".__key__")) {
                    constraint = constraint.withContext(ValidationConstraint.Context.IN_FILTER_ON_ENTITY_VALUE_KEY);
                }
                this.entityValidator.validateValue(constraint, (ValueOrBuilder)propFilter.getValue(), 0, 0, propFilter.getPropertyOrBuilder().getName());
                break;
            }
            case ST_CONTAINS_FILTER: {
                ValidationException.validateAssertion(this.entityValidator.getConfig().getAllowStContainsFilter(), "using an StContains filter is not allowed", new Object[0]);
                StContainsFilter stContainsFilter = filter.getStContainsFilter();
                this.validatePropertyReference(constraint, stContainsFilter.getPropertyOrBuilder());
                this.validateGeoRegion((GeoRegionOrBuilder)stContainsFilter.getContainedIn());
                break;
            }
            case FILTERTYPE_NOT_SET: {
                throw new ValidationException("a filter must have exactly one of its fields set");
            }
            default: {
                String string = String.valueOf(filter.getFilterTypeCase());
                throw new ValidationException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized filter_type: ").append(string).toString());
            }
        }
    }

    private void validateGeoRegion(GeoRegionOrBuilder region) throws ValidationException {
        switch (region.getShapeCase()) {
            case CIRCLE: {
                GeoRegion.Circle circle = region.getCircle();
                this.entityValidator.validateLatLng((LatLngOrBuilder)circle.getCenter());
                ValidationException.validateAssertion(circle.getRadiusMeters() >= 0.0, "a geo circle must have a non-negative radius", new Object[0]);
                break;
            }
            case RECTANGLE: {
                GeoRegion.Rectangle rectangle = region.getRectangle();
                this.entityValidator.validateLatLng((LatLngOrBuilder)rectangle.getSouthwest());
                this.entityValidator.validateLatLng((LatLngOrBuilder)rectangle.getNortheast());
                ValidationException.validateAssertion(rectangle.getSouthwest().getLatitude() <= rectangle.getNortheast().getLatitude(), "a geo rectangle must not have a southwest point at a latitude greater than the northeast point", new Object[0]);
                break;
            }
            case SHAPE_NOT_SET: {
                throw new ValidationException("a geo region must specify a shape");
            }
            default: {
                String string = String.valueOf(region.getShapeCase());
                throw new ValidationException(new StringBuilder(20 + String.valueOf(string).length()).append("Unrecognized shape: ").append(string).toString());
            }
        }
    }
}

