/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.apphosting.datastore.shared.ValidationUtils;
import javax.annotation.Nullable;

public final class DatabaseRefValidator {
    public static final DatabaseRefValidator INSTANCE = new DatabaseRefValidator();

    private DatabaseRefValidator() {
    }

    public DatabaseRef validateDatabaseRefMatch(DatabaseRef testDatabase, @Nullable DatabaseRef expectedDatabase) throws ValidationException {
        if (expectedDatabase != null && !testDatabase.equals(expectedDatabase)) {
            throw new ValidationException(String.format("%s%s vs. %s", "mismatched databases within request: ", testDatabase, expectedDatabase));
        }
        return testDatabase;
    }

    public DatabaseRef createAndValidateDatabaseRef(@Nullable byte[] appIdBytesArray, @Nullable byte[] databaseIdBytesArray) throws ValidationException {
        ByteString appId = appIdBytesArray == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])appIdBytesArray);
        ByteString databaseId = databaseIdBytesArray == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])databaseIdBytesArray);
        return this.createAndValidateDatabaseRef(appId, databaseId);
    }

    public DatabaseRef createAndValidateDatabaseRef(String placementId, String projectId, String databaseId) throws ValidationException {
        ValidationException.validateAssertion(!Strings.isNullOrEmpty((String)placementId), "Must have a placement id.", new Object[0]);
        ValidationException.validateAssertion(!Strings.isNullOrEmpty((String)projectId), "Must have a project id.", new Object[0]);
        ValidationException.validateAssertion(!Strings.isNullOrEmpty((String)databaseId), "Must have a database id.", new Object[0]);
        ValidationException.validateAssertion(RepHelper.PROJECT_ID_REGEX.matcher(projectId).matches(), "\"%s\" is an invalid %s.", projectId, "project id");
        ValidationException.validateAssertion(RepHelper.DATABASE_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", databaseId, "database id");
        ValidationException.validateAssertion(RepHelper.PLACEMENT_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", placementId, "placement id");
        return DatabaseRef.createWithPlacement(placementId, projectId, databaseId);
    }

    public DatabaseRef createAndValidateDatabaseRef(ByteString appIdBytes, ByteString databaseIdBytes) throws ValidationException {
        ValidationUtils.INSTANCE.validateStringUtf8(appIdBytes, "app id");
        ValidationUtils.INSTANCE.validateStringUtf8(databaseIdBytes, "database id");
        String appId = appIdBytes.toStringUtf8();
        String databaseId = databaseIdBytes.toStringUtf8();
        ValidationException.validateAssertion(!appId.isEmpty(), "The app id is the empty string.", new Object[0]);
        ValidationException.validateAssertion(RepHelper.APP_ID_REGEX.matcher(appId).matches(), "\"%s\" is an invalid %s.", appId, "app id");
        if (!databaseId.isEmpty()) {
            ValidationException.validateAssertion(RepHelper.DATABASE_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", databaseId, "database id");
        }
        return DatabaseRef.createForApp(appId, databaseId);
    }
}

