/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResult;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResultOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.FilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GeoRegion;
import com.google.appengine.repackaged.com.google.datastore.v1.GeoRegionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQuery;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameter;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpression;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpressionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Projection;
import com.google.appengine.repackaged.com.google.datastore.v1.ProjectionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrderOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReferenceOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatch;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatchOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.StContainsFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.datastore.v1.ValueOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.NullValue;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.appengine.repackaged.com.google.type.LatLngOrBuilder;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.CompiledCursorUtil;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.EntityV3V1Converter;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.EquivalentMessageConverter;
import com.google.apphosting.datastore.shared.GqlParser;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ParseException;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.TokenMgrError;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DatastoreProtoConverter {
    public static final Function<OnestoreEntity.CompositeIndex, OnestoreEntity.CompositeIndex> V3_TO_V4_COMPOSITE_INDEX_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.parser());
    public static final Function<OnestoreEntity.CompositeIndex, OnestoreEntity.CompositeIndex> V4_TO_V3_COMPOSITE_INDEX_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.parser());
    protected final EntityV4Converter entityV4Converter;
    protected final Config.DatastoreConfig datastoreConfig;

    protected static <V3 extends MessageLite, V4 extends MessageLite> ImmutableList<V4> convertList(List<V3> list, Function<V3, V4> converter) {
        return ImmutableList.copyOf((Collection)Lists.transform(list, converter));
    }

    public DatastoreProtoConverter(EntityV4Converter entityConverter, Config.DatastoreConfig datastoreConfig) {
        this.entityV4Converter = (EntityV4Converter)Preconditions.checkNotNull((Object)entityConverter);
        this.datastoreConfig = (Config.DatastoreConfig)Preconditions.checkNotNull((Object)datastoreConfig);
    }

    public EntityV4Converter getEntityConverter() {
        return this.entityV4Converter;
    }

    public Config.DatastoreConfig getDatastoreConfig() {
        return this.datastoreConfig;
    }

    public ByteString toV1QueryCursor(DatastorePb.CompiledCursor compiledCursor) {
        return this.toV1CursorBytes(compiledCursor.toByteString());
    }

    public DatastorePb.CompiledCursor toV3CompiledCursor(ByteString cursorBytesV1) throws InvalidConversionException {
        try {
            return (DatastorePb.CompiledCursor)DatastorePb.CompiledCursor.parser().parseFrom(this.toV3OrV4CursorBytes(cursorBytesV1));
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }

    public ImmutableList<OnestoreEntity.CompositeIndex> toV3CompositeIndex(List<OnestoreEntity.CompositeIndex> compositeIndexes) {
        return DatastoreProtoConverter.convertList(compositeIndexes, V4_TO_V3_COMPOSITE_INDEX_CONVERTER);
    }

    public ImmutableList<OnestoreEntity.CompositeIndex> toV4CompositeIndex(List<OnestoreEntity.CompositeIndex> compositeIndexes) {
        return DatastoreProtoConverter.convertList(compositeIndexes, V3_TO_V4_COMPOSITE_INDEX_CONVERTER);
    }

    public Query.Builder toV1Query(GqlQueryOrBuilder gqlQueryV1, PartitionId partitionIdV1) throws InvalidConversionException {
        try {
            return new GqlParser(gqlQueryV1, partitionIdV1, GqlParser.Version.V1).selector();
        }
        catch (ParseException | TokenMgrError exception) {
            throw new InvalidConversionException(exception.getMessage());
        }
    }

    public Query.Builder toV1Query(ProjectIdAppIdResolver resolver, DatastorePb.Query query) throws InvalidConversionException {
        Query.Builder builder = Query.newBuilder();
        if (query.hasLimit()) {
            builder.getLimitBuilder().setValue(query.getLimit());
        }
        if (query.getOffset() != 0) {
            builder.setOffset(query.getOffset());
        }
        if (query.hasCompiledCursor()) {
            builder.setStartCursor(this.toV1QueryCursor(query.getCompiledCursor()));
        }
        if (query.hasEndCompiledCursor()) {
            builder.setEndCursor(this.toV1QueryCursor(query.getEndCompiledCursor()));
        }
        if (query.hasKind()) {
            builder.addKindBuilder().setName(query.getKind());
        }
        InvalidConversionException.checkConversion(query.propertyNameSize() <= 0 || !query.isKeysOnly(), "projection and keys_only cannot both be set", new Object[0]);
        for (String name : query.propertyNames()) {
            Projection.Builder projBuilder = builder.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName(name);
        }
        if (query.isKeysOnly()) {
            Projection.Builder projBuilder = builder.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName("__key__");
        }
        for (String name : query.groupByPropertyNames()) {
            builder.addDistinctOnBuilder().setName(name);
        }
        CompositeFilter.Builder filter = CompositeFilter.newBuilder();
        filter.setOp(CompositeFilter.Operator.AND);
        if (query.hasAncestor() || query.isShallow()) {
            PropertyFilter.Builder propFilter = filter.addFiltersBuilder().getPropertyFilterBuilder();
            propFilter.setOp(query.isShallow() ? PropertyFilter.Operator.HAS_PARENT : PropertyFilter.Operator.HAS_ANCESTOR);
            propFilter.getPropertyBuilder().setName("__key__");
            if (query.hasAncestor()) {
                propFilter.setValue(Value.newBuilder().setKeyValue(EntityV3V1Converter.INSTANCE.toV1Key(resolver, query.getAncestor())));
            } else {
                propFilter.setValue(Value.newBuilder().setNullValue(NullValue.NULL_VALUE));
            }
        }
        for (DatastorePb.Query.Filter filterV3 : query.filters()) {
            InvalidConversionException.checkConversion(filterV3.propertySize() == 1, "invalid filter", new Object[0]);
            DatastorePb.Query.Filter.Operator operatorV3 = filterV3.getOpEnum();
            String propertyName = filterV3.getProperty(0).getName();
            if (operatorV3 == DatastorePb.Query.Filter.Operator.CONTAINED_IN_REGION) {
                StContainsFilter.Builder stContainsFilter = filter.addFiltersBuilder().getStContainsFilterBuilder();
                stContainsFilter.getPropertyBuilder().setName(propertyName);
                stContainsFilter.setContainedIn(this.toV1GeoRegion(filterV3.getGeoRegion()));
                continue;
            }
            PropertyFilter.Builder propFilter = filter.addFiltersBuilder().getPropertyFilterBuilder();
            propFilter.setOp(this.toV1PropertyFilterOperator(operatorV3));
            propFilter.getPropertyBuilder().setName(propertyName);
            propFilter.setValue(EntityV3V1Converter.INSTANCE.toV1Value(resolver, filterV3.getProperty(0), true));
        }
        if (filter.getFiltersCount() == 1) {
            builder.setFilter(filter.getFiltersBuilder(0));
        } else if (filter.getFiltersCount() > 1) {
            builder.getFilterBuilder().setCompositeFilter(filter);
        }
        block7: for (DatastorePb.Query.Order order : query.orders()) {
            PropertyOrder.Builder orderV1 = builder.addOrderBuilder();
            orderV1.getPropertyBuilder().setName(order.getProperty());
            if (!order.hasDirection()) continue;
            switch (order.getDirectionEnum()) {
                case ASCENDING: {
                    orderV1.setDirection(PropertyOrder.Direction.ASCENDING);
                    continue block7;
                }
                case DESCENDING: {
                    orderV1.setDirection(PropertyOrder.Direction.DESCENDING);
                    continue block7;
                }
            }
            throw DatastoreProtoConverter.unrecognizedEnumValue("direction", order.getDirectionEnum());
        }
        return builder;
    }

    private PropertyFilter.Operator toV1PropertyFilterOperator(DatastorePb.Query.Filter.Operator operatorV3) throws InvalidConversionException {
        switch (operatorV3) {
            case LESS_THAN: {
                return PropertyFilter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return PropertyFilter.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case EQUAL: 
            case IN: {
                return PropertyFilter.Operator.EQUAL;
            }
            case EXISTS: {
                String string = String.valueOf(operatorV3);
                throw new InvalidConversionException(new StringBuilder(20 + String.valueOf(string).length()).append("unsupported filter: ").append(string).toString());
            }
        }
        throw DatastoreProtoConverter.unrecognizedEnumValue("property_filter.op", operatorV3);
    }

    private GeoRegion toV1GeoRegion(DatastorePb.GeoRegion regionV3) throws InvalidConversionException {
        GeoRegion.Builder region = GeoRegion.newBuilder();
        if (regionV3.hasCircle()) {
            DatastorePb.CircleRegion circleV3 = regionV3.getCircle();
            region.getCircleBuilder().setCenter(this.toV1LatLng(circleV3.getCenter())).setRadiusMeters(circleV3.getRadiusMeters());
        } else if (regionV3.hasRectangle()) {
            DatastorePb.RectangleRegion rectangleV3 = regionV3.getRectangle();
            region.getRectangleBuilder().setSouthwest(this.toV1LatLng(rectangleV3.getSouthwest())).setNortheast(this.toV1LatLng(rectangleV3.getNortheast()));
        } else {
            String string = String.valueOf(regionV3);
            throw new InvalidConversionException(new StringBuilder(24 + String.valueOf(string).length()).append("unsupported geo region: ").append(string).toString());
        }
        return region.build();
    }

    private LatLng toV1LatLng(DatastorePb.RegionPoint pointV3) {
        return LatLng.newBuilder().setLatitude(pointV3.getLatitude()).setLongitude(pointV3.getLongitude()).build();
    }

    public DatastorePb.Query toV3Query(ProjectIdAppIdResolver resolver, PartitionIdOrBuilder partitionId, QueryOrBuilder query) throws InvalidConversionException {
        DatastorePb.Query result = new DatastorePb.Query();
        result.setApp(resolver.toAppId(partitionId.getProjectId()));
        if (!partitionId.getDatabaseId().isEmpty()) {
            result.setDatabaseId(partitionId.getDatabaseId());
        }
        if (!partitionId.getNamespaceId().isEmpty()) {
            result.setNameSpace(partitionId.getNamespaceId());
        }
        result.setPersistOffset(true);
        result.setRequirePerfectPlan(true);
        result.setCompile(true);
        if (query.hasLimit()) {
            result.setLimit(query.getLimit().getValue());
        }
        if (query.getOffset() != 0) {
            result.setOffset(query.getOffset());
        }
        if (!query.getStartCursor().isEmpty()) {
            result.setCompiledCursor(this.toV3CompiledCursor(query.getStartCursor()));
        }
        if (!query.getEndCursor().isEmpty()) {
            result.setEndCompiledCursor(this.toV3CompiledCursor(query.getEndCursor()));
        }
        if (query.getKindCount() > 0) {
            InvalidConversionException.checkConversion(query.getKindCount() == 1, "multiple kinds not supported", new Object[0]);
            result.setKind(query.getKind(0).getName());
        }
        boolean hasKeyProjection = false;
        for (Projection prop : query.getProjectionList()) {
            if (prop.getProperty().getName().equals("__key__")) {
                hasKeyProjection = true;
                continue;
            }
            result.addPropertyName(prop.getProperty().getName());
        }
        if (hasKeyProjection && result.propertyNameSize() == 0) {
            result.setKeysOnly(true);
        }
        for (Projection prop : query.getDistinctOnList()) {
            result.addGroupByPropertyName(prop.getName());
        }
        if (query.hasFilter()) {
            this.populateV3Filters(resolver, (FilterOrBuilder)query.getFilter(), result);
        }
        block7: for (PropertyOrder order : query.getOrderList()) {
            DatastorePb.Query.Order orderV3 = result.addOrder();
            orderV3.setProperty(order.getProperty().getName());
            switch (order.getDirection()) {
                case DIRECTION_UNSPECIFIED: {
                    continue block7;
                }
                case ASCENDING: {
                    orderV3.setDirection(DatastorePb.Query.Order.Direction.ASCENDING);
                    continue block7;
                }
                case DESCENDING: {
                    orderV3.setDirection(DatastorePb.Query.Order.Direction.DESCENDING);
                    continue block7;
                }
            }
            throw DatastoreProtoConverter.unrecognizedEnumValue("direction", order.getDirection());
        }
        return result;
    }

    private void populateV3Filters(ProjectIdAppIdResolver resolver, FilterOrBuilder filter, DatastorePb.Query query) throws InvalidConversionException {
        switch (filter.getFilterTypeCase()) {
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propertyFilter = filter.getPropertyFilterOrBuilder();
                String propertyName = propertyFilter.getProperty().getName();
                PropertyFilter.Operator op = propertyFilter.getOp();
                ValueOrBuilder value = propertyFilter.getValueOrBuilder();
                if (op == PropertyFilter.Operator.HAS_ANCESTOR || op == PropertyFilter.Operator.HAS_PARENT) {
                    if (op == PropertyFilter.Operator.HAS_PARENT) {
                        InvalidConversionException.checkConversion(value.getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE || value.getValueTypeCase() == Value.ValueTypeCase.NULL_VALUE, "HAS_PARENT requires a key value or null", new Object[0]);
                    } else {
                        InvalidConversionException.checkConversion(value.getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE, "HAS_ANCESTOR requires a key value", new Object[0]);
                    }
                    InvalidConversionException.checkConversion(propertyName.equals("__key__"), "property must be __key__", new Object[0]);
                    InvalidConversionException.checkConversion(!query.isShallow() && !query.hasAncestor(), "duplicate ancestor or parent constraint", new Object[0]);
                    query.setShallow(op == PropertyFilter.Operator.HAS_PARENT);
                    if (value.getValueTypeCase() != Value.ValueTypeCase.KEY_VALUE) break;
                    query.setAncestor(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, value.getKeyValueOrBuilder()));
                    break;
                }
                DatastorePb.Query.Filter result = query.addFilter();
                result.setOp(op.getNumber());
                InvalidConversionException.checkConversion(value.getArrayValue().getValuesCount() == 0, "unsupported value type, %s, in property filter on '%s'", "list_value", propertyName);
                result.addProperty().setMultiple(false).setName(propertyName).setValue(EntityV3V1Converter.INSTANCE.toV3PropertyValue(resolver, (ValueOrBuilder)propertyFilter.getValue()));
                break;
            }
            case COMPOSITE_FILTER: {
                InvalidConversionException.checkConversion(filter.getCompositeFilter().getOp() == CompositeFilter.Operator.AND, "unsupported composite property operator", new Object[0]);
                for (Filter subFilter : filter.getCompositeFilterOrBuilder().getFiltersList()) {
                    this.populateV3Filters(resolver, (FilterOrBuilder)subFilter, query);
                }
                break;
            }
            case ST_CONTAINS_FILTER: {
                StContainsFilter stContainsFilter = filter.getStContainsFilter();
                DatastorePb.Query.Filter result = query.addFilter();
                result.addProperty().setMultiple(false).setName(stContainsFilter.getProperty().getName()).setValue(new OnestoreEntity.PropertyValue());
                result.setOp(DatastorePb.Query.Filter.Operator.CONTAINED_IN_REGION);
                result.setGeoRegion(this.toV3GeoRegion((GeoRegionOrBuilder)stContainsFilter.getContainedIn()));
                break;
            }
            case FILTERTYPE_NOT_SET: {
                query.addFilter();
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("filter_type", filter.getFilterTypeCase());
            }
        }
    }

    public DatastorePb.GeoRegion toV3GeoRegion(GeoRegionOrBuilder region) throws InvalidConversionException {
        DatastorePb.GeoRegion result = new DatastorePb.GeoRegion();
        switch (region.getShapeCase()) {
            case CIRCLE: {
                GeoRegion.Circle circle = region.getCircle();
                result.getMutableCircle().setRadiusMeters(circle.getRadiusMeters()).setCenter(this.toV3RegionPoint((LatLngOrBuilder)circle.getCenter()));
                break;
            }
            case RECTANGLE: {
                GeoRegion.Rectangle rectangle = region.getRectangle();
                result.getMutableRectangle().setSouthwest(this.toV3RegionPoint((LatLngOrBuilder)rectangle.getSouthwest())).setNortheast(this.toV3RegionPoint((LatLngOrBuilder)rectangle.getNortheast()));
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("shape", region.getShapeCase());
            }
        }
        return result;
    }

    public DatastorePb.RegionPoint toV3RegionPoint(LatLngOrBuilder latLng) {
        DatastorePb.RegionPoint result = new DatastorePb.RegionPoint();
        result.setLatitude(latLng.getLatitude());
        result.setLongitude(latLng.getLongitude());
        return result;
    }

    public DatastorePb.QueryResult toV3QueryResult(ProjectIdAppIdResolver resolver, QueryResultBatchOrBuilder batch) throws InvalidConversionException {
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        result.setMoreResults(batch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED);
        if (!batch.getSkippedCursor().isEmpty()) {
            result.setSkippedResultsCompiledCursor(this.toV3CompiledCursor(batch.getSkippedCursor()));
        }
        if (!batch.getEndCursor().isEmpty()) {
            result.setCompiledCursor(this.toV3CompiledCursor(batch.getEndCursor()));
        }
        if (batch.getEntityResultType() == EntityResult.ResultType.PROJECTION) {
            result.setIndexOnly(true);
        } else if (batch.getEntityResultType() == EntityResult.ResultType.KEY_ONLY) {
            result.setKeysOnly(true);
        }
        if (batch.getSkippedResults() != 0) {
            result.setSkippedResults(batch.getSkippedResults());
        }
        for (EntityResult entityResult : batch.getEntityResultsList()) {
            OnestoreEntity.EntityProto entity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)entityResult.getEntity());
            if (batch.getEntityResultType() != EntityResult.ResultType.FULL) {
                entity.setEntityGroup(OnestoreEntity.Path.IMMUTABLE_DEFAULT_INSTANCE);
            }
            result.addResult(entity);
            if (entityResult.getCursor().isEmpty()) continue;
            result.addResultCompiledCursor(this.toV3CompiledCursor(entityResult.getCursor()));
        }
        return result;
    }

    public QueryResultBatch.Builder toV1QueryResultBatch(ProjectIdAppIdResolver resolver, DatastorePb.QueryResult result) throws InvalidConversionException {
        QueryResultBatch.Builder batchV1 = this.toV1QueryResultBatchMetadata(result);
        this.addResultsToV1QueryResultBatch(resolver, batchV1, result);
        return batchV1;
    }

    private QueryResultBatch.Builder toV1QueryResultBatchMetadata(DatastorePb.QueryResult result) throws InvalidConversionException {
        QueryResultBatch.Builder builder = QueryResultBatch.newBuilder();
        builder.setMoreResults(result.isMoreResults() ? QueryResultBatch.MoreResultsType.NOT_FINISHED : QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT);
        if (result.hasCompiledCursor()) {
            builder.setEndCursor(this.toV1QueryCursor(result.getCompiledCursor()));
        }
        if (result.hasSkippedResultsCompiledCursor()) {
            builder.setSkippedCursor(this.toV1QueryCursor(result.getSkippedResultsCompiledCursor()));
        }
        builder.setEntityResultType(result.isKeysOnly() ? EntityResult.ResultType.KEY_ONLY : (result.isIndexOnly() ? EntityResult.ResultType.PROJECTION : EntityResult.ResultType.FULL));
        if (result.hasSkippedResults()) {
            builder.setSkippedResults(result.getSkippedResults());
        }
        int numOfResults = result.resultSize();
        int numOfCursors = result.resultCompiledCursorSize();
        InvalidConversionException.checkConversion(numOfCursors == 0 || numOfCursors == numOfResults, "query results contains inconsistent number of cursors", new Object[0]);
        return builder;
    }

    private void addResultsToV1QueryResultBatch(ProjectIdAppIdResolver resolver, QueryResultBatch.Builder batchV1, DatastorePb.QueryResult resultV3) throws InvalidConversionException {
        for (int i = 0; i < resultV3.resultSize(); ++i) {
            EntityResult.Builder entity = batchV1.addEntityResultsBuilder();
            entity.setEntity(EntityV3V1Converter.INSTANCE.toV1Entity(resolver, resultV3.getResult(i)));
            if (this.datastoreConfig.getAllowMutationBaseVersion() && resultV3.versionSize() > 0) {
                entity.setVersion(resultV3.getVersion(i));
            }
            if (resultV3.resultCompiledCursorSize() != resultV3.resultSize()) continue;
            entity.setCursor(this.toV1QueryCursor(resultV3.getResultCompiledCursor(i)));
        }
    }

    public EntityResult.Builder toV1EntityResult(ProjectIdAppIdResolver resolver, DatastorePb.GetResponse.Entity entityV3) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!entityV3.hasEntity() || !entityV3.hasKey(), "Get Response cannot have both an entity and key", new Object[0]);
        EntityResult.Builder builder = EntityResult.newBuilder();
        if (entityV3.hasEntity()) {
            builder.setEntity(EntityV3V1Converter.INSTANCE.toV1Entity(resolver, entityV3.getEntity()));
        } else if (entityV3.hasKey()) {
            builder.getEntityBuilder().setKey(EntityV3V1Converter.INSTANCE.toV1Key(resolver, entityV3.getKey()));
        }
        if (this.datastoreConfig.getAllowMutationBaseVersion() && entityV3.hasVersion()) {
            builder.setVersion(entityV3.getVersion());
        }
        return builder;
    }

    public DatastorePb.GetResponse.Entity toV3Entity(ProjectIdAppIdResolver resolver, EntityResultOrBuilder entityResult, boolean isMissing) throws InvalidConversionException {
        Entity entityV1 = entityResult.getEntity();
        DatastorePb.GetResponse.Entity entityV3 = new DatastorePb.GetResponse.Entity();
        if (isMissing) {
            entityV3.setKey(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)entityV1.getKey()));
        } else {
            entityV3.setEntity(EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)entityV1));
        }
        return entityV3;
    }

    public Query.Builder toV1Query(ProjectIdAppIdResolver resolver, DatastoreV4.QueryOrBuilder queryV4) throws InvalidConversionException {
        Query.Builder queryV1 = Query.newBuilder();
        for (DatastoreV4.PropertyExpressionOrBuilder projectionV4 : queryV4.getProjectionOrBuilderList()) {
            queryV1.addProjection(this.toV1Projection(projectionV4));
        }
        for (DatastoreV4.KindExpression kindV4 : queryV4.getKindList()) {
            queryV1.addKind(this.toV1KindExpression((DatastoreV4.KindExpressionOrBuilder)kindV4));
        }
        if (queryV4.hasFilter()) {
            queryV1.setFilter(this.toV1Filter(resolver, (DatastoreV4.FilterOrBuilder)queryV4.getFilter()));
        }
        for (DatastoreV4.PropertyOrder orderV4 : queryV4.getOrderList()) {
            queryV1.addOrder(this.toV1PropertyOrder((DatastoreV4.PropertyOrderOrBuilder)orderV4));
        }
        for (DatastoreV4.PropertyReference groupByV4 : queryV4.getGroupByList()) {
            queryV1.addDistinctOn(this.toV1PropertyReference((DatastoreV4.PropertyReferenceOrBuilder)groupByV4));
        }
        if (queryV4.hasStartCursor()) {
            queryV1.setStartCursor(this.toV1CursorBytes(queryV4.getStartCursor()));
        }
        if (queryV4.hasEndCursor()) {
            queryV1.setEndCursor(this.toV1CursorBytes(queryV4.getEndCursor()));
        }
        queryV1.setOffset(queryV4.getOffset());
        if (queryV4.hasLimit()) {
            queryV1.getLimitBuilder().setValue(queryV4.getLimit());
        }
        return queryV1;
    }

    private ByteString toV1CursorBytes(ByteString cursorBytesV3OrV4) {
        if (cursorBytesV3OrV4.isEmpty()) {
            return CompiledCursorUtil.V1_EMPTY_CURSOR;
        }
        return cursorBytesV3OrV4;
    }

    private Filter.Builder toV1Filter(ProjectIdAppIdResolver resolver, DatastoreV4.FilterOrBuilder filterV4) throws InvalidConversionException {
        Filter.Builder filterV1 = Filter.newBuilder();
        InvalidConversionException.checkConversion(filterV4.getAllFields().size() == 1, "a filter must have exactly one of its fields set", new Object[0]);
        if (filterV4.hasCompositeFilter()) {
            filterV1.setCompositeFilter(this.toV1CompositeFilter(resolver, (DatastoreV4.CompositeFilterOrBuilder)filterV4.getCompositeFilter()));
        }
        if (filterV4.hasPropertyFilter()) {
            filterV1.setPropertyFilter(this.toV1PropertyFilter(resolver, (DatastoreV4.PropertyFilterOrBuilder)filterV4.getPropertyFilter()));
        }
        return filterV1;
    }

    private CompositeFilter.Builder toV1CompositeFilter(ProjectIdAppIdResolver resolver, DatastoreV4.CompositeFilterOrBuilder filterV4) throws InvalidConversionException {
        CompositeFilter.Builder filterV1 = CompositeFilter.newBuilder();
        switch (filterV4.getOperator()) {
            case AND: {
                filterV1.setOp(CompositeFilter.Operator.AND);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("composite filter operator", filterV4.getOperator());
            }
        }
        for (DatastoreV4.Filter subFilterV4 : filterV4.getFilterList()) {
            filterV1.addFilters(this.toV1Filter(resolver, (DatastoreV4.FilterOrBuilder)subFilterV4));
        }
        return filterV1;
    }

    private PropertyFilter.Builder toV1PropertyFilter(ProjectIdAppIdResolver resolver, DatastoreV4.PropertyFilterOrBuilder filterV4) throws InvalidConversionException {
        PropertyFilter.Builder filterV1 = PropertyFilter.newBuilder();
        if (filterV4.hasProperty()) {
            filterV1.setProperty(this.toV1PropertyReference((DatastoreV4.PropertyReferenceOrBuilder)filterV4.getProperty()));
        }
        switch (filterV4.getOperator()) {
            case LESS_THAN: {
                filterV1.setOp(PropertyFilter.Operator.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filterV1.setOp(PropertyFilter.Operator.LESS_THAN_OR_EQUAL);
                break;
            }
            case EQUAL: {
                filterV1.setOp(PropertyFilter.Operator.EQUAL);
                break;
            }
            case GREATER_THAN: {
                filterV1.setOp(PropertyFilter.Operator.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filterV1.setOp(PropertyFilter.Operator.GREATER_THAN_OR_EQUAL);
                break;
            }
            case HAS_ANCESTOR: {
                filterV1.setOp(PropertyFilter.Operator.HAS_ANCESTOR);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("property filter operator", filterV4.getOperator());
            }
        }
        if (filterV4.hasValue()) {
            filterV1.setValue(this.entityV4Converter.toV1Value(resolver, (EntityV4.ValueOrBuilder)filterV4.getValue()));
        }
        return filterV1;
    }

    private Projection.Builder toV1Projection(DatastoreV4.PropertyExpressionOrBuilder propertyExpressionV4) {
        Projection.Builder projectionV1 = Projection.newBuilder();
        if (propertyExpressionV4.hasProperty()) {
            projectionV1.setProperty(this.toV1PropertyReference((DatastoreV4.PropertyReferenceOrBuilder)propertyExpressionV4.getProperty()));
        }
        return projectionV1;
    }

    private KindExpression.Builder toV1KindExpression(DatastoreV4.KindExpressionOrBuilder kindExpressionV4) {
        KindExpression.Builder kindExpressionV1 = KindExpression.newBuilder();
        kindExpressionV1.setNameBytes(kindExpressionV4.getNameBytes());
        return kindExpressionV1;
    }

    private PropertyOrder.Builder toV1PropertyOrder(DatastoreV4.PropertyOrderOrBuilder propertyOrderV4) throws InvalidConversionException {
        PropertyOrder.Builder propertyOrderV1 = PropertyOrder.newBuilder();
        if (propertyOrderV4.hasProperty()) {
            propertyOrderV1.setProperty(this.toV1PropertyReference((DatastoreV4.PropertyReferenceOrBuilder)propertyOrderV4.getProperty()));
        }
        switch (propertyOrderV4.getDirection()) {
            case ASCENDING: {
                propertyOrderV1.setDirection(PropertyOrder.Direction.ASCENDING);
                break;
            }
            case DESCENDING: {
                propertyOrderV1.setDirection(PropertyOrder.Direction.DESCENDING);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("direction", propertyOrderV4.getDirection());
            }
        }
        return propertyOrderV1;
    }

    PropertyReference.Builder toV1PropertyReference(DatastoreV4.PropertyReferenceOrBuilder propertyReferenceV4) {
        PropertyReference.Builder propertyReferenceV1 = PropertyReference.newBuilder();
        propertyReferenceV1.setNameBytes(propertyReferenceV4.getNameBytes());
        return propertyReferenceV1;
    }

    public GqlQuery.Builder toV1GqlQuery(ProjectIdAppIdResolver resolver, DatastoreV4.GqlQueryOrBuilder queryV4) throws InvalidConversionException {
        GqlQuery.Builder queryV1 = GqlQuery.newBuilder();
        if (queryV4.hasQueryString()) {
            queryV1.setQueryString(queryV4.getQueryString());
        }
        queryV1.setAllowLiterals(queryV4.getAllowLiteral());
        HashSet<String> namedGqlQueryArgSet = new HashSet<String>();
        for (DatastoreV4.GqlQueryArg nameArgV4 : queryV4.getNameArgList()) {
            InvalidConversionException.checkConversion(nameArgV4.hasName(), "A named GQL query parameter has no name.", new Object[0]);
            ByteString parameterNameByteString = nameArgV4.getNameBytes();
            this.entityV4Converter.validateStringAsUtf8ForConversion(parameterNameByteString, "GQL query parameter name");
            String parameterName = nameArgV4.getName();
            InvalidConversionException.checkConversion(namedGqlQueryArgSet.add(parameterName), "Duplicate GQL query parameter name \"%s\".", nameArgV4.getName());
            queryV1.putNamedBindings(parameterName, this.toV1GqlQueryParameter(resolver, (DatastoreV4.GqlQueryArgOrBuilder)nameArgV4).build());
        }
        for (DatastoreV4.GqlQueryArg numberArgV4 : queryV4.getNumberArgList()) {
            InvalidConversionException.checkConversion(!numberArgV4.hasName(), "A numbered GQL query parameter has a name.", new Object[0]);
            queryV1.addPositionalBindings(this.toV1GqlQueryParameter(resolver, (DatastoreV4.GqlQueryArgOrBuilder)numberArgV4));
        }
        return queryV1;
    }

    private GqlQueryParameter.Builder toV1GqlQueryParameter(ProjectIdAppIdResolver resolver, DatastoreV4.GqlQueryArgOrBuilder gqlQueryArgV4) throws InvalidConversionException {
        GqlQueryParameter.Builder queryParamV1 = GqlQueryParameter.newBuilder();
        InvalidConversionException.checkConversion(!gqlQueryArgV4.hasValue() || !gqlQueryArgV4.hasCursor(), "A GQL query parameter has both a value and a cursor.", new Object[0]);
        if (gqlQueryArgV4.hasValue()) {
            queryParamV1.setValue(this.entityV4Converter.toV1Value(resolver, (EntityV4.ValueOrBuilder)gqlQueryArgV4.getValue()));
        } else if (gqlQueryArgV4.hasCursor()) {
            queryParamV1.setCursor(gqlQueryArgV4.getCursor());
        }
        return queryParamV1;
    }

    Mutation.Builder toV1Mutation(ProjectIdAppIdResolver resolver, DatastoreV4.MutationOrBuilder mutationV4) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!mutationV4.hasKey() || !mutationV4.hasEntity(), "Mutation has both a key and an entity.", new Object[0]);
        Mutation.Builder mutationV1 = Mutation.newBuilder();
        switch (mutationV4.getOp()) {
            case INSERT: {
                InvalidConversionException.checkConversion(mutationV4.hasEntity(), "Mutation is missing entity.", new Object[0]);
                mutationV1.setInsert(this.getEntityConverter().toV1Entity(resolver, (EntityV4.EntityOrBuilder)mutationV4.getEntity()));
                break;
            }
            case UPDATE: {
                InvalidConversionException.checkConversion(mutationV4.hasEntity(), "Mutation is missing entity.", new Object[0]);
                mutationV1.setUpdate(this.getEntityConverter().toV1Entity(resolver, (EntityV4.EntityOrBuilder)mutationV4.getEntity()));
                break;
            }
            case UPSERT: {
                InvalidConversionException.checkConversion(mutationV4.hasEntity(), "Mutation is missing entity.", new Object[0]);
                mutationV1.setUpsert(this.getEntityConverter().toV1Entity(resolver, (EntityV4.EntityOrBuilder)mutationV4.getEntity()));
                break;
            }
            case DELETE: {
                InvalidConversionException.checkConversion(mutationV4.hasKey(), "Mutation is missing key.", new Object[0]);
                mutationV1.setDelete(this.getEntityConverter().toV1Key(resolver, (EntityV4.KeyOrBuilder)mutationV4.getKey()));
                break;
            }
            case UNKNOWN: {
                throw new InvalidConversionException("unknown mutation operation");
            }
            default: {
                String string = String.valueOf(mutationV4.getOp());
                throw new InvalidConversionException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized mutation op: ").append(string).toString());
            }
        }
        return mutationV1;
    }

    public QueryResultBatch.Builder toV1QueryResultBatch(ProjectIdAppIdResolver resolver, DatastoreV4.QueryResultBatchOrBuilder batchV4) throws InvalidConversionException {
        QueryResultBatch.Builder batchV1 = this.toV1QueryResultBatchMetadata(batchV4);
        this.addResultsToV1QueryResultBatch(resolver, batchV1, batchV4);
        return batchV1;
    }

    private QueryResultBatch.Builder toV1QueryResultBatchMetadata(DatastoreV4.QueryResultBatchOrBuilder batchV4) throws InvalidConversionException {
        QueryResultBatch.Builder batchV1 = QueryResultBatch.newBuilder();
        batchV1.setSkippedResults(batchV4.getSkippedResults());
        if (batchV4.hasSkippedCursor()) {
            batchV1.setSkippedCursor(this.toV1CursorBytes(batchV4.getSkippedCursor()));
        }
        switch (batchV4.getEntityResultType()) {
            case FULL: {
                batchV1.setEntityResultType(EntityResult.ResultType.FULL);
                break;
            }
            case PROJECTION: {
                batchV1.setEntityResultType(EntityResult.ResultType.PROJECTION);
                break;
            }
            case KEY_ONLY: {
                batchV1.setEntityResultType(EntityResult.ResultType.KEY_ONLY);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("entity result type", batchV4.getEntityResultType());
            }
        }
        if (batchV4.hasEndCursor()) {
            batchV1.setEndCursor(this.toV1CursorBytes(batchV4.getEndCursor()));
        }
        switch (batchV4.getMoreResults()) {
            case NOT_FINISHED: {
                batchV1.setMoreResults(QueryResultBatch.MoreResultsType.NOT_FINISHED);
                break;
            }
            case MORE_RESULTS_AFTER_LIMIT: {
                batchV1.setMoreResults(QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT);
                break;
            }
            case NO_MORE_RESULTS: {
                batchV1.setMoreResults(QueryResultBatch.MoreResultsType.NO_MORE_RESULTS);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("more results", batchV4.getMoreResults());
            }
        }
        return batchV1;
    }

    private void addResultsToV1QueryResultBatch(ProjectIdAppIdResolver resolver, QueryResultBatch.Builder batchV1, DatastoreV4.QueryResultBatchOrBuilder batchV4) throws InvalidConversionException {
        for (DatastoreV4.EntityResult resultV4 : batchV4.getEntityResultList()) {
            batchV1.addEntityResults(this.toV1EntityResult(resolver, (DatastoreV4.EntityResultOrBuilder)resultV4));
        }
    }

    private ByteString toV3OrV4CursorBytes(ByteString cursorBytesV1) {
        Preconditions.checkArgument((!cursorBytesV1.isEmpty() ? 1 : 0) != 0, (Object)"cannot convert empty v1 cursor bytes");
        if (cursorBytesV1.equals((Object)CompiledCursorUtil.V1_EMPTY_CURSOR)) {
            return ByteString.EMPTY;
        }
        return cursorBytesV1;
    }

    public EntityResult.Builder toV1EntityResult(ProjectIdAppIdResolver resolver, DatastoreV4.EntityResultOrBuilder resultV4) throws InvalidConversionException {
        EntityResult.Builder resultV1 = EntityResult.newBuilder();
        if (resultV4.hasEntity()) {
            resultV1.setEntity(this.entityV4Converter.toV1Entity(resolver, (EntityV4.EntityOrBuilder)resultV4.getEntity()));
        }
        if (resultV4.hasCursor()) {
            resultV1.setCursor(this.toV1CursorBytes(resultV4.getCursor()));
        }
        return resultV1;
    }

    public DatastoreV4.Query.Builder toV4Query(ProjectIdAppIdResolver resolver, QueryOrBuilder queryV1) throws InvalidConversionException {
        List groupByListV4;
        DatastoreV4.Query.Builder queryV4 = DatastoreV4.Query.newBuilder();
        for (Projection projectionV1 : queryV1.getProjectionList()) {
            queryV4.addProjection(this.toV4Projection((ProjectionOrBuilder)projectionV1));
        }
        for (KindExpression kindV1 : queryV1.getKindList()) {
            queryV4.addKind(this.toV4KindExpression((KindExpressionOrBuilder)kindV1));
        }
        if (queryV1.hasFilter()) {
            queryV4.setFilter(this.toV4Filter(resolver, (FilterOrBuilder)queryV1.getFilter()));
        }
        for (PropertyOrder orderV1 : queryV1.getOrderList()) {
            queryV4.addOrder(this.toV4PropertyOrder((PropertyOrderOrBuilder)orderV1));
        }
        for (PropertyReference groupByV1 : queryV1.getDistinctOnList()) {
            queryV4.addGroupBy(this.toV4PropertyReference((PropertyReferenceOrBuilder)groupByV1));
        }
        if (!queryV1.getStartCursor().isEmpty()) {
            queryV4.setStartCursor(this.toV3OrV4CursorBytes(queryV1.getStartCursor()));
        }
        if (!queryV1.getEndCursor().isEmpty()) {
            queryV4.setEndCursor(this.toV3OrV4CursorBytes(queryV1.getEndCursor()));
        }
        if (queryV1.getOffset() != 0) {
            queryV4.setOffset(queryV1.getOffset());
        }
        if (queryV1.hasLimit()) {
            queryV4.setLimit(queryV1.getLimit().getValue());
        }
        if (!(groupByListV4 = queryV4.getGroupByList()).isEmpty()) {
            HashSet groupByPropertyNames = Sets.newHashSet();
            for (DatastoreV4.PropertyReference groupBy : groupByListV4) {
                groupByPropertyNames.add(groupBy.getName());
            }
            for (DatastoreV4.PropertyExpression.Builder projection : queryV4.getProjectionBuilderList()) {
                if (groupByPropertyNames.contains(projection.getProperty().getName())) continue;
                projection.setAggregationFunction(DatastoreV4.PropertyExpression.AggregationFunction.FIRST);
            }
        }
        return queryV4;
    }

    private DatastoreV4.Filter.Builder toV4Filter(ProjectIdAppIdResolver resolver, FilterOrBuilder filterV1) throws InvalidConversionException {
        DatastoreV4.Filter.Builder filterV4 = DatastoreV4.Filter.newBuilder();
        switch (filterV1.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                filterV4.setCompositeFilter(this.toV4CompositeFilter(resolver, (CompositeFilterOrBuilder)filterV1.getCompositeFilter()));
                break;
            }
            case PROPERTY_FILTER: {
                filterV4.setPropertyFilter(this.toV4PropertyFilter(resolver, (PropertyFilterOrBuilder)filterV1.getPropertyFilter()));
                break;
            }
            case FILTERTYPE_NOT_SET: {
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("filter_type", filterV1.getFilterTypeCase());
            }
        }
        return filterV4;
    }

    private DatastoreV4.CompositeFilter.Builder toV4CompositeFilter(ProjectIdAppIdResolver resolver, CompositeFilterOrBuilder filterV1) throws InvalidConversionException {
        DatastoreV4.CompositeFilter.Builder filterV4 = DatastoreV4.CompositeFilter.newBuilder();
        switch (filterV1.getOp()) {
            case AND: {
                filterV4.setOperator(DatastoreV4.CompositeFilter.Operator.AND);
                break;
            }
            case OPERATOR_UNSPECIFIED: {
                InvalidConversionException.checkConversion(false, "a composite filter must specify an operator", new Object[0]);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("composite filter operator", filterV1.getOp());
            }
        }
        for (Filter subFilterV1 : filterV1.getFiltersList()) {
            filterV4.addFilter(this.toV4Filter(resolver, (FilterOrBuilder)subFilterV1));
        }
        return filterV4;
    }

    private DatastoreV4.PropertyFilter.Builder toV4PropertyFilter(ProjectIdAppIdResolver resolver, PropertyFilterOrBuilder filterV1) throws InvalidConversionException {
        DatastoreV4.PropertyFilter.Builder filterV4 = DatastoreV4.PropertyFilter.newBuilder();
        if (filterV1.hasProperty()) {
            filterV4.setProperty(this.toV4PropertyReference((PropertyReferenceOrBuilder)filterV1.getProperty()));
        }
        switch (filterV1.getOp()) {
            case LESS_THAN: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.LESS_THAN_OR_EQUAL);
                break;
            }
            case EQUAL: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.EQUAL);
                break;
            }
            case GREATER_THAN: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL);
                break;
            }
            case HAS_ANCESTOR: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR);
                break;
            }
            case HAS_PARENT: {
                InvalidConversionException.checkConversion(false, "unsupported operator", filterV1.getOp());
                break;
            }
            case OPERATOR_UNSPECIFIED: {
                InvalidConversionException.checkConversion(false, "a property filter must specify an operator", new Object[0]);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("property filter operator", filterV1.getOp());
            }
        }
        if (filterV1.hasValue()) {
            filterV4.setValue(this.entityV4Converter.toV4Value(resolver, filterV1.getValue()));
        }
        return filterV4;
    }

    private DatastoreV4.PropertyExpression.Builder toV4Projection(ProjectionOrBuilder projectionV1) {
        DatastoreV4.PropertyExpression.Builder propertyExpressionV4 = DatastoreV4.PropertyExpression.newBuilder();
        if (projectionV1.hasProperty()) {
            propertyExpressionV4.setProperty(this.toV4PropertyReference((PropertyReferenceOrBuilder)projectionV1.getProperty()));
        }
        return propertyExpressionV4;
    }

    private DatastoreV4.KindExpression.Builder toV4KindExpression(KindExpressionOrBuilder kindExpressionV1) {
        DatastoreV4.KindExpression.Builder kindExpressionV4 = DatastoreV4.KindExpression.newBuilder();
        kindExpressionV4.setName(kindExpressionV1.getName());
        return kindExpressionV4;
    }

    private DatastoreV4.PropertyOrder.Builder toV4PropertyOrder(PropertyOrderOrBuilder propertyOrderV1) throws InvalidConversionException {
        DatastoreV4.PropertyOrder.Builder propertyOrderV4 = DatastoreV4.PropertyOrder.newBuilder();
        if (propertyOrderV1.hasProperty()) {
            propertyOrderV4.setProperty(this.toV4PropertyReference((PropertyReferenceOrBuilder)propertyOrderV1.getProperty()));
        }
        switch (propertyOrderV1.getDirection()) {
            case ASCENDING: {
                propertyOrderV4.setDirection(DatastoreV4.PropertyOrder.Direction.ASCENDING);
                break;
            }
            case DESCENDING: {
                propertyOrderV4.setDirection(DatastoreV4.PropertyOrder.Direction.DESCENDING);
                break;
            }
            case DIRECTION_UNSPECIFIED: {
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("direction", propertyOrderV1.getDirection());
            }
        }
        return propertyOrderV4;
    }

    private DatastoreV4.PropertyReference.Builder toV4PropertyReference(PropertyReferenceOrBuilder propertyReferenceV1) {
        DatastoreV4.PropertyReference.Builder propertyReferenceV4 = DatastoreV4.PropertyReference.newBuilder();
        propertyReferenceV4.setName(propertyReferenceV1.getName());
        return propertyReferenceV4;
    }

    public DatastoreV4.GqlQuery.Builder toV4GqlQuery(ProjectIdAppIdResolver resolver, GqlQueryOrBuilder queryV1) throws InvalidConversionException {
        DatastoreV4.GqlQuery.Builder queryV4 = DatastoreV4.GqlQuery.newBuilder();
        queryV4.setQueryString(queryV1.getQueryString());
        queryV4.setAllowLiteral(queryV1.getAllowLiterals());
        for (Map.Entry positionalArg : queryV1.getNamedBindings().entrySet()) {
            queryV4.addNameArg(this.toV4GqlQueryParameter(resolver, (String)positionalArg.getKey(), (GqlQueryParameterOrBuilder)positionalArg.getValue()));
        }
        for (GqlQueryParameter numberArgV1 : queryV1.getPositionalBindingsList()) {
            queryV4.addNumberArg(this.toV4GqlQueryParameter(resolver, null, (GqlQueryParameterOrBuilder)numberArgV1));
        }
        return queryV4;
    }

    private DatastoreV4.GqlQueryArg.Builder toV4GqlQueryParameter(ProjectIdAppIdResolver resolver, String name, GqlQueryParameterOrBuilder gqlQueryParameterV1) throws InvalidConversionException {
        DatastoreV4.GqlQueryArg.Builder queryArgV4 = DatastoreV4.GqlQueryArg.newBuilder();
        if (name != null) {
            queryArgV4.setName(name);
        }
        switch (gqlQueryParameterV1.getParameterTypeCase()) {
            case VALUE: {
                queryArgV4.setValue(this.entityV4Converter.toV4Value(resolver, gqlQueryParameterV1.getValue()));
                break;
            }
            case CURSOR: {
                queryArgV4.setCursor(gqlQueryParameterV1.getCursor());
                break;
            }
            case PARAMETERTYPE_NOT_SET: {
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("GQL query parameter_type", gqlQueryParameterV1.getParameterTypeCase());
            }
        }
        return queryArgV4;
    }

    public DatastoreV4.QueryResultBatch.Builder toV4QueryResultBatch(ProjectIdAppIdResolver resolver, QueryResultBatchOrBuilder batchV1) throws InvalidConversionException {
        DatastoreV4.QueryResultBatch.Builder batchV4 = DatastoreV4.QueryResultBatch.newBuilder();
        if (batchV1.getSkippedResults() != 0) {
            batchV4.setSkippedResults(batchV1.getSkippedResults());
        }
        if (!batchV1.getSkippedCursor().isEmpty()) {
            batchV4.setSkippedCursor(batchV1.getSkippedCursor());
        }
        switch (batchV1.getEntityResultType()) {
            case FULL: {
                batchV4.setEntityResultType(DatastoreV4.EntityResult.ResultType.FULL);
                break;
            }
            case PROJECTION: {
                batchV4.setEntityResultType(DatastoreV4.EntityResult.ResultType.PROJECTION);
                break;
            }
            case KEY_ONLY: {
                batchV4.setEntityResultType(DatastoreV4.EntityResult.ResultType.KEY_ONLY);
                break;
            }
            case RESULT_TYPE_UNSPECIFIED: {
                InvalidConversionException.checkConversion(false, "a query result batch must specify an entity result type", new Object[0]);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("entity result type", batchV1.getEntityResultType());
            }
        }
        for (EntityResult resultV1 : batchV1.getEntityResultsList()) {
            batchV4.addEntityResult(this.toV4EntityResult(resolver, (EntityResultOrBuilder)resultV1));
        }
        if (!batchV1.getEndCursor().isEmpty()) {
            batchV4.setEndCursor(this.toV3OrV4CursorBytes(batchV1.getEndCursor()));
        }
        switch (batchV1.getMoreResults()) {
            case NOT_FINISHED: {
                batchV4.setMoreResults(DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED);
                break;
            }
            case MORE_RESULTS_AFTER_LIMIT: 
            case MORE_RESULTS_AFTER_CURSOR: 
            case NO_MORE_RESULTS: {
                batchV4.setMoreResults(DatastoreV4.QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT);
                break;
            }
            case MORE_RESULTS_TYPE_UNSPECIFIED: {
                InvalidConversionException.checkConversion(false, "a query result batch must specify a more results type", new Object[0]);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("more results", batchV1.getMoreResults());
            }
        }
        return batchV4;
    }

    public DatastoreV4.EntityResult.Builder toV4EntityResult(ProjectIdAppIdResolver resolver, EntityResultOrBuilder resultV1) throws InvalidConversionException {
        DatastoreV4.EntityResult.Builder resultV4 = DatastoreV4.EntityResult.newBuilder();
        if (resultV1.hasEntity()) {
            resultV4.setEntity(this.entityV4Converter.toV4Entity(resolver, (EntityOrBuilder)resultV1.getEntity()));
        }
        if (!resultV1.getCursor().isEmpty()) {
            resultV4.setCursor(resultV1.getCursor());
        }
        return resultV4;
    }

    public DatastorePb.Query toV3Query(EntityV4.PartitionIdOrBuilder partitionIdV4, DatastoreV4.QueryOrBuilder queryV4) throws InvalidConversionException {
        DatastorePb.Query queryV3 = this.toV3Query(ProjectIdAppIdResolver.IDENTITY, (PartitionIdOrBuilder)this.entityV4Converter.toV1PartitionId(ProjectIdAppIdResolver.IDENTITY, partitionIdV4), (QueryOrBuilder)this.toV1Query(ProjectIdAppIdResolver.IDENTITY, queryV4).build());
        this.entityV4Converter.getObfuscator().obfuscate(queryV3);
        return queryV3;
    }

    public DatastoreV4.QueryResultBatch.Builder toV4QueryResultBatch(DatastorePb.QueryResult resultV3) throws InvalidConversionException {
        DatastoreV4.QueryResultBatch.Builder queryResultV4 = this.toV4QueryResultBatch(ProjectIdAppIdResolver.IDENTITY, (QueryResultBatchOrBuilder)this.toV1QueryResultBatchMetadata(resultV3));
        for (int i = 0; i < resultV3.resultSize(); ++i) {
            DatastoreV4.EntityResult.Builder resultV4 = queryResultV4.addEntityResultBuilder();
            resultV4.setEntity(this.entityV4Converter.toV4Entity(resultV3.getResult(i)));
            if (resultV3.resultCompiledCursorSize() != resultV3.resultSize()) continue;
            resultV4.setCursor(this.toV4QueryCursor(resultV3.getResultCompiledCursor(i)));
        }
        int numOfResults = resultV3.resultSize();
        int numOfVersions = resultV3.versionSize();
        InvalidConversionException.checkConversion(numOfVersions == 0 || numOfVersions == numOfResults, "query results contain inconsistent number of versions", new Object[0]);
        for (int i = 0; i < numOfVersions; ++i) {
            queryResultV4.getEntityResultBuilder(i).setVersion(resultV3.getVersion(i));
        }
        return queryResultV4;
    }

    public DatastoreV4.EntityResult.Builder toV4EntityResult(DatastorePb.GetResponse.Entity entityV3) throws InvalidConversionException {
        DatastoreV4.EntityResult.Builder resultV4 = this.toV4EntityResult(ProjectIdAppIdResolver.IDENTITY, (EntityResultOrBuilder)this.toV1EntityResult(ProjectIdAppIdResolver.IDENTITY, entityV3));
        if (this.entityV4Converter.getPreservePropertyOrderInV4() && entityV3.hasEntity()) {
            resultV4.setEntity(this.entityV4Converter.toV4Entity(entityV3.getEntity()));
        }
        if (entityV3.hasVersion()) {
            resultV4.setVersion(entityV3.getVersion());
        }
        return resultV4;
    }

    public DatastoreV4.Query.Builder toV4Query(DatastoreV4.GqlQueryOrBuilder gqlQuery, EntityV4.PartitionIdOrBuilder partitionId) throws InvalidConversionException {
        try {
            ProjectIdAppIdResolver resolver = ProjectIdAppIdResolver.IDENTITY;
            GqlQuery.Builder gqlQueryV1 = this.toV1GqlQuery(resolver, gqlQuery);
            PartitionId partitionIdV1 = this.entityV4Converter.toV1PartitionId(resolver, partitionId).build();
            Query queryV1 = new GqlParser((GqlQueryOrBuilder)gqlQueryV1, partitionIdV1, GqlParser.Version.V4).selector().build();
            DatastoreV4.Query.Builder queryV4 = this.toV4Query(resolver, (QueryOrBuilder)queryV1);
            return queryV4;
        }
        catch (ParseException | TokenMgrError exception) {
            throw new InvalidConversionException(exception.getMessage(), exception);
        }
    }

    public DatastoreV4.Query.Builder toV4Query(DatastorePb.Query queryV3) throws InvalidConversionException {
        return this.toV4Query(ProjectIdAppIdResolver.IDENTITY, (QueryOrBuilder)this.toV1Query(ProjectIdAppIdResolver.IDENTITY, queryV3).build());
    }

    public DatastorePb.QueryResult toV3QueryResult(DatastoreV4.QueryResultBatchOrBuilder batchV4) throws InvalidConversionException {
        DatastorePb.QueryResult queryResultV3 = this.toV3QueryResult(ProjectIdAppIdResolver.IDENTITY, (QueryResultBatchOrBuilder)this.toV1QueryResultBatchMetadata(batchV4));
        for (DatastoreV4.EntityResult resultV4 : batchV4.getEntityResultList()) {
            OnestoreEntity.EntityProto entityV3 = this.entityV4Converter.toV3Entity((EntityV4.EntityOrBuilder)resultV4.getEntity());
            if (batchV4.getEntityResultType() != DatastoreV4.EntityResult.ResultType.FULL) {
                entityV3.setEntityGroup(OnestoreEntity.Path.IMMUTABLE_DEFAULT_INSTANCE);
            }
            queryResultV3.addResult(entityV3);
            if (resultV4.hasVersion()) {
                queryResultV3.addVersion(resultV4.getVersion());
            }
            if (!resultV4.hasCursor()) continue;
            queryResultV3.addResultCompiledCursor(this.v4CursorBytesToV3CompiledCursor(resultV4.getCursor()));
        }
        int numOfVersions = queryResultV3.versionSize();
        InvalidConversionException.checkConversion(numOfVersions == 0 || numOfVersions == batchV4.getEntityResultCount(), "query results contain inconsistent number of versions", new Object[0]);
        return queryResultV3;
    }

    public DatastorePb.GetResponse.Entity toV3Entity(DatastoreV4.EntityResultOrBuilder entityResult, boolean isMissing) throws InvalidConversionException {
        DatastorePb.GetResponse.Entity entityV3 = this.toV3Entity(ProjectIdAppIdResolver.IDENTITY, (EntityResultOrBuilder)this.toV1EntityResult(ProjectIdAppIdResolver.IDENTITY, entityResult), isMissing);
        if (this.entityV4Converter.getPreservePropertyOrderInV4() && !isMissing) {
            entityV3.setEntity(this.entityV4Converter.toV3Entity((EntityV4.EntityOrBuilder)entityResult.getEntity()));
        }
        if (entityResult.hasVersion()) {
            entityV3.setVersion(entityResult.getVersion());
        }
        return entityV3;
    }

    public List<DatastoreV4.Mutation.Builder> toV4MutationList(DatastoreV4.Mutation.Operation op, List<EntityV4.Entity> entities) {
        ArrayList<DatastoreV4.Mutation.Builder> mutations = new ArrayList<DatastoreV4.Mutation.Builder>(entities.size());
        for (EntityV4.Entity entity : entities) {
            DatastoreV4.Mutation.Builder mutation = DatastoreV4.Mutation.newBuilder();
            mutation.setOp(op);
            mutation.setEntity(entity);
            mutations.add(mutation);
        }
        return mutations;
    }

    public List<DatastoreV4.Mutation.Builder> toV4DeleteMutationList(List<EntityV4.Key> keys) {
        ArrayList<DatastoreV4.Mutation.Builder> mutations = new ArrayList<DatastoreV4.Mutation.Builder>(keys.size());
        for (EntityV4.Key key : keys) {
            DatastoreV4.Mutation.Builder mutation = DatastoreV4.Mutation.newBuilder();
            mutation.setOp(DatastoreV4.Mutation.Operation.DELETE);
            mutation.setKey(key);
            mutations.add(mutation);
        }
        return mutations;
    }

    public static InvalidConversionException unrecognizedEnumValue(String field, Enum<?> enumValue) {
        String string = String.valueOf(enumValue);
        return new InvalidConversionException(new StringBuilder(15 + String.valueOf(field).length() + String.valueOf(string).length()).append("Unrecognized ").append(field).append(": ").append(string).toString());
    }

    private ByteString toV4QueryCursor(DatastorePb.CompiledCursor cursorV3) {
        return cursorV3.toByteString();
    }

    private DatastorePb.CompiledCursor v4CursorBytesToV3CompiledCursor(ByteString queryCursorBytesV4) throws InvalidConversionException {
        try {
            return (DatastorePb.CompiledCursor)DatastorePb.CompiledCursor.parser().parseFrom(queryCursorBytesV4);
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }
}

