/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.shared.DatastoreV4Validator;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;

public class DatastoreV4ServiceValidator {
    private final DatastoreV4Validator validatorV4;

    public DatastoreV4ServiceValidator(DatastoreV4Validator validatorV4) {
        this.validatorV4 = validatorV4;
    }

    public void validateCommitRequest(DatastoreV4.CommitRequestOrBuilder req) throws ValidationException {
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        this.validatorV4.validateCommitMode(req.getMode(), req.hasTransaction());
        ValidationException.validateAssertion(req.getMutationList().isEmpty() || !req.hasDeprecatedMutation(), "CommitRequest has both a mutation list and a deprecated mutation", new Object[0]);
        if (req.getMutationCount() > 0) {
            this.validatorV4.validateMutations(false, req.getMutationList());
        }
        if (req.hasDeprecatedMutation()) {
            this.validatorV4.validateDeprecatedMutation(false, req.getDeprecatedMutationOrBuilder());
        }
    }

    public void validateLookupRequest(DatastoreV4.LookupRequestOrBuilder req) throws ValidationException {
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        this.validatorV4.validateReadOptions(req.getReadOptionsOrBuilder().hasReadConsistency(), req.getReadOptionsOrBuilder().hasTransaction());
        this.validatorV4.getEntityValidator().validateKeys(ValidationConstraint.LOOKUP, req.getKeyOrBuilderList());
    }

    public void validateRunQueryRequest(DatastoreV4.RunQueryRequestOrBuilder req) throws ValidationException {
        Preconditions.checkArgument((!req.hasGqlQuery() ? 1 : 0) != 0, (Object)"RunQueryRequest not normalized");
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        this.validatorV4.validateReadOptions(req.getReadOptionsOrBuilder().hasReadConsistency(), req.getReadOptionsOrBuilder().hasTransaction());
        this.validatorV4.getEntityValidator().validatePartitionId(ValidationConstraint.LOOKUP, req.getPartitionIdOrBuilder());
        ValidationException.validateAssertion(req.hasQuery(), "one of fields Query.query and Query.gql_query must be set", new Object[0]);
        this.validatorV4.validateQuery(req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG, (DatastoreV4.QueryOrBuilder)req.getQuery());
    }

    public void validateAllocateIdsRequest(DatastoreV4.AllocateIdsRequestOrBuilder req) throws ValidationException {
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        ValidationException.validateAssertion(req.getAllocateCount() == 0 || req.getReserveCount() == 0, "cannot reserve and allocate ids in the same request", new Object[0]);
        this.validatorV4.getEntityValidator().validateKeys(ValidationConstraint.ALLOCATE_ID, req.getAllocateOrBuilderList());
        this.validatorV4.getEntityValidator().validateKeys(ValidationConstraint.RESERVE_ID, req.getReserveOrBuilderList());
    }

    public DatastoreV4Validator getDatastoreV4Validator() {
        return this.validatorV4;
    }
}

