/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.api.blobstore.dev.BlobUploadSession;
import com.google.appengine.api.blobstore.dev.BlobUploadSessionStorage;
import com.google.appengine.api.blobstore.dev.MemoryBlobStorage;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.repackaged.com.google.common.io.Closeables;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.GenerationDirectory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LocalBlobstoreService
extends AbstractLocalRpcService {
    private static final String PORT_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.port";
    private static final Logger logger = Logger.getLogger(LocalBlobstoreService.class.getName());
    public static final String BACKING_STORE_PROPERTY = "blobstore.backing_store";
    public static final String NO_STORAGE_PROPERTY = "blobstore.no_storage";
    public static final String PACKAGE = "blobstore";
    public static final String GOOGLE_STORAGE_KEY_PREFIX = "encoded_gs_key:";
    static final String UPLOAD_URL_PREFIX = "/_ah/upload/";
    private BlobStorage blobStorage;
    private BlobUploadSessionStorage uploadSessionStorage;
    private String serverHostName;

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.uploadSessionStorage = new BlobUploadSessionStorage();
        String noStorage = properties.get(NO_STORAGE_PROPERTY);
        if (noStorage != null && Boolean.valueOf(noStorage).booleanValue()) {
            BlobStorageFactory.setMemoryBlobStorage();
        } else {
            File file;
            String filePath = properties.get(BACKING_STORE_PROPERTY);
            if (filePath != null) {
                String string = String.valueOf(filePath);
                logger.log(Level.INFO, string.length() != 0 ? "Creating blobstore backing store at ".concat(string) : new String("Creating blobstore backing store at "));
                file = new File(filePath);
            } else {
                file = GenerationDirectory.getGenerationDirectory((File)context.getLocalServerEnvironment().getAppDir());
            }
            file.mkdirs();
            if (!file.canWrite()) {
                logger.log(Level.WARNING, "Default blobstore file location is not writable, creating a temporary directory. State will not be persisted between restarts.");
                file = Files.createTempDir();
            }
            BlobStorageFactory.setFileBlobStorage(file);
        }
        this.blobStorage = BlobStorageFactory.getBlobStorage();
        this.serverHostName = context.getLocalServerEnvironment().getHostName();
    }

    public void start() {
    }

    public void stop() {
        if (this.blobStorage instanceof MemoryBlobStorage) {
            ((MemoryBlobStorage)this.blobStorage).deleteAllBlobs();
        }
    }

    public BlobstoreServicePb.CreateUploadURLResponse createUploadURL(LocalRpcService.Status status, BlobstoreServicePb.CreateUploadURLRequest request) {
        BlobUploadSession session = new BlobUploadSession(request.getSuccessPath());
        if (request.hasMaxUploadSizePerBlobBytes()) {
            session.setMaxUploadSizeBytesPerBlob(request.getMaxUploadSizePerBlobBytes());
        }
        if (request.hasMaxUploadSizeBytes()) {
            session.setMaxUploadSizeBytes(request.getMaxUploadSizeBytes());
        }
        if (request.hasGsBucketName()) {
            session.setGoogleStorageBucketName(request.getGsBucketName());
        }
        String sessionId = this.uploadSessionStorage.createSession(session);
        BlobstoreServicePb.CreateUploadURLResponse response = new BlobstoreServicePb.CreateUploadURLResponse();
        String url = String.format("http://%s:%s%s%s", this.serverHostName, this.getCurrentInstancePort(), UPLOAD_URL_PREFIX, sessionId);
        response.setUrl(url);
        return response;
    }

    public ApiBasePb.VoidProto deleteBlob(LocalRpcService.Status status, final BlobstoreServicePb.DeleteBlobRequest request) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (String blobKeyString : request.blobKeys()) {
                    BlobKey blobKey = new BlobKey(blobKeyString);
                    if (!LocalBlobstoreService.this.blobStorage.hasBlob(blobKey)) continue;
                    try {
                        LocalBlobstoreService.this.blobStorage.deleteBlob(blobKey);
                    }
                    catch (IOException ex) {
                        String string = String.valueOf(blobKey);
                        logger.log(Level.WARNING, new StringBuilder(23 + String.valueOf(string).length()).append("Could not delete blob: ").append(string).toString(), ex);
                        throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.INTERNAL_ERROR.getValue(), ex.toString());
                    }
                }
                return null;
            }
        });
        return new ApiBasePb.VoidProto();
    }

    public BlobstoreServicePb.FetchDataResponse fetchData(LocalRpcService.Status status, final BlobstoreServicePb.FetchDataRequest request) {
        if (request.getStartIndex() < 0L) {
            throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.DATA_INDEX_OUT_OF_RANGE.getValue(), "Start index must be >= 0.");
        }
        if (request.getEndIndex() < request.getStartIndex()) {
            throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.DATA_INDEX_OUT_OF_RANGE.getValue(), "End index must be >= startIndex.");
        }
        long fetchSize = request.getEndIndex() - request.getStartIndex() + 1L;
        if (fetchSize > 1015808L) {
            throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.BLOB_FETCH_SIZE_TOO_LARGE.getValue(), "Blob fetch size too large.");
        }
        BlobstoreServicePb.FetchDataResponse response = new BlobstoreServicePb.FetchDataResponse();
        BlobInfoStorage blobInfoStorage = new BlobInfoStorage();
        final BlobKey blobKey = new BlobKey(request.getBlobKey());
        BlobInfo blobInfo = blobInfoStorage.loadBlobInfo(blobKey);
        if (blobInfo == null) {
            blobInfo = blobInfoStorage.loadGsFileInfo(blobKey);
        }
        if (blobInfo == null) {
            throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.BLOB_NOT_FOUND.getValue(), "Blob not found.");
        }
        long endIndex = request.getEndIndex() > blobInfo.getSize() - 1L ? blobInfo.getSize() - 1L : request.getEndIndex();
        if (request.getStartIndex() > endIndex) {
            response.setData("");
        } else {
            final byte[] data = new byte[(int)(endIndex - request.getStartIndex() + 1L)];
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        boolean swallowDueToThrow = true;
                        InputStream stream = LocalBlobstoreService.this.blobStorage.fetchBlob(blobKey);
                        try {
                            ByteStreams.skipFully((InputStream)stream, (long)request.getStartIndex());
                            ByteStreams.readFully((InputStream)stream, (byte[])data);
                            swallowDueToThrow = false;
                        }
                        finally {
                            Closeables.close((Closeable)stream, (boolean)swallowDueToThrow);
                        }
                    }
                    catch (IOException ex) {
                        String string = String.valueOf(blobKey);
                        logger.log(Level.WARNING, new StringBuilder(22 + String.valueOf(string).length()).append("Could not fetch data: ").append(string).toString(), ex);
                        throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.INTERNAL_ERROR.getValue(), ex.toString());
                    }
                    return null;
                }
            });
            response.setDataAsBytes(data);
        }
        return response;
    }

    public BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse createEncodedGoogleStorageKey(LocalRpcService.Status status, BlobstoreServicePb.CreateEncodedGoogleStorageKeyRequest request) {
        String encoded = BaseEncoding.base64Url().omitPadding().encode(request.getFilename().getBytes());
        BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse response = new BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse();
        String string = String.valueOf(GOOGLE_STORAGE_KEY_PREFIX);
        String string2 = String.valueOf(encoded);
        response.setBlobKey(string2.length() != 0 ? string.concat(string2) : new String(string));
        return response;
    }

    private String getCurrentInstancePort() {
        Integer port = (Integer)ApiProxy.getCurrentEnvironment().getAttributes().get(PORT_ID_ENV_ATTRIBUTE);
        return port.toString();
    }
}

