/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.HashMultiset;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.collect.TreeMultimap;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Edge;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Loop;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;

@GwtCompatible(serializable=false)
public strictfp final class S2PolygonBuilder {
    private final Options options;
    private final Map<S2Point, Multiset<S2Point>> edges = Maps.newHashMap();
    private final List<S2Point> startingVertices = Lists.newArrayList();

    public S2PolygonBuilder() {
        this(Options.DIRECTED_XOR);
    }

    public S2PolygonBuilder(Options options) {
        this.options = options;
    }

    public Options options() {
        return this.options;
    }

    public boolean addEdge(S2Point v0, S2Point v1) {
        if (v0.equalsPoint(v1)) {
            return false;
        }
        if (this.options.getXorEdges() && this.hasEdge(v1, v0)) {
            this.eraseEdge(v1, v0);
            return false;
        }
        if (this.edges.get(v0) == null) {
            this.edges.put(v0, (Multiset<S2Point>)HashMultiset.create());
            this.startingVertices.add(v0);
        }
        this.edges.get(v0).add((Object)v1);
        if (this.options.getUndirectedEdges()) {
            if (this.edges.get(v1) == null) {
                this.edges.put(v1, (Multiset<S2Point>)HashMultiset.create());
                this.startingVertices.add(v1);
            }
            this.edges.get(v1).add((Object)v0);
        }
        return true;
    }

    public void addLoop(S2Loop loop) {
        if (!loop.isEmptyOrFull()) {
            int sign = loop.sign();
            for (int i = loop.numVertices(); i > 0; --i) {
                this.addEdge(loop.vertex(i), loop.vertex(i + sign));
            }
        }
    }

    public void addPolygon(S2Polygon polygon) {
        for (int i = 0; i < polygon.numLoops(); ++i) {
            this.addLoop(polygon.loop(i));
        }
    }

    private S2Point snapPointToLevel(S2Point p, int level) {
        return S2CellId.fromPoint(p).parent(level).toPoint();
    }

    private S2Loop snapLoopToLevel(S2Loop loop, int level) {
        ArrayList snappedVertices = Lists.newArrayListWithCapacity((int)loop.numVertices());
        for (int i = 0; i < loop.numVertices(); ++i) {
            snappedVertices.add(this.snapPointToLevel(loop.vertex(i), level));
        }
        return new S2Loop(snappedVertices);
    }

    public boolean assembleLoops(List<S2Loop> loops, @Nullable List<S2Edge> unusedEdges) {
        if (this.options.getMergeDistance().radians() > 0.0) {
            PointIndex index = new PointIndex(this, this.options.getMergeDistance().radians(), this.options.getEdgeSpliceFraction());
            Map<S2Point, S2Point> mergeMap = this.buildMergeMap(index);
            this.moveVertices(mergeMap);
            if (this.options.getEdgeSpliceFraction() > 0.0) {
                this.spliceEdges(index);
            }
        }
        int snapLevel = this.options.getSnapLevel();
        if (unusedEdges != null) {
            unusedEdges.clear();
        }
        int i = 0;
        while (i < this.startingVertices.size()) {
            S2Point v0 = this.startingVertices.get(i);
            Multiset<S2Point> candidates = this.edges.get(v0);
            if (candidates == null) {
                ++i;
                continue;
            }
            S2Point v1 = (S2Point)candidates.iterator().next();
            S2Loop loop = this.assembleLoop(v0, v1, unusedEdges);
            if (loop == null) continue;
            this.eraseLoop(loop, loop.numVertices());
            if (snapLevel >= 0) {
                loop = this.snapLoopToLevel(loop, snapLevel);
            }
            loops.add(loop);
        }
        return unusedEdges == null || unusedEdges.isEmpty();
    }

    public boolean assemblePolygon(S2Polygon polygon, @Nullable List<S2Edge> unusedEdges) {
        ArrayList loops = Lists.newArrayList();
        boolean success = this.assembleLoops(loops, unusedEdges);
        if (this.options.getValidate() && !S2Polygon.isValid(loops) && unusedEdges != null) {
            for (S2Loop loop : loops) {
                this.rejectLoop(loop, loop.numVertices(), unusedEdges);
            }
            return false;
        }
        if (this.options.getUndirectedEdges()) {
            polygon.init(loops);
        } else {
            polygon.initOriented(loops);
        }
        return success;
    }

    public S2Polygon assemblePolygon() {
        S2Polygon polygon = new S2Polygon();
        this.assemblePolygon(polygon, null);
        return polygon;
    }

    private void eraseEdge(S2Point v0, S2Point v1) {
        Multiset<S2Point> vset = this.edges.get(v0);
        vset.remove((Object)v1);
        if (vset.isEmpty()) {
            this.edges.remove(v0);
        }
        if (this.options.getUndirectedEdges()) {
            vset = this.edges.get(v1);
            vset.remove((Object)v0);
            if (vset.isEmpty()) {
                this.edges.remove(v1);
            }
        }
    }

    private void eraseLoop(List<S2Point> v, int n) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            this.eraseEdge(v.get(i), v.get(j));
            i = j++;
        }
    }

    private void eraseLoop(S2Loop v, int n) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            this.eraseEdge(v.vertex(i), v.vertex(j));
            i = j++;
        }
    }

    private S2Loop assembleLoop(S2Point v0, S2Point v1, @Nullable List<S2Edge> unusedEdges) {
        List<S2Point> path = Lists.newArrayList();
        HashMap index = Maps.newHashMap();
        path.add(v0);
        path.add(v1);
        index.put(v1, 1);
        while (path.size() >= 2) {
            v0 = (S2Point)path.get(path.size() - 2);
            v1 = (S2Point)path.get(path.size() - 1);
            S2Point v2 = null;
            boolean v2Found = false;
            Multiset<S2Point> vset = this.edges.get(v1);
            if (vset != null) {
                for (S2Point v : vset) {
                    if (v.equalsPoint(v0)) continue;
                    if (!v2Found || S2.orderedCCW(v0, v2, v, v1)) {
                        v2 = v;
                    }
                    v2Found = true;
                }
            }
            if (!v2Found) {
                if (unusedEdges != null) {
                    unusedEdges.add(new S2Edge(v0, v1));
                }
                this.eraseEdge(v0, v1);
                index.remove(v1);
                path.remove(path.size() - 1);
                continue;
            }
            if (index.get(v2) == null) {
                index.put(v2, path.size());
                path.add(v2);
                continue;
            }
            if ((Integer)index.get(v2) == 1 && ((S2Point)path.get(0)).equalsPoint((S2Point)path.get(path.size() - 1))) {
                path.remove(path.size() - 1);
            } else {
                path = path.subList((Integer)index.get(v2), path.size());
            }
            S2Loop loop = new S2Loop(path);
            if (this.options.getValidate() && !loop.isValid()) {
                if (unusedEdges != null) {
                    this.rejectLoop(path, path.size(), unusedEdges);
                }
                this.eraseLoop(path, path.size());
                return null;
            }
            if (this.options.getUndirectedEdges() && !loop.isNormalized()) {
                return this.assembleLoop(path.get(1), path.get(0), unusedEdges);
            }
            return loop;
        }
        return null;
    }

    private void rejectLoop(S2Loop v, int n, List<S2Edge> unusedEdges) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            unusedEdges.add(new S2Edge(v.vertex(i), v.vertex(j)));
            i = j++;
        }
    }

    private void rejectLoop(List<S2Point> v, int n, List<S2Edge> unusedEdges) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            unusedEdges.add(new S2Edge(v.get(i), v.get(j)));
            i = j++;
        }
    }

    private void moveVertices(Map<S2Point, S2Point> mergeMap) {
        if (mergeMap.isEmpty()) {
            return;
        }
        ArrayList edgesCopy = Lists.newArrayList();
        for (Map.Entry<S2Point, Multiset<S2Point>> edge : this.edges.entrySet()) {
            S2Point v0 = edge.getKey();
            Multiset<S2Point> vset = edge.getValue();
            for (S2Point v1 : vset) {
                if (mergeMap.get(v0) == null && mergeMap.get(v1) == null || this.options.getUndirectedEdges() && !v0.lessThan(v1)) continue;
                edgesCopy.add(new S2Edge(v0, v1));
            }
        }
        for (int i = 0; i < edgesCopy.size(); ++i) {
            S2Point new1;
            S2Point v0 = ((S2Edge)edgesCopy.get(i)).getStart();
            S2Point v1 = ((S2Edge)edgesCopy.get(i)).getEnd();
            this.eraseEdge(v0, v1);
            S2Point new0 = mergeMap.get(v0);
            if (new0 != null) {
                v0 = new0;
            }
            if ((new1 = mergeMap.get(v1)) != null) {
                v1 = new1;
            }
            this.addEdge(v0, v1);
        }
    }

    private Map<S2Point, S2Point> buildMergeMap(PointIndex index) {
        HashSet vertices = Sets.newHashSet();
        for (Map.Entry<S2Point, Multiset<S2Point>> edge : this.edges.entrySet()) {
            vertices.add(edge.getKey());
            for (S2Point v : edge.getValue().elementSet()) {
                vertices.add(v);
            }
        }
        for (S2Point p : vertices) {
            index.add(p);
        }
        HashMap mergeMap = Maps.newHashMap();
        Stack<S2Point> frontier = new Stack<S2Point>();
        ArrayList mergeable = Lists.newArrayList();
        for (S2Point vstart : vertices) {
            if (mergeMap.containsKey(vstart)) continue;
            frontier.add(vstart);
            while (!frontier.isEmpty()) {
                index.queryCap((S2Point)frontier.pop(), mergeable);
                for (S2Point vnear : mergeable) {
                    if (vstart.equalsPoint(vnear)) continue;
                    index.remove(vnear);
                    frontier.push(vnear);
                    mergeMap.put(vnear, vstart);
                }
            }
        }
        return mergeMap;
    }

    public boolean hasEdge(S2Point v0, S2Point v1) {
        Multiset<S2Point> vset = this.edges.get(v0);
        return vset == null ? false : vset.count((Object)v1) > 0;
    }

    private void spliceEdges(PointIndex index) {
        ArrayList pendingEdges = Lists.newArrayList();
        for (Map.Entry<S2Point, Multiset<S2Point>> edge : this.edges.entrySet()) {
            S2Point v0 = edge.getKey();
            for (S2Point v1 : edge.getValue().elementSet()) {
                if (this.options.getUndirectedEdges() && v0.compareTo(v1) >= 0) continue;
                pendingEdges.add(new S2Edge(v0, v1));
            }
        }
        while (!pendingEdges.isEmpty()) {
            S2Point vmid;
            S2Edge lastPair = (S2Edge)pendingEdges.remove(pendingEdges.size() - 1);
            S2Point v0 = lastPair.getStart();
            S2Point v1 = lastPair.getEnd();
            if (this.options.getXorEdges() && !this.hasEdge(v0, v1) || (vmid = index.findNearbyPoint(v0, v1)) == null) continue;
            this.eraseEdge(v0, v1);
            if (this.addEdge(v0, vmid)) {
                pendingEdges.add(new S2Edge(v0, vmid));
            }
            if (!this.addEdge(vmid, v1)) continue;
            pendingEdges.add(new S2Edge(vmid, v1));
        }
    }

    private strictfp class PointIndex {
        private final double vertexRadius;
        private final double edgeFraction;
        private final int level;
        private final TreeMultimap<S2CellId, S2Point> delegate = TreeMultimap.create();
        private final List<S2CellId> ids = Lists.newArrayList();

        public PointIndex(S2PolygonBuilder s2PolygonBuilder, double searchRadius, double edgeFraction) {
            this.vertexRadius = searchRadius;
            this.edgeFraction = edgeFraction;
            this.level = Math.min(S2Projections.PROJ.minWidth.getMaxLevel(2.0 * searchRadius), 29);
        }

        public void add(S2Point p) {
            S2CellId.fromPoint(p).getVertexNeighbors(this.level, this.ids);
            for (S2CellId id : this.ids) {
                this.delegate.put((Object)id, (Object)p);
            }
            this.ids.clear();
        }

        public void remove(S2Point p) {
            S2CellId.fromPoint(p).getVertexNeighbors(this.level, this.ids);
            for (S2CellId id : this.ids) {
                this.delegate.remove((Object)id, (Object)p);
            }
            this.ids.clear();
        }

        public void queryCap(S2Point axis, List<S2Point> output) {
            output.clear();
            S2CellId id = S2CellId.fromPoint(axis).parent(this.level);
            for (Map.Entry entry : this.delegate.asMap().tailMap(id).entrySet()) {
                if (entry.getKey().id() != id.id()) break;
                for (S2Point p : (Collection)entry.getValue()) {
                    if (!(axis.angle(p) < this.vertexRadius)) continue;
                    output.add(p);
                }
            }
        }

        public S2Point findNearbyPoint(S2Point v0, S2Point v1) {
            double length = v0.angle(v1);
            S2Point normal = S2.robustCrossProd(v0, v1);
            int queryLevel = Math.min(this.level, S2Projections.PROJ.minWidth.getMaxLevel(length));
            S2CellId.fromPoint(v0).getVertexNeighbors(queryLevel, this.ids);
            S2CellId.fromPoint(v1).getVertexNeighbors(queryLevel, this.ids);
            Collections.sort(this.ids);
            double bestDistance = 2.0 * this.vertexRadius;
            S2Point nearby = null;
            int i = this.ids.size();
            while (--i >= 0) {
                if (i > 0 && this.ids.get(i - 1).id() == this.ids.get(i).id()) continue;
                S2CellId maxId = this.ids.get(i).rangeMax();
                for (Map.Entry cellPoints : this.delegate.asMap().tailMap(this.ids.get(i).rangeMin()).entrySet()) {
                    if (cellPoints.getKey().compareTo(maxId) > 0) break;
                    for (S2Point p : (Collection)cellPoints.getValue()) {
                        double dist;
                        if (p.equalsPoint(v0) || p.equalsPoint(v1) || !((dist = S2EdgeUtil.getDistance(p, v0, v1, normal).radians()) < bestDistance)) continue;
                        bestDistance = dist;
                        nearby = p;
                    }
                }
            }
            this.ids.clear();
            if (bestDistance < this.edgeFraction * this.vertexRadius) {
                return nearby;
            }
            return null;
        }
    }

    public strictfp static final class Options {
        public static final Options DIRECTED_XOR = Options.builder().setUndirectedEdges(false).setXorEdges(true).build();
        public static final Options UNDIRECTED_XOR = Options.builder().setUndirectedEdges(true).setXorEdges(true).build();
        public static final Options UNDIRECTED_UNION = Options.builder().setUndirectedEdges(true).setXorEdges(false).build();
        public static final Options DIRECTED_UNION = Options.builder().setUndirectedEdges(false).setXorEdges(false).build();
        private final boolean undirectedEdges;
        private final boolean xorEdges;
        private final boolean validate;
        private final S1Angle mergeDistance;
        private final boolean snapToCellCenters;
        private final double edgeSpliceFraction;

        private Options(Builder builder) {
            this.undirectedEdges = builder.undirectedEdges;
            this.xorEdges = builder.xorEdges;
            this.validate = builder.validate;
            this.mergeDistance = builder.mergeDistance;
            this.snapToCellCenters = builder.snapToCellCenters;
            this.edgeSpliceFraction = builder.edgeSpliceFraction;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder().setUndirectedEdges(this.undirectedEdges).setXorEdges(this.xorEdges).setValidate(this.validate).setMergeDistance(this.mergeDistance).setSnapToCellCenters(this.snapToCellCenters).setEdgeSpliceFraction(this.edgeSpliceFraction);
        }

        public boolean getUndirectedEdges() {
            return this.undirectedEdges;
        }

        public boolean getXorEdges() {
            return this.xorEdges;
        }

        public boolean getValidate() {
            return this.validate;
        }

        public S1Angle getMergeDistance() {
            return this.mergeDistance;
        }

        public boolean getSnapToCellCenters() {
            return this.snapToCellCenters;
        }

        public double getEdgeSpliceFraction() {
            return this.edgeSpliceFraction;
        }

        public S1Angle getRobustnessRadius() {
            return S1Angle.radians(this.mergeDistance.radians() * this.edgeSpliceFraction / 2.0);
        }

        public int getSnapLevel() {
            if (!this.getSnapToCellCenters()) {
                return -1;
            }
            S1Angle tolerance = this.getRobustnessRadius();
            int level = S2Projections.PROJ.maxDiag.getMinLevel(tolerance.radians() * 2.0);
            if (level == 30 && tolerance.radians() < S2Projections.PROJ.maxDiag.getValue(level) / 2.0) {
                return -1;
            }
            return level;
        }

        public strictfp static class Builder {
            private boolean undirectedEdges = false;
            private boolean xorEdges = true;
            private boolean validate = false;
            private S1Angle mergeDistance = S1Angle.radians(0.0);
            private boolean snapToCellCenters = false;
            private double edgeSpliceFraction = 0.866;

            public Options build() {
                return new Options(this);
            }

            public Builder setUndirectedEdges(boolean undirectedEdges) {
                this.undirectedEdges = undirectedEdges;
                return this;
            }

            public Builder setXorEdges(boolean xorEdges) {
                this.xorEdges = xorEdges;
                return this;
            }

            public Builder setValidate(boolean validate) {
                this.validate = validate;
                return this;
            }

            public Builder setMergeDistance(S1Angle mergeDistance) {
                this.mergeDistance = mergeDistance;
                return this;
            }

            public Builder setSnapToCellCenters(boolean snapToCellCenters) {
                this.snapToCellCenters = snapToCellCenters;
                return this;
            }

            public Builder setEdgeSpliceFraction(double edgeSpliceFraction) {
                Preconditions.checkState((edgeSpliceFraction < Math.sqrt(3.0) / 2.0 ? 1 : 0) != 0, (Object)"Splice fraction must be at least sqrt(3)/2 to ensure termination of edge splicing algorithm.");
                this.edgeSpliceFraction = edgeSpliceFraction;
                return this;
            }

            public Builder setRobustnessRadius(S1Angle robustnessRadius) {
                this.mergeDistance = S1Angle.radians(2.0 * robustnessRadius.radians() / this.edgeSpliceFraction);
                return this;
            }
        }
    }
}

