/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.datastore.rep.AutoValue_Lookup;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public abstract class Lookup {
    public abstract ImmutableList<OnestoreEntity.Reference> keys();

    public abstract PropertyMask propertyMask();

    @Nullable
    public abstract Long transaction();

    public abstract boolean isStrong();

    public abstract boolean allowDefer();

    public abstract boolean allowFailover();

    public static Builder builder() {
        return new AutoValue_Lookup.Builder().isStrong(true).allowDefer(false).allowFailover(false).propertyMask(PropertyMask.FULL);
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder keys(Iterable<OnestoreEntity.Reference> var1);

        public abstract Builder propertyMask(PropertyMask var1);

        public abstract Builder transaction(@Nullable Long var1);

        public abstract Builder isStrong(boolean var1);

        public abstract Builder allowDefer(boolean var1);

        public abstract Builder allowFailover(boolean var1);

        abstract Lookup autoBuild();

        public Lookup build() {
            Lookup lookup = this.autoBuild();
            Preconditions.checkState((lookup.transaction() == null || lookup.isStrong() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)lookup.propertyMask().hasKey());
            return lookup;
        }
    }
}

