/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.datastore.rep.AutoValue_Mutation;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.ReferencePaths;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public abstract class Mutation {
    private boolean autoIdInserted = false;

    public abstract boolean allocateKey();

    public abstract Op op();

    @Nullable
    public abstract OnestoreEntity.EntityProto entity();

    @Nullable
    public abstract PropertyMask propertyMask();

    public abstract OnestoreEntity.Reference key();

    public abstract long baseVersion();

    public static Mutation of(Op op, OnestoreEntity.EntityProto entity) {
        return Mutation.of(op, entity, -1L);
    }

    public static Mutation of(Op op, OnestoreEntity.EntityProto entity, long baseVersion) {
        return Mutation.of(op, entity, PropertyMask.FULL, baseVersion);
    }

    public static Mutation of(Op op, OnestoreEntity.EntityProto entity, PropertyMask mask, long baseVersion) {
        Preconditions.checkArgument((!op.isDelete() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)mask.hasKey());
        OnestoreEntity.Reference key = entity.getKey();
        boolean allocateKey = ReferencePaths.hasIncompleteLastElement(key);
        if (allocateKey) {
            Preconditions.checkArgument((op != Op.UPDATE ? 1 : 0) != 0);
            op = Op.INSERT;
        }
        return new AutoValue_Mutation(allocateKey, op, entity, mask, key, baseVersion);
    }

    public static Mutation of(Op op, OnestoreEntity.Reference key) {
        return Mutation.of(op, key, -1L);
    }

    public static Mutation of(Op op, OnestoreEntity.Reference key, long baseVersion) {
        Preconditions.checkArgument((boolean)op.isDelete());
        return new AutoValue_Mutation(false, op, null, null, key, baseVersion);
    }

    public void setAutoIdInserted() {
        this.autoIdInserted = true;
    }

    public boolean getAutoIdInserted() {
        return this.autoIdInserted;
    }

    public boolean isDelete() {
        return this.op().isDelete();
    }

    public boolean hasConflictDetection() {
        return this.baseVersion() != -1L;
    }

    public boolean conflictsWith(long serverVersion) {
        return this.baseVersion() != -1L && this.baseVersion() != serverVersion;
    }

    public static enum Op {
        INSERT(false),
        UPDATE(false),
        UPSERT(false),
        DELETE(true),
        DELETE_MUST_EXIST(true),
        DELETE_MUST_NOT_EXIST(true);

        private final boolean isDelete;

        private Op(boolean isDelete) {
            this.isDelete = isDelete;
        }

        public boolean isDelete() {
            return this.isDelete;
        }
    }
}

