/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedBytes;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;

public class PropertyPath {
    private static final Joiner DELIMITER_JOINER = Joiner.on((String)".");
    private static final Comparator<byte[]> UTF8_BYTE_COMPARATOR = UnsignedBytes.lexicographicalComparator();
    public static final PropertyPath KEY = PropertyPath.createFromByteArray(SpecialPropertyDescriptor.KEY.getPropertyNameAsByteArray());
    public static final PropertyPath SCATTER = PropertyPath.createFromByteArray(SpecialPropertyDescriptor.SCATTER.getPropertyNameAsByteArray());
    public static final PropertyPath SPLITS = PropertyPath.createFromByteArray(SpecialPropertyDescriptor.SPLITS.getPropertyNameAsByteArray());
    public static final PropertyPath UNAPPLIED_LOG_TIMESTAMP_US = PropertyPath.createFromByteArray(SpecialPropertyDescriptor.UNAPPLIED_LOG_TIMESTAMP_US.getPropertyNameAsByteArray());
    private final PropertyName propertyName;

    public static PropertyPath create(ImmutableList<String> names) {
        ByteString byteString = ByteString.copyFromUtf8((String)DELIMITER_JOINER.join(names));
        return new PropertyPath(byteString.toByteArray());
    }

    public static PropertyPath createFromByteArray(byte[] byteArray) {
        return new PropertyPath(byteArray);
    }

    private PropertyPath(byte[] byteArray) {
        String stringLossy = ProtocolSupport.toStringUtf8((byte[])byteArray);
        this.propertyName = PropertyName.fromByteArrayAndUtf8(byteArray, stringLossy);
    }

    public byte[] asByteArrayWithDelimiterAmbiguity() {
        return this.propertyName.bytes();
    }

    public PropertyName asPropertyNameWithDelimiterAmbiguity() {
        return this.propertyName;
    }

    @Nullable
    public SpecialPropertyDescriptor special() {
        return this.propertyName.special();
    }

    public String asStringLossy() {
        return this.propertyName.string();
    }

    public boolean equalsByteArrayWithDelimiterAmbiguity(byte[] otherByteArray) {
        return Arrays.equals(this.propertyName.bytes(), otherByteArray);
    }

    public int compareTo(PropertyPath other) {
        return UTF8_BYTE_COMPARATOR.compare(this.propertyName.bytes(), other.propertyName.bytes());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PropertyPath)) {
            return false;
        }
        PropertyPath other = (PropertyPath)otherObject;
        return this.propertyName.equals(other.propertyName);
    }

    public int hashCode() {
        return this.propertyName.hashCode();
    }

    public String toString() {
        return this.asStringLossy();
    }
}

