/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptionsOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.TransactionOptions;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.CloudV1DatabaseRefValidator;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;

public class CloudDatastoreV1ServiceValidator {
    private final CloudDatastoreV1Validator validatorV1;
    private static final ValidationConstraint LOOKUP_CONSTRAINT = ValidationConstraint.LOOKUP.withContext(ValidationConstraint.Context.PRENORMALIZATION);
    private static final ValidationConstraint ALLOCATE_ID_CONSTRAINT = ValidationConstraint.ALLOCATE_ID.withContext(ValidationConstraint.Context.PRENORMALIZATION);
    private static final ValidationConstraint QUERY_CONSTRAINT = ValidationConstraint.QUERY.withContext(ValidationConstraint.Context.PRENORMALIZATION);

    public CloudDatastoreV1ServiceValidator(CloudDatastoreV1Validator validatorV1) {
        this.validatorV1 = validatorV1;
    }

    public CloudDatastoreV1Validator getDatastoreV1Validator() {
        return this.validatorV1;
    }

    public void validateCommitRequest(boolean isTrusted, CommitRequestOrBuilder req) throws ValidationException {
        block7: {
            block6: {
                DatabaseRef internalDatabase = CloudV1DatabaseRefValidator.INSTANCE.createAndValidateRequiredDatabaseRef(req.getProjectId(), req.getDatabaseId());
                if (req.getTransactionSelectorCase() == CommitRequest.TransactionSelectorCase.TRANSACTION) {
                    this.validatorV1.validateTransactionBytes(req.getTransaction());
                }
                if (req.getTransactionSelectorCase() == CommitRequest.TransactionSelectorCase.SINGLE_USE_TRANSACTION) {
                    ValidationException.validateAssertion(this.validatorV1.getEntityValidator().getConfig().getAllowSingleUseTransaction(), "setting single_use_transaction is not allowed.", new Object[0]);
                    ValidationException.validateAssertion(req.getSingleUseTransaction().getModeCase() != TransactionOptions.ModeCase.READ_ONLY, "single_use_transaction in a commit request must be READ_WRITE.", new Object[0]);
                }
                boolean hasTransaction = req.getTransactionSelectorCase() != CommitRequest.TransactionSelectorCase.TRANSACTIONSELECTOR_NOT_SET;
                this.validatorV1.validateCommitMode(req.getMode(), hasTransaction);
                for (Mutation mutation : req.getMutationsList()) {
                    ValidationConstraint constraint = CloudDatastoreV1Validator.constraintForMutation(mutation).withContext(isTrusted, ValidationConstraint.Context.PRENORMALIZATION);
                    this.validatorV1.validateMutation(constraint, internalDatabase, mutation);
                }
                if (hasTransaction) break block6;
                HashSet completeKeysSeen = Sets.newHashSetWithExpectedSize((int)req.getMutationsCount());
                for (Mutation mutation : req.getMutationsList()) {
                    Key key = CloudDatastoreV1ServiceValidator.getKey((MutationOrBuilder)mutation);
                    if (Paths.hasIncompleteLastElement((KeyOrBuilder)key)) continue;
                    ValidationException.validateAssertion(completeKeysSeen.add(key), "A non-transactional commit may not contain multiple mutations affecting the same entity.", new Object[0]);
                }
                break block7;
            }
            if (!this.validatorV1.getEntityValidator().getConfig().getAllowMutationBaseVersion()) break block7;
            HashMap<Key, Long> seenBaseVersions = new HashMap<Key, Long>();
            for (Mutation mutation : req.getMutationsList()) {
                Long baseVersion;
                Key key = CloudDatastoreV1ServiceValidator.getKey((MutationOrBuilder)mutation);
                Long l = baseVersion = mutation.getConflictDetectionStrategyCase() == Mutation.ConflictDetectionStrategyCase.BASE_VERSION ? Long.valueOf(mutation.getBaseVersion()) : null;
                if (seenBaseVersions.containsKey(key)) {
                    ValidationException.validateAssertion(Objects.equals(seenBaseVersions.get(key), baseVersion), "Mutations for the same entity must have the same base version.", new Object[0]);
                    continue;
                }
                seenBaseVersions.put(key, baseVersion);
            }
        }
    }

    private static Key getKey(MutationOrBuilder mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return mutation.getInsert().getKey();
            }
            case UPDATE: {
                return mutation.getUpdate().getKey();
            }
            case UPSERT: {
                return mutation.getUpsert().getKey();
            }
            case DELETE: {
                return mutation.getDelete();
            }
        }
        throw new ValidationException("Mutation is missing operation.");
    }

    public void validateLookupRequest(LookupRequestOrBuilder req) throws ValidationException {
        DatabaseRef internalDatabase = CloudV1DatabaseRefValidator.INSTANCE.createAndValidateRequiredDatabaseRef(req.getProjectId(), req.getDatabaseId());
        this.validatorV1.getEntityValidator().validateKeys(LOOKUP_CONSTRAINT, internalDatabase, req.getKeysList());
        this.validatorV1.validateReadOptions(req.getReadOptions());
        if (req.hasPropertyMask()) {
            this.validatorV1.validatePropertyMask(LOOKUP_CONSTRAINT.withContext(ValidationConstraint.Context.IN_PROPERTY_MASK), req.getPropertyMask());
        }
    }

    public void validateAllocateIdsRequest(AllocateIdsRequestOrBuilder req) throws ValidationException {
        DatabaseRef internalDatabase = CloudV1DatabaseRefValidator.INSTANCE.createAndValidateRequiredDatabaseRef(req.getProjectId(), req.getDatabaseId());
        this.validatorV1.getEntityValidator().validateKeys(ALLOCATE_ID_CONSTRAINT, internalDatabase, req.getKeysList());
    }

    public void validateRunQueryRequest(RunQueryRequestOrBuilder req) throws ValidationException {
        DatabaseRef internalDatabase = CloudV1DatabaseRefValidator.INSTANCE.createAndValidateRequiredDatabaseRef(req.getProjectId(), req.getDatabaseId());
        PartitionId reqPartitionId = req.getPartitionId();
        CloudV1DatabaseRefValidator.INSTANCE.validateDatabaseRefMatches(internalDatabase, reqPartitionId.getProjectId(), reqPartitionId.getDatabaseId());
        Preconditions.checkArgument((req.getQueryTypeCase() != RunQueryRequest.QueryTypeCase.GQL_QUERY ? 1 : 0) != 0, (Object)"RunQueryRequest not normalized");
        this.validatorV1.getEntityValidator().validatePartitionId(QUERY_CONSTRAINT, req.getPartitionIdOrBuilder());
        this.validatorV1.validateReadOptions(req.getReadOptions());
        if (req.hasPropertyMask()) {
            this.validatorV1.validatePropertyMask(QUERY_CONSTRAINT.withContext(ValidationConstraint.Context.IN_PROPERTY_MASK), req.getPropertyMask());
        }
        ValidationException.validateAssertion(req.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.QUERY, "one of fields Query.query and Query.gql_query must be set", new Object[0]);
        this.validatorV1.validateQuery(QUERY_CONSTRAINT, this.isStrongRead(req.getReadOptionsOrBuilder()), (QueryOrBuilder)req.getQuery());
    }

    public void validateRollbackRequest(RollbackRequestOrBuilder req) throws ValidationException {
        CloudV1DatabaseRefValidator.INSTANCE.createAndValidateRequiredDatabaseRef(req.getProjectId(), req.getDatabaseId());
        ValidationException.validateAssertion(!req.getTransaction().isEmpty(), "transaction required", new Object[0]);
    }

    public void validateBeginTransactionRequest(BeginTransactionRequestOrBuilder req) throws ValidationException {
        CloudV1DatabaseRefValidator.INSTANCE.createAndValidateRequiredDatabaseRef(req.getProjectId(), req.getDatabaseId());
    }

    private boolean isStrongRead(ReadOptionsOrBuilder opts) throws ValidationException {
        switch (opts.getConsistencyTypeCase()) {
            case CONSISTENCYTYPE_NOT_SET: {
                return false;
            }
            case NEW_TRANSACTION: 
            case TRANSACTION: {
                return true;
            }
            case READ_CONSISTENCY: {
                return opts.getReadConsistency() == ReadOptions.ReadConsistency.STRONG;
            }
        }
        String string = String.valueOf(opts.getConsistencyTypeCase());
        throw new ValidationException(new StringBuilder(25 + String.valueOf(string).length()).append("Unknown consistency type ").append(string).toString());
    }
}

