/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponseOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationResult;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.TransactionOptions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.BaseDatastoreServiceProtoConverter;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.LocalTransactionConverter;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class DatastoreServiceProtoConverter
extends BaseDatastoreServiceProtoConverter {
    public DatastoreServiceProtoConverter(DatastoreProtoConverter datastoreConverter, LocalTransactionConverter transactionConverter) {
        super(datastoreConverter, transactionConverter);
    }

    public DatastoreProtoConverter getDatastoreProtoConverter() {
        return this.datastoreConverter;
    }

    private DatastorePb.Cursor toV3Cursor(ByteString queryHandleV4) throws InvalidConversionException {
        try {
            return (DatastorePb.Cursor)DatastorePb.Cursor.parser().parseFrom(queryHandleV4);
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }

    private ByteString toV4QueryHandle(DatastorePb.Cursor cursorV3) throws InvalidConversionException {
        return cursorV3.toByteString();
    }

    public BeginTransactionResponse.Builder toV1BeginTransactionResponse(DatastorePb.Transaction txnV3) throws InvalidConversionException {
        BeginTransactionResponse.Builder resV1 = BeginTransactionResponse.newBuilder();
        resV1.setTransaction(this.transactionConverter.toTransactionBytes(txnV3));
        return resV1;
    }

    public DatastorePb.Transaction toV3Transaction(RollbackRequestOrBuilder reqV1, String appId, String databaseId) throws InvalidConversionException {
        return this.transactionConverter.toV3Transaction(reqV1.getTransaction(), appId, databaseId);
    }

    public DatastorePb.BeginTransactionRequest.TransactionMode toV3TransactionMode(TransactionOptions opts) {
        switch (opts.getModeCase()) {
            case READ_ONLY: {
                return DatastorePb.BeginTransactionRequest.TransactionMode.READ_ONLY;
            }
            case READ_WRITE: {
                return DatastorePb.BeginTransactionRequest.TransactionMode.READ_WRITE;
            }
            case MODE_NOT_SET: {
                return DatastorePb.BeginTransactionRequest.TransactionMode.UNKNOWN;
            }
        }
        String string = String.valueOf(opts.getModeCase());
        throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Unkown transaction mode ").append(string).toString());
    }

    public DatastorePb.GetRequest toV3GetRequest(DatastoreV4.LookupRequestOrBuilder req, String appId, String databaseId) throws InvalidConversionException {
        DatastorePb.GetRequest get = new DatastorePb.GetRequest();
        get.setAllowDeferred(true);
        if (req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL) {
            get.setFailoverMs(-1L);
        } else if (req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG) {
            get.setStrong(true);
        }
        if (req.getReadOptionsOrBuilder().hasTransaction()) {
            get.setTransaction(this.transactionConverter.toV3Transaction(req.getReadOptionsOrBuilder().getTransaction(), appId, databaseId));
        }
        for (EntityV4.Key key : req.getKeyList()) {
            get.addKey(this.datastoreConverter.getEntityConverter().toV3Reference((EntityV4.KeyOrBuilder)key));
        }
        return get;
    }

    public DatastoreV4.LookupResponse.Builder toV4LookupResponse(DatastorePb.GetResponse res) throws InvalidConversionException {
        DatastoreV4.LookupResponse.Builder builder = DatastoreV4.LookupResponse.newBuilder();
        EntityV4Converter entityV4Converter = this.datastoreConverter.getEntityConverter();
        for (OnestoreEntity.Reference key : res.deferreds()) {
            builder.addDeferred(entityV4Converter.toV4Key(key));
        }
        for (DatastorePb.GetResponse.Entity entity : res.entitys()) {
            DatastoreV4.EntityResult.Builder entityResult = this.datastoreConverter.toV4EntityResult(entity);
            if (entity.hasEntity()) {
                builder.addFound(entityResult);
            }
            if (!entity.hasKey()) continue;
            builder.addMissing(entityResult);
        }
        return builder;
    }

    public DatastorePb.Query toV3Query(DatastoreV4.RunQueryRequestOrBuilder request, String appId, String databaseId) throws InvalidConversionException {
        DatastoreV4.ReadOptionsOrBuilder options;
        DatastorePb.Query result = this.datastoreConverter.toV3Query(request.getPartitionIdOrBuilder(), request.getQueryOrBuilder());
        if (request.hasSuggestedBatchSize()) {
            result.setCount(request.getSuggestedBatchSize());
        }
        if ((options = request.getReadOptionsOrBuilder()).hasTransaction()) {
            result.setTransaction(this.transactionConverter.toV3Transaction(options.getTransaction(), appId, databaseId));
        } else if (options.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG) {
            result.setStrong(true);
        } else if (options.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL) {
            result.setStrong(false);
            result.setFailoverMs(-1L);
        }
        if (request.hasMinSafeTimeSeconds()) {
            result.setMinSafeTimeSeconds(request.getMinSafeTimeSeconds());
        }
        return result;
    }

    public DatastoreV4.RunQueryResponse.Builder toV4RunQueryResponse(DatastorePb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.RunQueryResponse.Builder builder = DatastoreV4.RunQueryResponse.newBuilder();
        builder.setBatch(this.datastoreConverter.toV4QueryResultBatch(result));
        if (result.hasCursor()) {
            builder.setQueryHandle(this.toV4QueryHandle(result.getCursor()));
        }
        return builder;
    }

    public DatastorePb.NextRequest toV3NextRequest(DatastoreV4.ContinueQueryRequestOrBuilder req) throws InvalidConversionException {
        DatastorePb.NextRequest next = new DatastorePb.NextRequest();
        next.setCompile(true);
        next.setCursor(this.toV3Cursor(req.getQueryHandle()));
        return next;
    }

    public DatastoreV4.ContinueQueryResponse.Builder toV4ContinueQueryResponse(DatastorePb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.ContinueQueryResponse.Builder builder = DatastoreV4.ContinueQueryResponse.newBuilder();
        builder.setBatch(this.datastoreConverter.toV4QueryResultBatch(result));
        return builder;
    }

    public DatastorePb.BeginTransactionRequest toV3BeginTransactionRequest(String app, DatastoreV4.BeginTransactionRequestOrBuilder req) {
        DatastorePb.BeginTransactionRequest reqV3 = new DatastorePb.BeginTransactionRequest();
        reqV3.setApp(app);
        reqV3.setAllowMultipleEg(req.getCrossGroup());
        return reqV3;
    }

    public DatastoreV4.BeginTransactionResponse.Builder toV4BeginTransactionResponse(DatastorePb.Transaction txn) throws InvalidConversionException {
        DatastoreV4.BeginTransactionResponse.Builder builder = DatastoreV4.BeginTransactionResponse.newBuilder();
        builder.setTransaction(this.transactionConverter.toTransactionBytes(txn));
        return builder;
    }

    public DatastorePb.Transaction toV3Transaction(DatastoreV4.RollbackRequestOrBuilder req, String appId, String databaseId) throws InvalidConversionException {
        return this.transactionConverter.toV3Transaction(req.getTransaction(), appId, databaseId);
    }

    public CommitRequest.Builder toV1CommitRequest(ProjectIdAppIdResolver resolver, DatastoreV4.CommitRequest reqV4) throws InvalidConversionException {
        CommitRequest.Builder reqV1 = CommitRequest.newBuilder();
        InvalidConversionException.checkConversion(reqV4.getMutationList().isEmpty() || !reqV4.hasDeprecatedMutation(), "CommitRequest has both a mutation list and a deprecated mutation", new Object[0]);
        if (reqV4.hasDeprecatedMutation()) {
            DatastoreV4.DeprecatedMutation deprecatedMutation = reqV4.getDeprecatedMutation();
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.UPSERT, deprecatedMutation.getUpsertList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.UPDATE, deprecatedMutation.getUpdateList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertAutoIdList());
            for (DatastoreV4.Mutation.Builder mutation : this.datastoreConverter.toV4DeleteMutationList(deprecatedMutation.getDeleteList())) {
                reqV1.addMutations(this.getDatastoreConverter().toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutation));
            }
        } else {
            for (DatastoreV4.Mutation mutationV4 : reqV4.getMutationList()) {
                reqV1.addMutations(this.getDatastoreConverter().toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutationV4));
            }
        }
        switch (reqV4.getMode()) {
            case NON_TRANSACTIONAL: {
                reqV1.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
                break;
            }
            case TRANSACTIONAL: {
                reqV1.setMode(CommitRequest.Mode.TRANSACTIONAL);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("mutation.mode", reqV4.getMode());
            }
        }
        if (reqV4.hasTransaction()) {
            reqV1.setTransaction(reqV4.getTransaction());
        }
        this.inferRequestHeader(reqV1);
        return reqV1;
    }

    private void addV1Mutations(ProjectIdAppIdResolver resolver, CommitRequest.Builder reqV1, DatastoreV4.Mutation.Operation op, List<EntityV4.Entity> entities) throws InvalidConversionException {
        for (DatastoreV4.Mutation.Builder mutation : this.datastoreConverter.toV4MutationList(op, entities)) {
            reqV1.addMutations(this.getDatastoreConverter().toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutation));
        }
    }

    public DatastoreV4.CommitResponse.Builder toV4CommitResponse(ProjectIdAppIdResolver resolver, CommitResponseOrBuilder resV1) throws InvalidConversionException {
        DatastoreV4.CommitResponse.Builder resV4 = DatastoreV4.CommitResponse.newBuilder();
        for (MutationResult resultV1 : resV1.getMutationResultsList()) {
            resV4.addMutationResult(this.toV4MutationResult(resolver, resultV1));
        }
        resV4.setIndexUpdates(resV1.getIndexUpdates());
        return resV4;
    }

    public RunQueryResponse.Builder toV1RunQueryResponse(ProjectIdAppIdResolver resolver, DatastorePb.QueryResult result, @Nullable Query parsedQuery, @Nullable ByteString newTxnBytes) throws InvalidConversionException {
        RunQueryResponse.Builder builder = RunQueryResponse.newBuilder();
        builder.setBatch(this.datastoreConverter.toV1QueryResultBatch(resolver, result));
        if (newTxnBytes != null) {
            builder.setTransaction(newTxnBytes);
        }
        if (parsedQuery != null) {
            builder.setQuery(parsedQuery);
        }
        return builder;
    }

    private DatastoreV4.MutationResult.Builder toV4MutationResult(ProjectIdAppIdResolver resolver, MutationResult resultV1) throws InvalidConversionException {
        DatastoreV4.MutationResult.Builder resultV4 = DatastoreV4.MutationResult.newBuilder();
        if (resultV1.hasKey()) {
            resultV4.setKey(this.getEntityConverter().toV4Key(resolver, (KeyOrBuilder)resultV1.getKey()));
        }
        return resultV4;
    }

    private void inferRequestHeader(CommitRequest.Builder reqV1) {
        for (Mutation mutation : reqV1.getMutationsList()) {
            switch (mutation.getOperationCase()) {
                case INSERT: {
                    reqV1.setProjectId(mutation.getInsert().getKey().getPartitionId().getProjectId());
                    return;
                }
                case UPDATE: {
                    reqV1.setProjectId(mutation.getUpdate().getKey().getPartitionId().getProjectId());
                    return;
                }
                case UPSERT: {
                    reqV1.setProjectId(mutation.getUpsert().getKey().getPartitionId().getProjectId());
                    return;
                }
                case DELETE: {
                    reqV1.setProjectId(mutation.getDelete().getPartitionId().getProjectId());
                    return;
                }
            }
        }
        reqV1.setProjectId("__unknown__");
    }
}

