/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQuery;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.UserValueObfuscator;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DatastoreV4Validator {
    private final EntityV4Validator entityValidatorV4;
    private final CloudDatastoreV1Validator validatorV1;
    private final DatastoreProtoConverter datastoreConverter;

    public DatastoreV4Validator(EntityV4Validator entityValidatorV4) {
        this.entityValidatorV4 = entityValidatorV4;
        this.validatorV1 = new CloudDatastoreV1Validator(entityValidatorV4.getEntityV1Validator());
        this.datastoreConverter = new DatastoreProtoConverter(new EntityV4Converter(false, UserValueObfuscator.IDENTITY), entityValidatorV4.getConfig());
    }

    EntityV4Converter getEntityConverter() {
        return this.datastoreConverter.getEntityConverter();
    }

    public EntityV4Validator getEntityValidator() {
        return this.entityValidatorV4;
    }

    public void validateRequestInitialized(MessageOrBuilder pb) throws ValidationException {
        List error = pb.findInitializationErrors();
        ValidationException.validateAssertion(error.isEmpty(), "not initialized: %s", error);
    }

    public void validateMutation(boolean isTrusted, Mutation mutationV1) throws ValidationException {
        ValidationConstraint constraint = CloudDatastoreV1Validator.constraintForMutation(mutationV1).withContext(isTrusted, new ValidationConstraint.Context[0]);
        switch (mutationV1.getOperationCase()) {
            case INSERT: {
                this.validatorV1.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutationV1.getInsert());
                break;
            }
            case UPDATE: {
                this.validatorV1.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutationV1.getUpdate());
                break;
            }
            case UPSERT: {
                this.validatorV1.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutationV1.getUpsert());
                break;
            }
            case DELETE: {
                this.validatorV1.entityValidator.validateKey(constraint, (KeyOrBuilder)mutationV1.getDelete());
                break;
            }
            default: {
                throw new ValidationException("mutation lacks required op");
            }
        }
    }

    public void validateMutations(boolean isTrusted, List<? extends DatastoreV4.MutationOrBuilder> mutations) throws ValidationException {
        try {
            for (DatastoreV4.MutationOrBuilder mutationOrBuilder : mutations) {
                Mutation mutationV1 = this.toV1Mutation(mutationOrBuilder).build();
                this.validateMutation(isTrusted, mutationV1);
            }
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateDeprecatedMutation(boolean isTrusted, DatastoreV4.DeprecatedMutationOrBuilder deprecatedMutation) throws ValidationException {
        try {
            Mutation.Builder mutationV1;
            ValidationConstraint writeConstraint = ValidationConstraint.UPDATE.withContext(isTrusted, new ValidationConstraint.Context[0]);
            ValidationConstraint insertAutoIdConstraint = ValidationConstraint.ALLOCATE_ID.withContext(isTrusted, new ValidationConstraint.Context[0]);
            this.validateMutations(isTrusted, this.datastoreConverter.toV4MutationList(DatastoreV4.Mutation.Operation.UPDATE, deprecatedMutation.getUpdateList()));
            for (DatastoreV4.Mutation.Builder mutationV4 : this.datastoreConverter.toV4MutationList(DatastoreV4.Mutation.Operation.UPSERT, deprecatedMutation.getUpsertList())) {
                mutationV1 = this.toV1Mutation((DatastoreV4.MutationOrBuilder)mutationV4);
                Preconditions.checkArgument((mutationV1.getOperationCase() == Mutation.OperationCase.UPSERT ? 1 : 0) != 0);
                if (mutationV1.getUpsert().hasKey()) {
                    this.validatorV1.getEntityValidator().validateKey(writeConstraint, (KeyOrBuilder)mutationV1.getUpsert().getKey());
                }
                this.validateMutation(isTrusted, mutationV1.build());
            }
            for (DatastoreV4.Mutation.Builder mutationV4 : this.datastoreConverter.toV4MutationList(DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertList())) {
                mutationV1 = this.toV1Mutation((DatastoreV4.MutationOrBuilder)mutationV4);
                Preconditions.checkArgument((mutationV1.getOperationCase() == Mutation.OperationCase.INSERT ? 1 : 0) != 0);
                if (mutationV1.getInsert().hasKey()) {
                    this.validatorV1.getEntityValidator().validateKey(writeConstraint, (KeyOrBuilder)mutationV1.getInsert().getKey());
                }
                this.validateMutation(isTrusted, mutationV1.build());
            }
            for (DatastoreV4.Mutation.Builder mutationV4 : this.datastoreConverter.toV4MutationList(DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertAutoIdList())) {
                mutationV1 = this.toV1Mutation((DatastoreV4.MutationOrBuilder)mutationV4);
                Preconditions.checkArgument((mutationV1.getOperationCase() == Mutation.OperationCase.INSERT ? 1 : 0) != 0);
                if (mutationV1.getInsert().hasKey()) {
                    this.validatorV1.getEntityValidator().validateKey(insertAutoIdConstraint, (KeyOrBuilder)mutationV1.getInsert().getKey());
                }
                this.validateMutation(isTrusted, mutationV1.build());
            }
            this.validateMutations(isTrusted, this.datastoreConverter.toV4DeleteMutationList(deprecatedMutation.getDeleteList()));
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateCommitMode(DatastoreV4.CommitRequest.Mode mode, boolean hasTransaction) throws ValidationException {
        switch (mode) {
            case TRANSACTIONAL: {
                this.validatorV1.validateCommitMode(CommitRequest.Mode.TRANSACTIONAL, hasTransaction);
                break;
            }
            case NON_TRANSACTIONAL: {
                this.validatorV1.validateCommitMode(CommitRequest.Mode.NON_TRANSACTIONAL, hasTransaction);
                break;
            }
            default: {
                String string = String.valueOf(mode);
                throw new ValidationException(new StringBuilder(21 + String.valueOf(string).length()).append("unknown commit mode: ").append(string).toString());
            }
        }
    }

    public void validateQuery(boolean isStrongReadConsistency, DatastoreV4.QueryOrBuilder query) throws ValidationException {
        this.validateQueryNative(query);
        Query.Builder queryV1 = this.toV1Query(query);
        try {
            this.validatorV1.validateQuery(ValidationConstraint.QUERY, isStrongReadConsistency, (QueryOrBuilder)queryV1);
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateQueryNative(DatastoreV4.QueryOrBuilder query) throws ValidationException {
        HashSet<String> groupByProperties = new HashSet<String>();
        for (DatastoreV4.PropertyReferenceOrBuilder propRef : query.getGroupByOrBuilderList()) {
            groupByProperties.add(propRef.getName());
        }
        for (DatastoreV4.PropertyExpressionOrBuilder propExp : query.getProjectionOrBuilderList()) {
            this.validatePropertyExpressionNative(propExp, groupByProperties);
        }
    }

    private void validatePropertyExpressionNative(DatastoreV4.PropertyExpressionOrBuilder propExp, Set<String> groupByProperties) throws ValidationException {
        if (groupByProperties.isEmpty()) {
            ValidationException.validateAssertion(!propExp.hasAggregationFunction(), "aggregation function is not allowed without group by", new Object[0]);
        } else if (groupByProperties.contains(propExp.getPropertyOrBuilder().getName())) {
            ValidationException.validateAssertion(!propExp.hasAggregationFunction(), "aggregation function is not allowed for properties in group by: %s", propExp.getPropertyOrBuilder().getName());
        } else {
            ValidationException.validateAssertion(propExp.hasAggregationFunction(), "aggregation function is required for properties not in group by: %s", propExp.getPropertyOrBuilder().getName());
        }
    }

    public void validateGqlQuery(DatastoreV4.GqlQueryOrBuilder gqlQuery) throws ValidationException {
        try {
            this.validatorV1.validateGqlQuery((GqlQueryOrBuilder)this.toV1GqlQuery(gqlQuery));
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateReadOptions(boolean hasReadConsistency, boolean hasTransaction) throws ValidationException {
        ValidationException.validateAssertion(!hasReadConsistency || !hasTransaction, "cannot specify both a read consistency and a transaction", new Object[0]);
    }

    private Query.Builder toV1Query(DatastoreV4.QueryOrBuilder queryV4) throws ValidationException {
        try {
            return this.datastoreConverter.toV1Query(ProjectIdAppIdResolver.IDENTITY, queryV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private GqlQuery.Builder toV1GqlQuery(DatastoreV4.GqlQueryOrBuilder queryV4) throws ValidationException {
        try {
            return this.datastoreConverter.toV1GqlQuery(ProjectIdAppIdResolver.IDENTITY, queryV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private Mutation.Builder toV1Mutation(DatastoreV4.MutationOrBuilder mutationV4) throws ValidationException {
        try {
            return this.datastoreConverter.toV1Mutation(ProjectIdAppIdResolver.IDENTITY, mutationV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }
}

