/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.TransactionConverter;

public class LocalTransactionConverter
implements TransactionConverter {
    @Override
    public ByteString toTransactionBytes(DatastorePb.Transaction transactionV3) throws InvalidConversionException {
        return transactionV3.toByteString();
    }

    @Override
    public DatastorePb.Transaction toV3Transaction(ByteString transactionBytes, String appId, String databaseId) throws InvalidConversionException {
        try {
            return (DatastorePb.Transaction)DatastorePb.Transaction.parser().parseFrom(transactionBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException("Invalid transaction", e);
        }
    }

    @Override
    public long toTransactionHandle(ByteString transactionBytes) throws InvalidConversionException {
        return this.toV3Transaction(transactionBytes, null, null).getHandle();
    }
}

