/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableTable;
import com.google.apphosting.datastore.rep.Mutation;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.storage.onestore.v3.OnestoreEntity;

public abstract class MutationHelper {
    private static final ImmutableTable<Mutation.Op, Mutation.Op, Mutation.Op> OPERATION_COLLAPSES;

    public static Mutation collapse(Mutation mutation1, Mutation mutation2) throws InvalidConversionException {
        Mutation.Op op1 = mutation1.op();
        Mutation.Op op2 = mutation2.op();
        OnestoreEntity.Reference key1 = mutation1.key();
        OnestoreEntity.Reference key2 = mutation2.key();
        long baseVersion1 = mutation1.baseVersion();
        long baseVersion2 = mutation2.baseVersion();
        Preconditions.checkArgument((!Paths.hasIncompleteLastElement(key1) ? 1 : 0) != 0, (Object)"cannot collapse mutation with incomplete key");
        Preconditions.checkArgument((!Paths.hasIncompleteLastElement(key2) ? 1 : 0) != 0, (Object)"cannot collapse mutation with incomplete key");
        Preconditions.checkArgument((boolean)key1.equals(key2), (Object)"cannot collapse mutations with different keys");
        Preconditions.checkArgument((op2 != Mutation.Op.DELETE_MUST_EXIST && op2 != Mutation.Op.DELETE_MUST_NOT_EXIST ? 1 : 0) != 0, (String)"second mutation cannot be of type: %s", (Object)((Object)op2));
        Mutation.Op collapsedOp = (Mutation.Op)((Object)OPERATION_COLLAPSES.get((Object)op1, (Object)op2));
        InvalidConversionException.checkConversion(collapsedOp != null, "Cannot %s then %s an entity in the same request.", MutationHelper.getOpNameForErrorMessage(mutation1), MutationHelper.getOpNameForErrorMessage(mutation2));
        InvalidConversionException.checkConversion(baseVersion1 == baseVersion2, "Cannot collapse mutations with different base versions (%d and %d)", baseVersion1, baseVersion2);
        if (collapsedOp.isDelete()) {
            return Mutation.of(collapsedOp, key2, baseVersion2);
        }
        OnestoreEntity.EntityProto entity = mutation2.entity();
        PropertyMask mask = mutation2.propertyMask();
        if (!mutation1.isDelete()) {
            entity = mask.maskInto(entity, mutation1.entity());
            mask = mask.merge(mutation1.propertyMask());
        }
        return Mutation.of(collapsedOp, entity, mask, baseVersion2);
    }

    private static String getOpNameForErrorMessage(Mutation mutation) {
        Mutation.Op opForErrorMessage = mutation.op();
        if (mutation.isDelete()) {
            opForErrorMessage = Mutation.Op.DELETE;
        }
        return opForErrorMessage.name().toLowerCase();
    }

    static {
        ImmutableTable.Builder collapses = ImmutableTable.builder();
        collapses.put((Object)Mutation.Op.INSERT, (Object)Mutation.Op.UPDATE, (Object)Mutation.Op.INSERT);
        collapses.put((Object)Mutation.Op.INSERT, (Object)Mutation.Op.UPSERT, (Object)Mutation.Op.INSERT);
        collapses.put((Object)Mutation.Op.INSERT, (Object)Mutation.Op.DELETE, (Object)Mutation.Op.DELETE_MUST_NOT_EXIST);
        collapses.put((Object)Mutation.Op.UPDATE, (Object)Mutation.Op.UPDATE, (Object)Mutation.Op.UPDATE);
        collapses.put((Object)Mutation.Op.UPDATE, (Object)Mutation.Op.UPSERT, (Object)Mutation.Op.UPDATE);
        collapses.put((Object)Mutation.Op.UPDATE, (Object)Mutation.Op.DELETE, (Object)Mutation.Op.DELETE_MUST_EXIST);
        collapses.put((Object)Mutation.Op.UPSERT, (Object)Mutation.Op.UPDATE, (Object)Mutation.Op.UPSERT);
        collapses.put((Object)Mutation.Op.UPSERT, (Object)Mutation.Op.UPSERT, (Object)Mutation.Op.UPSERT);
        collapses.put((Object)Mutation.Op.UPSERT, (Object)Mutation.Op.DELETE, (Object)Mutation.Op.DELETE);
        collapses.put((Object)Mutation.Op.DELETE, (Object)Mutation.Op.INSERT, (Object)Mutation.Op.UPSERT);
        collapses.put((Object)Mutation.Op.DELETE, (Object)Mutation.Op.UPSERT, (Object)Mutation.Op.UPSERT);
        collapses.put((Object)Mutation.Op.DELETE, (Object)Mutation.Op.DELETE, (Object)Mutation.Op.DELETE);
        collapses.put((Object)Mutation.Op.DELETE_MUST_EXIST, (Object)Mutation.Op.INSERT, (Object)Mutation.Op.UPDATE);
        collapses.put((Object)Mutation.Op.DELETE_MUST_EXIST, (Object)Mutation.Op.UPSERT, (Object)Mutation.Op.UPDATE);
        collapses.put((Object)Mutation.Op.DELETE_MUST_EXIST, (Object)Mutation.Op.DELETE, (Object)Mutation.Op.DELETE_MUST_EXIST);
        collapses.put((Object)Mutation.Op.DELETE_MUST_NOT_EXIST, (Object)Mutation.Op.INSERT, (Object)Mutation.Op.INSERT);
        collapses.put((Object)Mutation.Op.DELETE_MUST_NOT_EXIST, (Object)Mutation.Op.UPSERT, (Object)Mutation.Op.INSERT);
        collapses.put((Object)Mutation.Op.DELETE_MUST_NOT_EXIST, (Object)Mutation.Op.DELETE, (Object)Mutation.Op.DELETE_MUST_NOT_EXIST);
        OPERATION_COLLAPSES = collapses.build();
    }
}

