/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.apphosting.datastore.rep.Mutation;
import com.google.apphosting.datastore.rep.MutationResult;
import com.google.apphosting.datastore.rep.Write;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.MutationHelper;
import com.google.apphosting.datastore.shared.Paths;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class WriteHelper {
    private WriteHelper() {
    }

    public static Write.Builder toWrite(boolean trusted, boolean markChanges, List<Mutation> mutationsList) throws InvalidConversionException {
        Write.Builder write = Write.builder();
        int[] mutationMap = new int[mutationsList.size()];
        mutationsList = WriteHelper.collapseMutations(mutationsList, mutationMap);
        write.mutations(mutationsList).originalMutationsMap(mutationMap).isTrusted(trusted).markChanges(markChanges);
        return write;
    }

    private static ImmutableList<Mutation> collapseMutations(List<Mutation> originalMutations, int[] originalMutationsMap) throws InvalidConversionException {
        ArrayList collapsedMutations = Lists.newArrayListWithCapacity((int)originalMutations.size());
        HashMap collapsedMutationMapping = Maps.newHashMapWithExpectedSize((int)originalMutations.size());
        for (int i = 0; i < originalMutations.size(); ++i) {
            Mutation mutation = originalMutations.get(i);
            OnestoreEntity.Reference key = mutation.key();
            if (Paths.hasIncompleteLastElement(key)) {
                originalMutationsMap[i] = collapsedMutations.size();
                collapsedMutations.add(mutation);
                continue;
            }
            Integer collapsedMutationsIndex = (Integer)collapsedMutationMapping.get(key);
            if (collapsedMutationsIndex == null) {
                collapsedMutationsIndex = collapsedMutations.size();
                collapsedMutations.add(mutation);
                collapsedMutationMapping.put(key, collapsedMutationsIndex);
            } else {
                Mutation previousMutation = (Mutation)collapsedMutations.get(collapsedMutationsIndex);
                Mutation collapsedMutation = MutationHelper.collapse(previousMutation, mutation);
                collapsedMutations.set(collapsedMutationsIndex, collapsedMutation);
            }
            originalMutationsMap[i] = collapsedMutationsIndex;
        }
        return ImmutableList.copyOf((Collection)collapsedMutations);
    }

    public static Iterable<MutationResult> toMutationResults(final Write write) {
        return new Iterable<MutationResult>(){

            @Override
            public Iterator<MutationResult> iterator() {
                return new Iterator<MutationResult>(){
                    private final int length;
                    private int idx;
                    {
                        this.length = write.originalMutationsMap() == null ? write.mutations().size() : write.originalMutationsMap().length;
                        this.idx = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.length > this.idx;
                    }

                    @Override
                    public MutationResult next() {
                        Mutation mutation = (Mutation)write.mutations().get(write.originalMutationsMap() == null ? this.idx : write.originalMutationsMap()[this.idx]);
                        ++this.idx;
                        return MutationResult.create(mutation.key(), mutation.allocateKey(), mutation.op(), write);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

