/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.appengine.api.socket.dev.MockSocketOptionMap;
import com.google.apphosting.api.ApiProxy;

class SocketPermissions {
    private static final String SOCKET_PERMISSIONS = "com.google.appengine.api.sockets.dev.SocketPermissions.PERMISSIONS";
    static final String DEFAULT_SOCKET_OPTIONS_SPEC = "SOL_SOCKET:SO_KEEPALIVE=00000000,SOL_SOCKET:SO_DEBUG=80000000,SOL_TCP:TCP_NODELAY=00000000,SOL_SOCKET:SO_LINGER=0000000000000000,SOL_SOCKET:SO_OOBINLINE=00000000,SOL_SOCKET:SO_SNDBUF=00002000,SOL_SOCKET:SO_RCVBUF=00002000,SOL_SOCKET:SO_REUSEADDR=01000000";
    private static volatile SocketPermissions defaultPermission = new SocketPermissions(false, false, true, true, true, "SOL_SOCKET:SO_KEEPALIVE=00000000,SOL_SOCKET:SO_DEBUG=80000000,SOL_TCP:TCP_NODELAY=00000000,SOL_SOCKET:SO_LINGER=0000000000000000,SOL_SOCKET:SO_OOBINLINE=00000000,SOL_SOCKET:SO_SNDBUF=00002000,SOL_SOCKET:SO_RCVBUF=00002000,SOL_SOCKET:SO_REUSEADDR=01000000");
    private boolean canBind;
    private boolean canListen;
    private boolean canConnect;
    private boolean canSetSocketOpt;
    private boolean canGetSocketOpt;
    private MockSocketOptionMap mockSocketOptions;

    public SocketPermissions(boolean canBind, boolean canListen, boolean canConnect, boolean canSetSocketOpt, boolean canGetSocketOpt, String mockOptionsSpec) {
        this.canBind = canBind;
        this.canListen = canListen;
        this.canConnect = canConnect;
        this.canSetSocketOpt = canSetSocketOpt;
        this.canGetSocketOpt = canGetSocketOpt;
        this.mockSocketOptions = MockSocketOptionMap.createFromOptionsSpec(mockOptionsSpec);
    }

    private SocketPermissions(boolean canBind, boolean canListen, boolean canConnect, boolean canSetSocketOpt, boolean canGetSocketOpt, MockSocketOptionMap mockOptions) {
        this.canBind = canBind;
        this.canListen = canListen;
        this.canConnect = canConnect;
        this.canSetSocketOpt = canSetSocketOpt;
        this.canGetSocketOpt = canGetSocketOpt;
        this.mockSocketOptions = new MockSocketOptionMap(mockOptions);
    }

    public void checkBind() {
        if (!this.canBind) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.PERMISSION_DENIED, "bind");
        }
    }

    public void checkListen() {
        if (!this.canListen) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.PERMISSION_DENIED, "listen");
        }
    }

    public void checkConnect() {
        if (!this.canConnect) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.PERMISSION_DENIED, "connect");
        }
    }

    public void checkSetSocketOpt(SocketServicePb.SocketOption option) {
        if (!this.canSetSocketOpt) {
            int n = option.getLevel();
            int n2 = option.getOption();
            throw this.newNotImplementedException(new StringBuilder(48).append("setOption(level=").append(n).append(", option=").append(n2).append(")").toString());
        }
    }

    public byte[] checkGetSocketOpt(SocketServicePb.SocketOption option) {
        if (!this.canGetSocketOpt) {
            throw this.newNotImplementedException("setOption");
        }
        byte[] value = this.mockSocketOptions.getMockOption(option);
        if (value != null) {
            return value;
        }
        int n = option.getLevel();
        int n2 = option.getOption();
        throw this.newNotImplementedException(new StringBuilder(48).append("getOption(level=").append(n).append(", option=").append(n2).append(")").toString());
    }

    private ApiProxy.ApplicationException newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode code, String function) {
        return new ApiProxy.ApplicationException(code.getValue(), new StringBuilder(50 + String.valueOf(function).length()).append("Not allowed to issue a socket ").append(function).append(": permission denied.").toString());
    }

    private ApiProxy.ApplicationException newNotImplementedException(String method) {
        return new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE.getValue(), new StringBuilder(24 + String.valueOf(method).length()).append("socket ").append(method).append(": Not implemented").toString());
    }

    public static void setDefaultSocketPermissions(String canBind, String canListen, String canConnect, String canSetSocketOpt, String canGetSocketOpt, String mockSocketOpt) {
        boolean lCanBin = canBind == null ? SocketPermissions.defaultPermission.canBind : Boolean.valueOf(canBind);
        boolean lCanListen = canListen == null ? SocketPermissions.defaultPermission.canListen : Boolean.valueOf(canListen);
        boolean lCanConnect = canConnect == null ? SocketPermissions.defaultPermission.canConnect : Boolean.valueOf(canConnect);
        boolean lCanSetSocketOpt = canSetSocketOpt == null ? SocketPermissions.defaultPermission.canSetSocketOpt : Boolean.valueOf(canSetSocketOpt);
        boolean lCanGetSocketOpt = canGetSocketOpt == null ? SocketPermissions.defaultPermission.canGetSocketOpt : Boolean.valueOf(canGetSocketOpt);
        MockSocketOptionMap lMockSocketOptMap = mockSocketOpt == null ? SocketPermissions.defaultPermission.mockSocketOptions : MockSocketOptionMap.createFromOptionsSpec(mockSocketOpt);
        defaultPermission = new SocketPermissions(lCanBin, lCanListen, lCanConnect, lCanSetSocketOpt, lCanGetSocketOpt, lMockSocketOptMap);
    }

    public static void setSocketPermissions(boolean canBind, boolean canListen, boolean canConnect, boolean canSetSocketOpt, boolean canGetSocketOpt, String mockSocketOpt) {
        ApiProxy.getCurrentEnvironment().getAttributes().put(SOCKET_PERMISSIONS, new SocketPermissions(canBind, canListen, canConnect, canSetSocketOpt, canGetSocketOpt, mockSocketOpt));
    }

    public static SocketPermissions getSocketPermissions() {
        SocketPermissions currentPermission = (SocketPermissions)ApiProxy.getCurrentEnvironment().getAttributes().get(SOCKET_PERMISSIONS);
        if (currentPermission == null) {
            return defaultPermission;
        }
        return currentPermission;
    }
}

