/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import java.io.IOException;
import java.io.InputStream;

@GwtCompatible
final class LittleEndianInput
implements AutoCloseable {
    private final InputStream input;

    public LittleEndianInput(InputStream input) {
        this.input = input;
    }

    public byte readByte() throws IOException {
        int result = this.input.read();
        if (result < 0) {
            throw new IOException();
        }
        return (byte)(result & 0xFF);
    }

    public byte[] readBytes(int size) throws IOException {
        byte[] result = new byte[size];
        int numRead = this.input.read(result);
        if (numRead < size) {
            throw new IOException();
        }
        return result;
    }

    public int readInt() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 24;
    }

    public long readLong() throws IOException {
        return (long)this.readByte() & 0xFFL | ((long)this.readByte() & 0xFFL) << 8 | ((long)this.readByte() & 0xFFL) << 16 | ((long)this.readByte() & 0xFFL) << 24 | ((long)this.readByte() & 0xFFL) << 32 | ((long)this.readByte() & 0xFFL) << 40 | ((long)this.readByte() & 0xFFL) << 48 | ((long)this.readByte() & 0xFFL) << 56;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int readVarint32() throws IOException {
        return (int)this.readVarint64();
    }

    public long readVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed varint.");
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

