/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.$AutoValue_DatabaseRef;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.rep.ResourceRef;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public abstract class DatabaseRef
implements ResourceRef {
    public static final DatabaseRef EMPTY = DatabaseRef.builder().clusterId("").projectId("").databaseId("").isMetadata(false).build();

    public static Builder builder() {
        return new $AutoValue_DatabaseRef.Builder();
    }

    public static DatabaseRef createForProject(String clusterId, String projectId, String databaseId) {
        boolean isMetadata;
        Preconditions.checkNotNull((Object)clusterId);
        if (clusterId.isEmpty() && projectId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Matcher matcher = RepHelper.PROJECT_ID_REGEX.matcher(projectId);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Not a project id");
        boolean bl = isMetadata = matcher.matches() && matcher.group("metadata") != null;
        if (isMetadata) {
            projectId = matcher.group("metadata");
        }
        return DatabaseRef.builder().isMetadata(isMetadata).clusterId(clusterId).projectId(projectId).databaseId(databaseId).build();
    }

    public static DatabaseRef createWithUnknownCluster(String projectId, String databaseId) {
        boolean isMetadata;
        if (projectId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Matcher matcher = RepHelper.PROJECT_ID_REGEX.matcher(projectId);
        boolean bl = isMetadata = matcher.matches() && matcher.group("metadata") != null;
        if (isMetadata) {
            projectId = matcher.group("metadata");
        }
        return DatabaseRef.builder().isMetadata(isMetadata).clusterId(null).projectId(projectId).databaseId(databaseId).build();
    }

    public static DatabaseRef createForApp(String appId, String databaseId) {
        if (appId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Matcher matcher = RepHelper.APP_ID_REGEX.matcher(appId);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Invalid app id");
        boolean isMetadata = matcher.group("metadata") != null;
        String projectId = isMetadata ? matcher.group("metadata") : matcher.group("project");
        String clusterId = matcher.group("cluster") != null ? matcher.group("cluster") : "";
        return DatabaseRef.builder().isMetadata(isMetadata).clusterId(clusterId).projectId(projectId).databaseId(databaseId).build();
    }

    public abstract boolean isMetadata();

    @Nullable
    protected abstract String autoClusterId();

    public abstract String projectId();

    public abstract String databaseId();

    public ByteString databaseIdAsByteString() {
        return ByteString.copyFromUtf8((String)this.databaseId());
    }

    public String appId() {
        if (this.isMetadata()) {
            String string = String.valueOf("__metadata-");
            String string2 = String.valueOf(this.projectId());
            String string3 = String.valueOf("__");
            return RepHelper.projectIdToApp(this.clusterId(), new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(string3).toString());
        }
        return RepHelper.projectIdToApp(this.clusterId(), this.projectId());
    }

    public ByteString appIdAsByteString() {
        return ByteString.copyFromUtf8((String)this.appId());
    }

    public String clusterId() {
        if (this.autoClusterId() == null) {
            throw new Error("Unknown cluster.");
        }
        return this.autoClusterId();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.autoClusterId() == null) {
            builder.append("<unknown!>~");
        } else if (!this.autoClusterId().isEmpty()) {
            builder.append(this.autoClusterId());
            builder.append("~");
        }
        if (this.isMetadata()) {
            builder.append("__metadata-");
        }
        builder.append(this.projectId());
        if (this.isMetadata()) {
            builder.append("__");
        }
        if (!this.databaseId().isEmpty()) {
            builder.append("#");
            builder.append(this.databaseId());
        }
        return builder.toString();
    }

    public abstract Builder toBuilder();

    public DatabaseRef toMetadataDatabase() {
        Preconditions.checkArgument((!this.isMetadata() ? 1 : 0) != 0, (Object)"Cannot reference the metadata database of a metadata database.");
        return this.toBuilder().isMetadata(true).build();
    }

    public DatabaseRef toNonMetadataDatabase() {
        Preconditions.checkArgument((boolean)this.isMetadata(), (Object)"Cannot remove the metadata-ness of a non-metadata database.");
        return this.toBuilder().isMetadata(false).build();
    }

    public DatabaseRef withoutAppPartition() {
        if (this.autoClusterId() == null) {
            return this;
        }
        return this.toBuilder().clusterId(null).build();
    }

    public boolean hasAppPartition() {
        return this.autoClusterId() != null && !this.autoClusterId().isEmpty();
    }

    public static abstract class Builder {
        public abstract Builder isMetadata(boolean var1);

        public Builder clusterId(@Nullable String clusterId) {
            return this.autoClusterId(clusterId);
        }

        protected abstract Builder autoClusterId(@Nullable String var1);

        public abstract Builder projectId(String var1);

        public abstract Builder databaseId(String var1);

        public abstract DatabaseRef build();
    }
}

