/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.datastore.rep.AutoValue_Mutation;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.ReferencePaths;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public abstract class Mutation {
    private boolean autoIdInserted = false;

    public abstract boolean allocateKey();

    public abstract Op op();

    @Nullable
    public abstract OnestoreEntity.EntityProto entity();

    @Nullable
    public abstract PropertyMask propertyMask();

    public abstract OnestoreEntity.Reference key();

    @Nullable
    public abstract Long baseVersion();

    @Nullable
    public abstract ConflictResolutionStrategy conflictResolutionStrategy();

    public static Mutation of(Op op, OnestoreEntity.EntityProto entity) {
        return Mutation.of(op, entity.getKey(), entity, PropertyMask.FULL, null, null);
    }

    public static Mutation of(Op op, OnestoreEntity.EntityProto entity, PropertyMask mask, @Nullable Long baseVersion, @Nullable ConflictResolutionStrategy resolutionStrategy) {
        return Mutation.of(op, entity.getKey(), entity, mask, baseVersion, resolutionStrategy);
    }

    public static Mutation of(Op op, OnestoreEntity.Reference key) {
        return Mutation.of(op, key, null, null, null, null);
    }

    public static Mutation of(Op op, OnestoreEntity.Reference key, @Nullable Long baseVersion, @Nullable ConflictResolutionStrategy resolutionStrategy) {
        return Mutation.of(op, key, null, null, baseVersion, resolutionStrategy);
    }

    private static Mutation of(Op op, OnestoreEntity.Reference key, @Nullable OnestoreEntity.EntityProto entity, @Nullable PropertyMask mask, @Nullable Long baseVersion, @Nullable ConflictResolutionStrategy resolutionStrategy) {
        Preconditions.checkArgument((entity == null == op.isDelete() ? 1 : 0) != 0);
        Preconditions.checkArgument((mask == null == op.isDelete() ? 1 : 0) != 0);
        Preconditions.checkArgument((resolutionStrategy == null == (baseVersion == null) ? 1 : 0) != 0);
        boolean allocateKey = false;
        if (entity != null) {
            Preconditions.checkArgument((boolean)mask.hasKey());
            if (ReferencePaths.hasIncompleteLastElement(key)) {
                Preconditions.checkArgument((op != Op.UPDATE ? 1 : 0) != 0);
                op = Op.INSERT;
                allocateKey = true;
            }
        }
        return new AutoValue_Mutation(allocateKey, op, entity, mask, key, baseVersion, resolutionStrategy);
    }

    public void setAutoIdInserted() {
        this.autoIdInserted = true;
    }

    public boolean getAutoIdInserted() {
        return this.autoIdInserted;
    }

    public boolean isDelete() {
        return this.op().isDelete();
    }

    public boolean hasConflictDetection() {
        return this.baseVersion() != null;
    }

    public boolean conflictsWith(long serverVersion) {
        return this.baseVersion() != null && this.baseVersion() != serverVersion;
    }

    public static enum ConflictResolutionStrategy {
        SERVER_VALUE,
        CLIENT_VALUE,
        FAIL;

    }

    public static enum Op {
        INSERT(false),
        UPDATE(false),
        UPSERT(false),
        DELETE(true),
        DELETE_MUST_EXIST(true),
        DELETE_MUST_NOT_EXIST(true);

        private final boolean isDelete;

        private Op(boolean isDelete) {
            this.isDelete = isDelete;
        }

        public boolean isDelete() {
            return this.isDelete;
        }
    }
}

