/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.datastore.rep.AutoValue_PropertyMask_EntityProperty;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PropertyMask {
    public static final PropertyMask FULL = new PropertyMask(false, Collections.emptyMap()){

        @Override
        public String toString() {
            return "*";
        }

        @Override
        public OnestoreEntity.EntityProto mask(OnestoreEntity.EntityProto entity) {
            return entity;
        }

        @Override
        public OnestoreEntity.EntityProto maskInto(OnestoreEntity.EntityProto srcEntity, OnestoreEntity.EntityProto oldEntity) {
            return srcEntity;
        }

        @Override
        public PropertyMask merge(PropertyMask other) {
            return this;
        }

        @Override
        public PropertyMask getNestedMask(PropertyName name) {
            return FULL;
        }

        @Override
        public boolean hasKey() {
            return true;
        }
    };
    private final boolean key;
    private final Map<PropertyName, PropertyMask> properties;

    public PropertyMask(boolean key, Map<PropertyName, PropertyMask> properties) {
        this.key = key;
        this.properties = ImmutableMap.copyOf(properties);
    }

    public boolean hasKey() {
        return this.key;
    }

    public Set<PropertyName> getPropertyNames() {
        return this.properties.keySet();
    }

    public PropertyMask getNestedMask(PropertyName name) {
        Preconditions.checkArgument((boolean)this.properties.containsKey(name));
        return this.properties.get(name);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == FULL || obj == FULL) {
            return obj == this;
        }
        if (obj instanceof PropertyMask) {
            PropertyMask that = (PropertyMask)obj;
            return this.key == that.key && this.properties.equals(that.properties);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("properties", this.properties).toString();
    }

    public PropertyMask merge(PropertyMask other) {
        if (FULL.equals(other)) {
            return other;
        }
        HashMap<PropertyName, PropertyMask> merged = new HashMap<PropertyName, PropertyMask>();
        for (PropertyName name : Sets.union(this.properties.keySet(), other.properties.keySet())) {
            PropertyMask thisNestedMask = this.properties.get(name);
            PropertyMask otherNestedMask = other.properties.get(name);
            if (thisNestedMask == null) {
                merged.put(name, otherNestedMask);
                continue;
            }
            if (otherNestedMask == null) {
                merged.put(name, thisNestedMask);
                continue;
            }
            merged.put(name, thisNestedMask.merge(otherNestedMask));
        }
        return new PropertyMask(this.key || other.key, merged);
    }

    public OnestoreEntity.EntityProto mask(OnestoreEntity.EntityProto entity) {
        return this.maskInto(entity, new OnestoreEntity.EntityProto());
    }

    public OnestoreEntity.EntityProto maskInto(OnestoreEntity.EntityProto srcEntity, OnestoreEntity.EntityProto dstEntity) {
        OnestoreEntity.EntityProto result = new OnestoreEntity.EntityProto();
        PropertyMask.copyKeyInto(this.key ? srcEntity : dstEntity, result);
        HashMap<PropertyName, EntityProperty> srcMerges = new HashMap<PropertyName, EntityProperty>();
        for (EntityProperty srcProperty : this.getAllProperties(srcEntity)) {
            PropertyMask nestedMask = this.properties.get(srcProperty.name());
            if (FULL.equals(nestedMask)) {
                srcProperty.addTo(result);
                continue;
            }
            if (nestedMask == null || !srcProperty.isNestedEntity()) continue;
            srcMerges.put(srcProperty.name(), srcProperty);
        }
        HashMap<PropertyName, EntityProperty> dstMerges = new HashMap<PropertyName, EntityProperty>();
        List<EntityProperty> dstProperties = this.getAllProperties(dstEntity);
        for (EntityProperty dstProperty : dstProperties) {
            PropertyMask nestedMask = this.properties.get(dstProperty.name());
            if (nestedMask == null) {
                dstProperty.addTo(result);
                continue;
            }
            if (nestedMask.equals(FULL) || !dstProperty.isNestedEntity()) continue;
            dstMerges.put(dstProperty.name(), dstProperty);
        }
        HashSet<PropertyName> mergedPropertyNames = new HashSet<PropertyName>();
        for (PropertyName mergePropertyName : Sets.union(srcMerges.keySet(), dstMerges.keySet())) {
            EntityProperty dstProperty = (EntityProperty)dstMerges.get(mergePropertyName);
            EntityProperty srcProperty = (EntityProperty)srcMerges.get(mergePropertyName);
            EntityProperty targetProperty = (EntityProperty)MoreObjects.firstNonNull((Object)dstProperty, (Object)srcProperty);
            OnestoreEntity.EntityProto dstNested = dstProperty != null ? dstProperty.nestedEntity() : new OnestoreEntity.EntityProto();
            OnestoreEntity.EntityProto srcNested = srcProperty != null ? srcProperty.nestedEntity() : new OnestoreEntity.EntityProto();
            PropertyMask nestedMask = this.properties.get(mergePropertyName);
            OnestoreEntity.EntityProto merged = nestedMask.maskInto(srcNested, dstNested);
            if (dstProperty == null && !nestedMask.key && merged.propertySize() <= 0 && merged.rawPropertySize() <= 0) continue;
            targetProperty.withNestedEntity(merged).addTo(result);
            mergedPropertyNames.add(mergePropertyName);
        }
        for (EntityProperty dstProperty : dstProperties) {
            PropertyMask nestedMask = this.properties.get(dstProperty.name());
            if (nestedMask == null || nestedMask.equals(FULL) || mergedPropertyNames.contains(dstProperty.name())) continue;
            dstProperty.addTo(result);
        }
        return result;
    }

    private List<EntityProperty> getAllProperties(OnestoreEntity.EntityProto entity) {
        LinkedList<EntityProperty> entityProperties = new LinkedList<EntityProperty>();
        for (OnestoreEntity.Property property : entity.propertys()) {
            entityProperties.add(EntityProperty.fromIndexed(property));
        }
        for (OnestoreEntity.Property property : entity.rawPropertys()) {
            entityProperties.add(EntityProperty.fromUnindexed(property));
        }
        return entityProperties;
    }

    private static void copyKeyInto(OnestoreEntity.EntityProto src, OnestoreEntity.EntityProto dst) {
        if (src.hasKey()) {
            dst.setKey(src.getKey());
        } else {
            dst.clearKey();
        }
        if (src.hasEntityGroup()) {
            dst.setEntityGroup(src.getEntityGroup());
        } else {
            dst.clearEntityGroup();
        }
        if (src.hasKind()) {
            dst.setKind(src.getKind());
        } else {
            dst.clearKind();
        }
        if (src.hasKindUri()) {
            dst.setKindUri(src.getKindUri());
        } else {
            dst.clearKindUri();
        }
    }

    static abstract class EntityProperty {
        EntityProperty() {
        }

        abstract PropertyName name();

        abstract OnestoreEntity.Property property();

        abstract boolean indexed();

        @Nullable
        OnestoreEntity.EntityProto nestedEntity() {
            if (this.property().isMultiple() || this.property().getMeaningEnum() != OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                return null;
            }
            try {
                return (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.parser().parsePartialFrom(this.property().getValue().getStringValueAsBytes());
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }

        boolean isNestedEntity() {
            return this.nestedEntity() != null;
        }

        void addTo(OnestoreEntity.EntityProto entity) {
            if (this.indexed()) {
                entity.addProperty(this.property());
            } else {
                entity.addRawProperty(this.property());
            }
        }

        static EntityProperty fromIndexed(OnestoreEntity.Property property) {
            return new AutoValue_PropertyMask_EntityProperty(PropertyName.from(property), property, true);
        }

        static EntityProperty fromUnindexed(OnestoreEntity.Property property) {
            return new AutoValue_PropertyMask_EntityProperty(PropertyName.from(property), property, false);
        }

        EntityProperty withNestedEntity(OnestoreEntity.EntityProto nestedEntity) {
            Preconditions.checkState((boolean)this.isNestedEntity());
            OnestoreEntity.Property property = (OnestoreEntity.Property)this.property().clone();
            property.getMutableValue().setStringValueAsBytes(nestedEntity.toByteArray());
            return new AutoValue_PropertyMask_EntityProperty(this.name(), property, this.indexed());
        }
    }
}

