/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.PropertyName;

public class PropertyPathHelper {
    public static boolean isValidPropertyPath(ByteString propertyPath) {
        for (int i = 0; i < propertyPath.size(); ++i) {
            if (propertyPath.byteAt(i) != 92 || ++i < propertyPath.size() && (propertyPath.byteAt(i) == 46 || propertyPath.byteAt(i) == 92)) continue;
            return false;
        }
        return true;
    }

    public static ImmutableList<ByteString> unescapePropertyPath(ByteString propertyPath) {
        ImmutableList.Builder propertyNames = ImmutableList.builder();
        int startIndex = 0;
        for (int i = 0; i < propertyPath.size(); ++i) {
            if (propertyPath.byteAt(i) == 92) {
                Preconditions.checkArgument((++i < propertyPath.size() && (propertyPath.byteAt(i) == 46 || propertyPath.byteAt(i) == 92) ? 1 : 0) != 0);
                continue;
            }
            if (propertyPath.byteAt(i) != 46) continue;
            propertyNames.add((Object)PropertyPathHelper.unescapePropertyName(propertyPath.substring(startIndex, i)));
            startIndex = i + 1;
        }
        propertyNames.add((Object)PropertyPathHelper.unescapePropertyName(propertyPath.substring(startIndex)));
        return propertyNames.build();
    }

    public static StringBuilder escapePropertyName(StringBuilder stringBuilder, PropertyName propertyName) {
        String stringPropertyName = propertyName.string();
        for (int i = 0; i < stringPropertyName.length(); ++i) {
            char ch = stringPropertyName.charAt(i);
            if (ch == '.' || ch == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(ch);
        }
        return stringBuilder;
    }

    public static StringBuilder escapePropertyNamePrefix(StringBuilder stringBuilder, PropertyName propertyName) {
        return PropertyPathHelper.escapePropertyName(stringBuilder, propertyName).append('.');
    }

    public static String escapePropertyName(PropertyName propertyName) {
        StringBuilder stringBuilder = new StringBuilder();
        PropertyPathHelper.escapePropertyName(stringBuilder, propertyName);
        return stringBuilder.toString();
    }

    private static ByteString unescapePropertyName(ByteString propertyName) {
        byte[] unescaped = new byte[propertyName.size()];
        int i = 0;
        boolean inEscapeSequence = false;
        boolean hasEscaping = false;
        ByteString.ByteIterator byteIterator = propertyName.iterator();
        while (byteIterator.hasNext()) {
            byte b = (Byte)byteIterator.next();
            if (!inEscapeSequence && b == 92) {
                hasEscaping = true;
                inEscapeSequence = true;
                continue;
            }
            inEscapeSequence = false;
            unescaped[i++] = b;
        }
        return hasEscaping ? ByteString.copyFrom((byte[])unescaped, (int)0, (int)i) : propertyName;
    }
}

