/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.cloudv1;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.rep.Lookup;
import com.google.apphosting.datastore.rep.Mutation;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPathHelper;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.rep.Write;
import com.google.apphosting.datastore.rep.WriteHelper;
import com.google.apphosting.datastore.service.appengv3.TransactionConverter;
import com.google.apphosting.datastore.service.cloudv1.EntityV3V1Converter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nullable;

public class CloudDatastoreV1ToRepConverter {
    private static final PropertyMask KEY_ONLY = new PropertyMask(true, Collections.emptyMap());
    protected final TransactionConverter transactionConverter;
    private final Supplier<Boolean> allowPartialUpdates;
    private final Supplier<Boolean> allowPartialReads;

    public CloudDatastoreV1ToRepConverter(TransactionConverter transactionConverter, Supplier<Boolean> allowPartialUpdates, Supplier<Boolean> allowPartialReads) {
        this.transactionConverter = transactionConverter;
        this.allowPartialUpdates = allowPartialUpdates;
        this.allowPartialReads = allowPartialReads;
    }

    public CloudDatastoreV1ToRepConverter(TransactionConverter transactionConverter, boolean allowPartialUpdates, boolean allowPartialReads) {
        this(transactionConverter, (Supplier<Boolean>)Suppliers.ofInstance((Object)allowPartialUpdates), (Supplier<Boolean>)Suppliers.ofInstance((Object)allowPartialReads));
    }

    public Lookup toLookup(ProjectIdAppIdResolver resolver, LookupRequestOrBuilder req, @Nullable ByteString newTxnBytes) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!req.hasPropertyMask() || (Boolean)this.allowPartialReads.get() != false, "setting a property mask on a lookup is not allowed", new Object[0]);
        ReadOptions.ConsistencyTypeCase consistencyType = req.getReadOptions().getConsistencyTypeCase();
        Preconditions.checkArgument((newTxnBytes != null == (consistencyType == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION) ? 1 : 0) != 0);
        Lookup.Builder builder = Lookup.builder().allowDefer(true);
        block0 : switch (consistencyType) {
            case CONSISTENCYTYPE_NOT_SET: {
                break;
            }
            case NEW_TRANSACTION: {
                builder.transaction(this.transactionConverter.toTransactionHandle(newTxnBytes));
                break;
            }
            case TRANSACTION: {
                builder.transaction(this.transactionConverter.toTransactionHandle(req.getReadOptions().getTransaction()));
                break;
            }
            case READ_CONSISTENCY: {
                ReadOptions.ReadConsistency readConsistency = req.getReadOptionsOrBuilder().getReadConsistency();
                switch (readConsistency) {
                    case READ_CONSISTENCY_UNSPECIFIED: 
                    case STRONG: {
                        break block0;
                    }
                    case EVENTUAL: {
                        builder.isStrong(false);
                        builder.allowFailover(true);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Unhandled read consistency: %s", readConsistency.name()));
            }
            default: {
                throw new IllegalArgumentException(String.format("Unhandled consistency type: %s", consistencyType.name()));
            }
        }
        ImmutableList.Builder v3Keys = ImmutableList.builder();
        for (Key key : req.getKeysList()) {
            v3Keys.add((Object)EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)key));
        }
        builder.keys((Iterable<OnestoreEntity.Reference>)v3Keys.build());
        if (req.hasPropertyMask()) {
            builder.propertyMask(this.toPropertyMask(req.getPropertyMask()));
        }
        return builder.build();
    }

    public PropertyMask toPropertyMask(com.google.appengine.repackaged.com.google.datastore.v1.PropertyMask propertyMask) throws InvalidConversionException {
        LinkedList<ListIterator<ByteString>> paths = new LinkedList<ListIterator<ByteString>>();
        for (ByteString path : propertyMask.getPathsList().asByteStringList()) {
            paths.add((ListIterator<ByteString>)PropertyPathHelper.unescapePropertyPath(path).listIterator());
        }
        return this.toPropertyMask(paths).merge(KEY_ONLY);
    }

    private PropertyMask toPropertyMask(Collection<ListIterator<ByteString>> paths) throws InvalidConversionException {
        boolean key = false;
        HashMap<PropertyName, PropertyMask> nestedMasks = new HashMap<PropertyName, PropertyMask>();
        HashMultimap nestedPaths = HashMultimap.create();
        for (ListIterator<ByteString> listIterator : paths) {
            PropertyName propertyName = PropertyName.from(listIterator.next().toByteArray());
            if (propertyName.special() == SpecialPropertyDescriptor.KEY) {
                InvalidConversionException.checkConversion(!listIterator.hasNext(), "a property path in a field mask cannot traverse the %s property", SpecialPropertyDescriptor.KEY.getPropertyName());
                key = true;
                continue;
            }
            if (!listIterator.hasNext()) {
                nestedMasks.put(propertyName, PropertyMask.FULL);
                nestedPaths.removeAll((Object)propertyName);
                continue;
            }
            if (nestedMasks.containsKey(propertyName)) continue;
            nestedPaths.put((Object)propertyName, listIterator);
        }
        for (Map.Entry entry : nestedPaths.asMap().entrySet()) {
            nestedMasks.put((PropertyName)entry.getKey(), this.toPropertyMask((Collection)entry.getValue()));
        }
        return new PropertyMask(key, nestedMasks);
    }

    public ImmutableList<Mutation> toMutationList(ProjectIdAppIdResolver resolver, List<com.google.appengine.repackaged.com.google.datastore.v1.Mutation> requestMutations) throws InvalidConversionException {
        ImmutableList.Builder internalMutations = ImmutableList.builder();
        block15: for (com.google.appengine.repackaged.com.google.datastore.v1.Mutation mutation : requestMutations) {
            Long baseVersion = null;
            switch (mutation.getConflictDetectionStrategyCase()) {
                case CONFLICTDETECTIONSTRATEGY_NOT_SET: {
                    InvalidConversionException.checkConversion(mutation.getConflictResolutionStrategy() == Mutation.ConflictResolutionStrategy.STRATEGY_UNSPECIFIED, "cannot set a conflict resolution strategy if no detection strategy was set", new Object[0]);
                    break;
                }
                case BASE_VERSION: {
                    baseVersion = mutation.getBaseVersion();
                    InvalidConversionException.checkConversion(baseVersion >= 0L, "Invalid base_version: %d, it should be >= 0", baseVersion);
                    break;
                }
                default: {
                    throw new InvalidConversionException("Unknown conflict detection strategy.");
                }
            }
            Mutation.ConflictResolutionStrategy resolutionStrategy = null;
            if (baseVersion != null) {
                switch (mutation.getConflictResolutionStrategy()) {
                    case STRATEGY_UNSPECIFIED: 
                    case SERVER_VALUE: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.SERVER_VALUE;
                        break;
                    }
                    case CLIENT_VALUE: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.CLIENT_VALUE;
                        break;
                    }
                    case FAIL: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.FAIL;
                        break;
                    }
                    default: {
                        throw new InvalidConversionException("Unknown conflict resolution strategy.");
                    }
                }
            }
            InvalidConversionException.checkConversion(!mutation.hasPropertyMask() || (Boolean)this.allowPartialUpdates.get() != false, "setting a property mask on a mutation is not allowed", new Object[0]);
            PropertyMask mask = mutation.hasPropertyMask() ? this.toPropertyMask(mutation.getPropertyMask()) : PropertyMask.FULL;
            switch (mutation.getOperationCase()) {
                case INSERT: {
                    internalMutations.add((Object)Mutation.of(Mutation.Op.INSERT, EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)mutation.getInsert()), mask, baseVersion, resolutionStrategy));
                    continue block15;
                }
                case UPDATE: {
                    internalMutations.add((Object)Mutation.of(Mutation.Op.UPDATE, EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)mutation.getUpdate()), mask, baseVersion, resolutionStrategy));
                    continue block15;
                }
                case UPSERT: {
                    internalMutations.add((Object)Mutation.of(Mutation.Op.UPSERT, EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)mutation.getUpsert()), mask, baseVersion, resolutionStrategy));
                    continue block15;
                }
                case DELETE: {
                    internalMutations.add((Object)Mutation.of(Mutation.Op.DELETE, EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)mutation.getDelete()), baseVersion, resolutionStrategy));
                    continue block15;
                }
            }
            throw new InvalidConversionException("Mutation is missing operation.");
        }
        return internalMutations.build();
    }

    public Write.Builder toWrite(boolean trusted, boolean markChanges, ProjectIdAppIdResolver resolver, CommitRequestOrBuilder request) throws InvalidConversionException {
        Write.Builder write = WriteHelper.toWrite(trusted, markChanges, this.toMutationList(resolver, request.getMutationsList()));
        if (request.getTransactionSelectorCase() == CommitRequest.TransactionSelectorCase.TRANSACTION) {
            write.transaction(this.transactionConverter.toTransactionHandle(request.getTransaction()));
        }
        return write;
    }
}

