/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.cloudv1;

import com.google.apphosting.datastore.exception.ValidationException;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.service.common.DatastoreHelper;

public final class CloudV1DatabaseRefValidator {
    public static final CloudV1DatabaseRefValidator INSTANCE = new CloudV1DatabaseRefValidator();

    private CloudV1DatabaseRefValidator() {
    }

    public void validateDatabaseRefMatches(DatabaseRef requestInternalDatabase, String projectId, String databaseId) throws ValidationException {
        DatabaseRef other = this.createAndValidateDatabaseRef(projectId, databaseId);
        ValidationException.validateAssertion(other.isEmpty() || requestInternalDatabase.equals(other), "%s%s vs. %s", "mismatched databases within request: ", requestInternalDatabase, other);
    }

    private DatabaseRef createAndValidateDatabaseRef(String projectId, String databaseId) throws ValidationException {
        if (!projectId.isEmpty()) {
            ValidationException.validateAssertion(DatastoreHelper.PROJECT_ID_REGEX.matcher(projectId).matches(), "\"%s\" is an invalid %s.", projectId, "project id");
        }
        if (!databaseId.isEmpty()) {
            ValidationException.validateAssertion(DatastoreHelper.DATABASE_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", databaseId, "database id");
        }
        return DatabaseRef.createWithUnknownCluster(projectId, databaseId);
    }

    public DatabaseRef createAndValidateRequiredDatabaseRef(String projectId, String databaseId) throws ValidationException {
        ValidationException.validateAssertion(!projectId.isEmpty(), "missing project id in header", new Object[0]);
        return this.createAndValidateDatabaseRef(projectId, databaseId);
    }
}

