/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.TimestampOrBuilder;
import com.google.apphosting.datastore.exception.ValidationException;

public final class ValidationUtils {
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    public static final long RFC_3339_MIN_MICROSECONDS_INCLUSIVE = -62135596800000000L;
    public static final long RFC_3339_MAX_MICROSECONDS_INCLUSIVE = 253402300799999999L;
    public static final ValidationUtils INSTANCE = new ValidationUtils();

    private ValidationUtils() {
    }

    public void validateStringUtf8(ByteString byteString, String desc) throws ValidationException {
        ValidationException.validateAssertion(byteString.isValidUtf8(), "The %s is not valid UTF-8.", desc);
    }

    public void validateTimestamp(TimestampOrBuilder timestamp) throws ValidationException {
        ValidationException.validateAssertion(timestamp.getNanos() >= 0 && timestamp.getNanos() < 1000000000, "Timestamp nanos exceeds limit for field", new Object[0]);
        ValidationException.validateAssertion(this.isInRfc3339Bounds(timestamp.getSeconds() * 1000000L), "Timestamp seconds exceeds limit for field", new Object[0]);
    }

    public boolean isInRfc3339Bounds(long microseconds) {
        return microseconds >= -62135596800000000L && microseconds <= 253402300799999999L;
    }
}

