/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.datastore.rep.IdAllocationPolicy;
import com.google.apphosting.datastore.rep.Mutation;
import com.google.apphosting.datastore.rep.Write;
import java.util.Arrays;
import javax.annotation.Nullable;

final class AutoValue_Write
extends Write {
    private final Long transaction;
    private final ImmutableList<Mutation> mutations;
    private final int[] originalMutationsMap;
    private final boolean isTrusted;
    private final boolean markChanges;
    private final IdAllocationPolicy idPolicy;

    private AutoValue_Write(@Nullable Long transaction, ImmutableList<Mutation> mutations, @Nullable int[] originalMutationsMap, boolean isTrusted, boolean markChanges, @Nullable IdAllocationPolicy idPolicy) {
        this.transaction = transaction;
        this.mutations = mutations;
        this.originalMutationsMap = originalMutationsMap;
        this.isTrusted = isTrusted;
        this.markChanges = markChanges;
        this.idPolicy = idPolicy;
    }

    @Override
    @Nullable
    public Long transaction() {
        return this.transaction;
    }

    @Override
    public ImmutableList<Mutation> mutations() {
        return this.mutations;
    }

    @Override
    @Nullable
    public int[] originalMutationsMap() {
        return this.originalMutationsMap;
    }

    @Override
    public boolean isTrusted() {
        return this.isTrusted;
    }

    @Override
    public boolean markChanges() {
        return this.markChanges;
    }

    @Override
    @Nullable
    public IdAllocationPolicy idPolicy() {
        return this.idPolicy;
    }

    public String toString() {
        String string = String.valueOf(this.transaction);
        String string2 = String.valueOf(this.mutations);
        String string3 = String.valueOf(Arrays.toString(this.originalMutationsMap));
        boolean bl = this.isTrusted;
        boolean bl2 = this.markChanges;
        String string4 = String.valueOf((Object)this.idPolicy);
        return new StringBuilder(101 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Write{transaction=").append(string).append(", mutations=").append(string2).append(", originalMutationsMap=").append(string3).append(", isTrusted=").append(bl).append(", markChanges=").append(bl2).append(", idPolicy=").append(string4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Write) {
            Write that = (Write)o;
            return (this.transaction == null ? that.transaction() == null : this.transaction.equals(that.transaction())) && this.mutations.equals(that.mutations()) && Arrays.equals(this.originalMutationsMap, that instanceof AutoValue_Write ? ((AutoValue_Write)that).originalMutationsMap : that.originalMutationsMap()) && this.isTrusted == that.isTrusted() && this.markChanges == that.markChanges() && (this.idPolicy == null ? that.idPolicy() == null : this.idPolicy.equals((Object)that.idPolicy()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.transaction == null ? 0 : this.transaction.hashCode();
        h *= 1000003;
        h ^= this.mutations.hashCode();
        h *= 1000003;
        h ^= Arrays.hashCode(this.originalMutationsMap);
        h *= 1000003;
        h ^= this.isTrusted ? 1231 : 1237;
        h *= 1000003;
        h ^= this.markChanges ? 1231 : 1237;
        h *= 1000003;
        return h ^= this.idPolicy == null ? 0 : this.idPolicy.hashCode();
    }

    static final class Builder
    extends Write.Builder {
        private Long transaction;
        private ImmutableList<Mutation> mutations;
        private int[] originalMutationsMap;
        private Boolean isTrusted;
        private Boolean markChanges;
        private IdAllocationPolicy idPolicy;

        Builder() {
        }

        private Builder(Write source) {
            this.transaction = source.transaction();
            this.mutations = source.mutations();
            this.originalMutationsMap = source.originalMutationsMap();
            this.isTrusted = source.isTrusted();
            this.markChanges = source.markChanges();
            this.idPolicy = source.idPolicy();
        }

        @Override
        public Write.Builder transaction(@Nullable Long transaction) {
            this.transaction = transaction;
            return this;
        }

        @Override
        public Write.Builder mutations(Iterable<Mutation> mutations) {
            this.mutations = ImmutableList.copyOf(mutations);
            return this;
        }

        @Override
        public ImmutableList<Mutation> mutations() {
            if (this.mutations == null) {
                throw new IllegalStateException("Property \"mutations\" has not been set");
            }
            return this.mutations;
        }

        @Override
        public Write.Builder originalMutationsMap(@Nullable int[] originalMutationsMap) {
            this.originalMutationsMap = originalMutationsMap;
            return this;
        }

        @Override
        public Write.Builder isTrusted(boolean isTrusted) {
            this.isTrusted = isTrusted;
            return this;
        }

        @Override
        public Write.Builder markChanges(boolean markChanges) {
            this.markChanges = markChanges;
            return this;
        }

        @Override
        public Write.Builder idPolicy(@Nullable IdAllocationPolicy idPolicy) {
            this.idPolicy = idPolicy;
            return this;
        }

        @Override
        public Write build() {
            String missing = "";
            if (this.mutations == null) {
                missing = String.valueOf(missing).concat(" mutations");
            }
            if (this.isTrusted == null) {
                missing = String.valueOf(missing).concat(" isTrusted");
            }
            if (this.markChanges == null) {
                missing = String.valueOf(missing).concat(" markChanges");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_Write(this.transaction, this.mutations, this.originalMutationsMap, this.isTrusted, this.markChanges, this.idPolicy);
        }
    }
}

