/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;

public enum IdAllocationPolicy {
    SEQUENTIAL(1){

        @Override
        public long getMaximumCounterValue() {
            return 0xFFFFFFFFFFFFFL;
        }

        @Override
        public long counterToId(long counter) {
            return counter;
        }

        @Override
        public long idToCounter(long id) {
            return id;
        }

        @Override
        public boolean containsId(long id) {
            return id > 0L && id <= 0xFFFFFFFFFFFFFL;
        }
    }
    ,
    SCATTERED(2){

        @Override
        public long getMaximumCounterValue() {
            return 0x7FFFFFFFFFFFFL;
        }

        @Override
        public boolean containsId(long id) {
            return id > 0xFFFFFFFFFFFFFL && id <= 0x17FFFFFFFFFFFFL;
        }

        @Override
        public long counterToId(long counter) {
            if (counter > 0x7FFFFFFFFFFFFL) {
                throw new IndexOutOfBoundsException("Maximum scattered ID counter value exceeded");
            }
            return 0x10000000000000L + Long.reverse(counter << 13);
        }

        @Override
        public long idToCounter(long id) {
            Preconditions.checkArgument((boolean)this.containsId(id), (Object)"ID does not conform to scattered ID allocation policy");
            return Long.reverse(id) >>> 13;
        }
    };

    private static final long MAX_SEQUENTIAL_BIT = 52L;
    private static final long MAX_SEQUENTIAL_COUNTER_VALUE = 0xFFFFFFFFFFFFFL;
    private static final long MAX_SEQUENTIAL_ID = 0xFFFFFFFFFFFFFL;
    private static final long MAX_SCATTERED_COUNTER_VALUE = 0x7FFFFFFFFFFFFL;
    private static final long MAX_SCATTERED_ID = 0x17FFFFFFFFFFFFL;
    private static final long SCATTER_SHIFT = 13L;
    private final int id;

    public abstract boolean containsId(long var1);

    public abstract long getMaximumCounterValue();

    public abstract long counterToId(long var1);

    public abstract long idToCounter(long var1);

    private IdAllocationPolicy(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }
}

