/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.rep.Mutation;
import com.google.apphosting.datastore.rep.MutationHelper;
import com.google.apphosting.datastore.rep.ReferencePaths;
import com.google.apphosting.datastore.rep.Write;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public final class WriteHelper {
    private WriteHelper() {
    }

    public static Write.Builder toWrite(boolean trusted, boolean markChanges, List<Mutation> mutationsList) throws InvalidConversionException {
        Write.Builder write = Write.builder();
        int[] mutationMap = new int[mutationsList.size()];
        mutationsList = WriteHelper.collapseMutations(mutationsList, mutationMap);
        write.mutations(mutationsList).originalMutationsMap(mutationMap).isTrusted(trusted).markChanges(markChanges);
        return write;
    }

    private static ImmutableList<Mutation> collapseMutations(List<Mutation> originalMutations, int[] originalMutationsMap) throws InvalidConversionException {
        ArrayList collapsedMutations = Lists.newArrayListWithCapacity((int)originalMutations.size());
        HashMap collapsedMutationMapping = Maps.newHashMapWithExpectedSize((int)originalMutations.size());
        for (int i = 0; i < originalMutations.size(); ++i) {
            Mutation mutation = originalMutations.get(i);
            OnestoreEntity.Reference key = mutation.key();
            if (ReferencePaths.hasIncompleteLastElement(key)) {
                originalMutationsMap[i] = collapsedMutations.size();
                collapsedMutations.add(mutation);
                continue;
            }
            Integer collapsedMutationsIndex = (Integer)collapsedMutationMapping.get(key);
            if (collapsedMutationsIndex == null) {
                collapsedMutationsIndex = collapsedMutations.size();
                collapsedMutations.add(mutation);
                collapsedMutationMapping.put(key, collapsedMutationsIndex);
            } else {
                Mutation previousMutation = (Mutation)collapsedMutations.get(collapsedMutationsIndex);
                Mutation collapsedMutation = MutationHelper.collapse(previousMutation, mutation);
                collapsedMutations.set(collapsedMutationsIndex, collapsedMutation);
            }
            originalMutationsMap[i] = collapsedMutationsIndex;
        }
        return ImmutableList.copyOf((Collection)collapsedMutations);
    }
}

