/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.appengv4;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResultOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatchOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.service.appengv4.AppEngV4ToCloudDatastoreV1Converter;
import com.google.apphosting.datastore.service.appengv4.EntityV4Converter;
import com.google.apphosting.datastore.service.cloudv1.CloudDatastoreV1ToAppEngV3Converter;
import com.google.apphosting.datastore.service.common.EquivalentMessageConverter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.List;

public class AppEngV4ToAppEngV3Converter {
    private static final Function<OnestoreEntity.CompositeIndex, OnestoreEntity.CompositeIndex> V4_TO_V3_COMPOSITE_INDEX_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.parser());
    private final EntityV4Converter entityV4Converter;
    private final AppEngV4ToCloudDatastoreV1Converter appEngV4ToCloudDatastoreV1Converter;
    private final CloudDatastoreV1ToAppEngV3Converter cloudDatastoreV1ToAppEngV3Converter;

    public static OnestoreEntity.CompositeIndex toV3CompositeIndex(OnestoreEntity.CompositeIndex compositeIndex) {
        return (OnestoreEntity.CompositeIndex)V4_TO_V3_COMPOSITE_INDEX_CONVERTER.apply((Object)compositeIndex);
    }

    public AppEngV4ToAppEngV3Converter(EntityV4Converter entityConverter, AppEngV4ToCloudDatastoreV1Converter appEngV4ToCloudDatastoreV1Converter, CloudDatastoreV1ToAppEngV3Converter cloudDatastoreV1ToAppEngV3Converter) {
        this.entityV4Converter = entityConverter;
        this.appEngV4ToCloudDatastoreV1Converter = appEngV4ToCloudDatastoreV1Converter;
        this.cloudDatastoreV1ToAppEngV3Converter = cloudDatastoreV1ToAppEngV3Converter;
    }

    public ImmutableList<OnestoreEntity.CompositeIndex> toV3CompositeIndexes(List<OnestoreEntity.CompositeIndex> compositeIndexes) {
        return ImmutableList.copyOf((Collection)Lists.transform(compositeIndexes, V4_TO_V3_COMPOSITE_INDEX_CONVERTER));
    }

    public DatastorePb.Query toV3Query(EntityV4.PartitionIdOrBuilder partitionIdV4, DatastoreV4.QueryOrBuilder queryV4) throws InvalidConversionException {
        DatastorePb.Query queryV3 = this.cloudDatastoreV1ToAppEngV3Converter.toV3Query(ProjectIdAppIdResolver.IDENTITY, (PartitionIdOrBuilder)this.entityV4Converter.toV1PartitionId(ProjectIdAppIdResolver.IDENTITY, partitionIdV4), (QueryOrBuilder)this.appEngV4ToCloudDatastoreV1Converter.toV1Query(ProjectIdAppIdResolver.IDENTITY, queryV4).build());
        this.entityV4Converter.getUserValueObfuscator().obfuscate(queryV3);
        return queryV3;
    }

    public DatastorePb.QueryResult toV3QueryResult(DatastoreV4.QueryResultBatchOrBuilder batchV4) throws InvalidConversionException {
        DatastorePb.QueryResult queryResultV3 = this.cloudDatastoreV1ToAppEngV3Converter.toV3QueryResult(ProjectIdAppIdResolver.IDENTITY, (QueryResultBatchOrBuilder)this.appEngV4ToCloudDatastoreV1Converter.toV1QueryResultBatchMetadata(batchV4));
        for (DatastoreV4.EntityResult resultV4 : batchV4.getEntityResultList()) {
            OnestoreEntity.EntityProto entityV3 = this.entityV4Converter.toV3Entity((EntityV4.EntityOrBuilder)resultV4.getEntity());
            if (batchV4.getEntityResultType() != DatastoreV4.EntityResult.ResultType.FULL) {
                entityV3.setEntityGroup(OnestoreEntity.Path.IMMUTABLE_DEFAULT_INSTANCE);
            }
            queryResultV3.addResult(entityV3);
            if (resultV4.hasVersion()) {
                queryResultV3.addVersion(resultV4.getVersion());
            }
            if (!resultV4.hasCursor()) continue;
            queryResultV3.addResultCompiledCursor(this.v4CursorBytesToV3CompiledCursor(resultV4.getCursor()));
        }
        int numOfVersions = queryResultV3.versionSize();
        InvalidConversionException.checkConversion(numOfVersions == 0 || numOfVersions == batchV4.getEntityResultCount(), "query results contain inconsistent number of versions", new Object[0]);
        return queryResultV3;
    }

    public DatastorePb.GetResponse.Entity toV3Entity(DatastoreV4.EntityResultOrBuilder entityResult, boolean isMissing) throws InvalidConversionException {
        DatastorePb.GetResponse.Entity entityV3 = this.cloudDatastoreV1ToAppEngV3Converter.toV3Entity(ProjectIdAppIdResolver.IDENTITY, (EntityResultOrBuilder)this.appEngV4ToCloudDatastoreV1Converter.toV1EntityResult(ProjectIdAppIdResolver.IDENTITY, entityResult), isMissing);
        if (this.entityV4Converter.getPreservePropertyOrderInV4() && !isMissing) {
            entityV3.setEntity(this.entityV4Converter.toV3Entity((EntityV4.EntityOrBuilder)entityResult.getEntity()));
        }
        if (entityResult.hasVersion()) {
            entityV3.setVersion(entityResult.getVersion());
        }
        return entityV3;
    }

    private DatastorePb.CompiledCursor v4CursorBytesToV3CompiledCursor(ByteString queryCursorBytesV4) throws InvalidConversionException {
        try {
            return (DatastorePb.CompiledCursor)DatastorePb.CompiledCursor.parser().parseFrom(queryCursorBytesV4);
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }
}

